/*
    "parser.cpp"   - Text file parser class
     
    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#include <stdio.h>
#include <string.h>
#include "parser.h"

namespace dds {

    /* Base parser class
       ----------------- */

Parser::Parser(ifstream *ifs, Uint32 maxlen)
{
    initialize();
    m_in = ifs;
    m_maxline = maxlen;
    m_text = new char[m_maxline];
}

Parser::~Parser()
{
    delete[] m_text;
}

bool Parser::comment() const
{
    if( (m_text[0] == ' ') || (m_text[0] == '#') )
        return(true);
    else
        return(false);
}

bool Parser::getline()
{
    if( m_in->eof() )
        return(false);

    m_in->getline(m_text,m_maxline);
    m_line++;

    if( comment() )
        return(getline());

//    cleanup_text();
    update_level();

    return(true);
}

char* Parser::arg(int32 n, char separator)
{
    char *buffer = m_text;
    while( (*buffer) == ' ' )
        buffer++;

    while( n-- ) {
        while( (*buffer) != ' ' )
            buffer++;
        while( (*buffer) == ' ' )
            buffer++;
    }

    char *temp = buffer;
    while( ((*temp) != ' ') && *temp )
        temp++;

    char *dest = new char[temp-buffer+1];
    memcpy(dest,buffer,temp-buffer);
    dest[temp-buffer] = '\0';
    return(dest);
}

void Parser::initialize()
{
    m_in = NULL;
    m_text = NULL;
    m_level = 0;
    m_line = 0;
    m_maxline = 0;
}

void Parser::cleanup_text() // UNTESTED
{
    char *beg = m_text;

    while( (*beg) == ' ' && beg )
        beg++;

    char *end = m_text+strlen(m_text);
    while( (*end) == ' ' && end )
        end--;

    strncpy(m_text,beg,end-beg);
}

}   // namespace dds
