/*
    "parser.h"   - Text Parser

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_PARSER_H
#define _DDS_PARSER_H

#include <fstream.h>
#include "types.h"
#include <SDL/SDL_types.h>

namespace dds {

    /* Base parser class */

class Parser {
public:
	// setup
	Parser(ifstream *ifs, Uint32 maxlen = 1024);
	virtual ~Parser();

	// read lines
    bool getline();

	// information
	inline const int32 line() const { return(m_line); }
	inline const int32 level() const { return(m_level); }
	inline const char* text() const { return(m_text); }
    // true if line is a comment (i.e not data)
    virtual bool comment() const;

    // TODO: more argument functions
	char* arg(int32 n, char separator = ' ');

protected:
    void initialize();
    // TODO: cleanup_text()
    void cleanup_text();
    virtual void update_level() {}

    int32 m_line;
    int32 m_level;
    int32 m_maxline;
    char* m_text;
    ifstream *m_in;
};


}   // namespace dds

#endif  // _DDS_PARSER_H
