/*
    "sound.cpp"   - <FMOD> Sound interface classes

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#include <stdio.h>
#include <fstream.h>
#include "sound.h"
#include "error.h"

namespace dds {

    /*  Stream class
        ------------ */

Stream::Stream(const char name[])
{
    m_stream = NULL;

    m_stream = FSOUND_Stream_OpenFile(name,0,0);

    if( !m_stream )
        throw Error("Stream::Stream()","FSOUND_Stream_OpenFile() failed:",name);

    m_lengthms = FSOUND_Stream_GetLengthMs(m_stream);
}

Stream::~Stream()
{
    stop();
    FSOUND_Stream_Close(m_stream);
}

bool Stream::play()
{
    return( (bool)FSOUND_Stream_Play(FSOUND_FREE,m_stream) );
}

bool Stream::pause(bool state)
{
    return( (bool)FSOUND_Stream_SetPaused(m_stream,state) );
}

bool Stream::stop()
{
    return( (bool)FSOUND_Stream_Stop(m_stream) );
}

bool Stream::time(int32 ms)
{
    if( ms <= m_lengthms )
        return( (bool)FSOUND_Stream_SetTime(m_stream,ms) );
    else
        return(false);
}

int32 Stream::time()
{
    return( FSOUND_Stream_GetTime(m_stream) );
}

    /*  Sample class
        ------------ */

Sample::Sample(const char name[])
{
    m_sample = FSOUND_Sample_Load(FSOUND_FREE,name,0,0);

    if( !m_sample )
        throw Error("Sample::Sample()","FSOUND_Sample_Load() failed:",name);
}

Sample::~Sample()
{
    stop();
    FSOUND_Sample_Free(m_sample);
}

bool Sample::play()
{
    m_channel = FSOUND_PlaySound(FSOUND_FREE,m_sample);

    return((bool)m_channel);
}

bool Sample::pause(bool state)
{
    // tada...
}

bool Sample::stop()
{
    return( (bool)FSOUND_StopSound(m_channel) );
}

bool Sample::time(int32 ms)
{
    // babomm.
}

int32 Sample::time()
{
    return( FSOUND_GetCurrentPosition(m_channel) );
}

    /*  Music class
        ----------- */

Music::Music(const char name[])
{
    m_music = FMUSIC_LoadSong(name);

    if( !m_music )
        throw Error("Music::Music()","FMUSIC_LoadSong() failed:",name);
}

Music::~Music()
{
    stop();
    FMUSIC_FreeSong(m_music);
}

bool Music::play()
{
    return( (bool)FMUSIC_PlaySong(m_music) );
}

bool Music::pause(bool state)
{
    return( (bool)FMUSIC_SetPaused(m_music,state) );
}

bool Music::stop()
{
    return( (bool)FMUSIC_StopSong(m_music) );
}


}   // namespace dds

