/*
    "sound.h"   - FMOD/C++ Sound interface classes

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_SOUND_H
#define _DDS_SOUND_H

#if defined(__GNUC__)       // is this sufficent?
# define PLATFORM_LINUX     // stupid FMOD doesn't do this itself
#endif

#include <fmod.h>
#include <fmod_errors.h>
#include "types.h"

namespace dds {

    /*  Sound class (base) */

class Sound {

public:
    virtual ~Sound() {};

    // playback
    virtual bool play() = 0;
    virtual bool pause(bool state) = 0;
    virtual bool stop() = 0;

protected:
};

    /*  Stream class  */

class Stream: public Sound {

public:
    Stream(const char name[]);
    ~Stream();

    // playback
    bool play();
    bool pause(bool state);
    bool stop();

    // information
    bool time(int32 ms);
    int32 time();

private:
    FSOUND_STREAM *m_stream;
    int32 m_lengthms;
};

   /*  Sample class  */

class Sample: public Sound {

public:
    Sample(const char name[]);
    ~Sample();

    // playback
    bool play();
    bool pause(bool state);
    bool stop();

    // information
    bool time(int32 ms);
    int32 time();

private:
    FSOUND_SAMPLE *m_sample;
    int m_channel;
    int32 m_lengthms;
};


    /*  Music class  */

class Music: public Sound {

public:
    // setup
    Music(const char name[]);
    ~Music();

    // playback
    bool play();
    bool pause(bool state);
    bool stop();

    // information
    int order() { return( FMUSIC_GetOrder(m_music) ); }
    int pattern() { return( FMUSIC_GetPattern(m_music) ); }
    int row() { return( FMUSIC_GetRow(m_music) ); }

private:
    FMUSIC_MODULE *m_music;
};

}   // namespace dds

#endif  // _DDS_SOUND_H
