/*
    "sprite.h"   - Sprite system
 
    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks
 
    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/
#include "types.h"
#include "sdlbase.h"
#include "image.h"

#ifndef _M_SPRITE_H
#define _M_SPRITE_H

namespace dds {

struct muudata {
    char8 *data;
    int32 width;
};

struct muuTransparencyInterface {
    int32 width;
    int32 height;
    muudata source;
    muudata destination;
    char8 grade;
    int32 mask;
};

typedef void (*muuTransparencyPtr)(muuTransparencyInterface *);


    /* Blitter class */

class Blitter {
public:
    enum FX_CODE {
        C_CODE = 0,
        MMX_CODE
    };

    Blitter();
    ~Blitter() {};

    void add(int xpos, int ypos, BaseSurface *sprite, BaseSurface *dest);
    void addgrade(int xpos, int ypos, char8 grade, BaseSurface *sprite, BaseSurface *dest);

    void sub(int xpos, int ypos, BaseSurface *sprite, BaseSurface *dest);

    void mask(int xpos, int ypos, int32 bg, BaseSurface *sprite, BaseSurface *dest);

private:
    muuTransparencyPtr add_pixels_32;
    muuTransparencyPtr add_pixels_grade_32;
    muuTransparencyPtr add_pixels_16;
    muuTransparencyPtr add_pixels_grade_16;

    muuTransparencyPtr sub_pixels_32;
    muuTransparencyPtr sub_pixels_16;

    muuTransparencyPtr mask_pixels_32;
    muuTransparencyPtr mask_pixels_16;

    muuTransparencyInterface *trans_clip(signed int, signed int, int32, int32,
                                         int32, int32, int32, int32, char8, char8*, char8*);

    // Are there already an instance of Blitter in memory?
    static bool instance;
};


    /* Sprite class */

class Sprite : public Blitter {
public:
    Sprite(char *script, const Format &format);
    ~Sprite();

    // drawing
    void draw(Uint32 x, Uint32 y, Uint32 frame_num, BaseSurface *surface);
    inline float ratio(Uint32 frame_num) const {return(life_ratio[frame_num]);};
    inline Uint32 frames() const {return(frame_count);};
    inline BaseSurface* frame_no(Uint32 frame_) const {return(frame[frame_]);};

protected:
    BaseSurface **frame;
    Uint32 frame_count;
    float *life_ratio;
};



/* External code interface
   --------------------------- */
extern "C"
{
#ifdef __GNUC__
    void mmx_add_pixels_32(muuTransparencyInterface *) __attribute__ ((alias ("_mmx_add_pixels_32")));
    void mmx_add_pixels_grade_32(muuTransparencyInterface *) __attribute__ ((alias ("_mmx_add_pixels_grade_32")));
    void mmx_add_pixels_16(muuTransparencyInterface *) __attribute__ ((alias ("_mmx_add_pixels_16")));
    void mmx_add_pixels_grade_16(muuTransparencyInterface *) __attribute__ ((alias ("_mmx_add_pixels_grade_16")));

    void mmx_sub_pixels_32(muuTransparencyInterface *) __attribute__ ((alias ("_mmx_sub_pixels_32")));
    void mmx_sub_pixels_16(muuTransparencyInterface *) __attribute__ ((alias ("_mmx_sub_pixels_16")));
#else
    void mmx_add_pixels_32(muuTransparencyInterface *);
    void mmx_add_pixels_grade_32(muuTransparencyInterface *);
    void mmx_add_pixels_16(muuTransparencyInterface *);
    void mmx_add_pixels_grade_16(muuTransparencyInterface *);

    void mmx_sub_pixels_32(muuTransparencyInterface *);
    void mmx_sub_pixels_16(muuTransparencyInterface *);
#endif
}

}   // namespace dds

#endif  // _M_SPRITE_H