/*
    "surface.cpp"   - <SDL/C++> Surface class
     
    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#include "sdlbase.h"
#include "surface.h"
#include "error.h"
#include "types.h"

namespace dds {

    /*  Surface class
        ------------- */

Surface::Surface(int32 width,int32 height,const Format &format,const int32 SDLflags)
{
    m_surface = SDL_CreateRGBSurface(SDLflags,width,height,format.depth(),
                                     format.rmask(),format.gmask(),format.bmask(),format.amask());

    if( !m_surface ) {
        throw Error("Surface::Surface()","Unable to allocate SDL_Surface");
    }

    unlock();
}

Surface::Surface(SDL_Surface *surface)
{
    if( surface )
        m_surface = surface;
    else
        throw Error("Surface::Surface()","Attempt to assign empty surface");

    unlock();
}

Surface::~Surface()
{
}

Surface::Surface(BaseSurface *surface, const int32 SDLflags)
{
    if( surface ) {
        int32 width = surface->width();
        int32 height = surface->height();
        Format format = surface->format();
        m_surface = SDL_CreateRGBSurface(SDLflags,width,height,format.depth(), format.rmask(),format.gmask(),format.bmask(),format.amask());
        this->copy(surface);
    }
    else
        throw Error("Surface::Surface()","Attempt to clone empty surface");
}


}   // namespace dds
