/*
    "console.h"   - SDL/C++ GFX font class

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "gfxfont.h"
#include "error.h"

namespace dds {

GFXFont::GFXFont()
{
    for(int c=0;c<256;c++)
        letter[c] = NULL;
    d_width = d_height = 0;
    m_flags = 0;
    m_format = NULL;
}

GFXFont::GFXFont(const char dfs[], int32 flags)
{
    for(int c=0;c<256;c++)
        letter[c] = NULL;
    d_width = d_height = 0;

    m_flags = flags;
    m_format = NULL;

    try {
        read_dfs(dfs);
    }
    catch(Error &error) {
        throw Error("GFXFont::GFXFont()",error);
    }
}

GFXFont::GFXFont(const char dfs[], const Format &format, int32 flags)
{
    for(int c=0;c<256;c++)
        letter[c] = NULL;
    d_width = d_height = 0;

    m_flags = flags;
    m_format = new Format(format);

    try {
        read_dfs(dfs);
    }
    catch(Error &error) {
        throw Error("GFXFont::GFXFont()",error);
    }
}

GFXFont::~GFXFont()
{
    for(int c=0;c<256;c++)
        delete letter[c];

    delete m_format;
}

void GFXFont::colorkey(int32 key, int32 flags)
{
    for(int n=0;n<256;n++)
        if( letter[n] )
            letter[n]->colorkey(key,flags);
}

void GFXFont::alpha(char8 alpha, int32 flags)
{
    for(int n=0;n<256;n++)
        if( letter[n] )
            letter[n]->alpha(alpha,flags);
}

void GFXFont::assign(char n, const char img[])
{
    if( letter[n] != NULL )
        delete letter[n]; // reassign

    if( d_width || d_height )
        throw Error("GFXFont::assign()","Scaling not implemented yet");

    if( m_format )
        letter[n] = new Image(img,*m_format,m_flags);
    else
        letter[n] = new Image(img,m_flags);
}

void GFXFont::write(int px, int py, char text[], BaseSurface &dest)
{
    // TODO: rewrite! optimize!
    int length = strlen(text);
    int cx = px;
    for(int ch=0;ch<length;ch++) {
        if( letter[text[ch]] ) {
            Area area(cx,py,cx+letter[text[ch]]->width(),py+letter[text[ch]]->height());
            dest.copy(letter[text[ch]],letter[text[ch]]->area(),area);
            cx += letter[text[ch]]->width();
        }
    }
}

void GFXFont::read_dfs(const char script[])
{
    ifstream ifs(script,ios::in|ios::nocreate);

    if( !ifs.is_open() )
        throw Error("GFXFont::read_dfs()","Unable to load script:",script);

    DFSParser parser(&ifs);

    while( parser.getline() ) {
        if( !parser.comment() ) {
            char spr_num = 0;
            char *sprite = parser.arg(0);
            char *fname = parser.arg(1);

            if( strlen(sprite) == 1 )
                spr_num = sprite[0];
            else
                spr_num = atoi(sprite);

            assign(spr_num,fname);
            delete sprite;
            delete fname;
        }
    }
}

}   // namespace dds