/*
    "console.h"   - SDL/C++ GFX font class

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#include "sdlbase.h"
#include "parser.h"
#include "image.h"

#ifndef _DDS_GFXFONT_H
#define _DDS_GFXFONT_H

namespace dds {

    /* DFS file parser */

class DFSParser: public Parser {
public:
    DFSParser(ifstream *ifs) {
        m_in = ifs;
        m_maxline = 512;
        m_text = new char[m_maxline];
    };

    ~DFSParser() {
        delete []m_text;
    };

    bool comment() {
        if( (m_text[0] == '\0') || (m_text[0] == ' ') )
            return(true);
        else
            return(false);
    };
};

    /* GFXFont class */

class GFXFont {
public:
    // setup
    GFXFont();
    GFXFont(const char dfs[], int32 flags=SDL_HWSURFACE);
    GFXFont(const char dfs[], const Format &format, int32 flags=SDL_HWSURFACE);
    ~GFXFont();

    // set alpha & color keying (applies to loaded surfaces)
    void colorkey(int32 key, int32 flags=SDL_RLEACCEL|SDL_SRCCOLORKEY);
    void alpha(char8 alpha, int32 flags=SDL_RLEACCEL|SDL_SRCALPHA);

    // assignment
    void assign(char n, const char img[]);

    // typing
    void write(int px, int py, char text[], BaseSurface &dest);

private:
    void read_dfs(const char script[]);

    BaseSurface *letter[256];
    int32 d_width, d_height;

    // SDL surface parameters
    Format *m_format;
    int32 m_flags;
};


}   // namespace dds

#endif  // _DDS_GFXFONT_H
