/*
    "glbase.h"   - OpenGL base classes

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_GLBASE_H
#define _DDS_GLBASE_H

#ifdef _WIN32_
# include <windows.h>
#endif
#include <GL/gl.h>

    // stupid workaround
#ifdef GL_ARB_multitexture
# undef GL_ARB_multitexture
#endif
#include "glext.h"
#include "texture.h"

namespace dds {

    /* OpenGL extensions */
#ifdef GL_ARB_multitexture
    extern PFNGLACTIVETEXTUREARBPROC glActiveTextureARB_ext;
    extern PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB_ext;
    extern PFNGLMULTITEXCOORD2FVARBPROC glMultiTexCoord2fvARB_ext;
#endif
    extern GLint glMultiTexStages;
    extern GLint glMaxTextureSize;

    /* base Renderer class */

class BaseRenderer {
    /* todo:
        - more "texcoord" functions (with vectors, 1d,2d,3d,4d etc:)
  */
public:
    // setup
    virtual ~BaseRenderer() {};

        // highlevel
        // =========
    virtual Texture* loadtexture(const char *name, Texture::textureMip mipmap = Texture::nomip) = 0;
    virtual Texture* createtexture(BaseSurface *surface, Texture::textureMip mipmap = Texture::nomip) = 0;
//    virtual Texture* createtexture(..) = 0;
//    virtual Shader* createshader(..) = 0;
//    virtual Camera* createcamera(..) = 0;
//    virtual VertexBuffer* createvertexbuffer(..) = 0;

        // lowlevel
        // ========

    // clearing buffers
    virtual void clearColor(float r, float g, float b, float a = 0) = 0;
    virtual void clearDepth(float depth) = 0;
    virtual void clear(int32 mask) = 0;

    // color
    virtual void color(float r, float g, float b, float a = 0) = 0;
    virtual void color(char8 r, char8 g, char8 b, char8 a = 0) = 0;

    // texture
    virtual void texcoord(float u, float v, int32 stage = 0) = 0;

    // vertex
    virtual void vertex(double x, double y) = 0;
    virtual void vertex(double x, double y, double z) = 0;

    // normal
    virtual void normal(double nx, double ny, double nz) = 0;
};


}   // namespace dds

#endif  // _DDS_???_H
