/*
    "render.h"   - <OpenGL> Renderer

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_RENDER_H
#define _DDS_RENDER_H

#include "sdlbase.h"
#include "glbase.h"
#include "texture.h"
//#include "camera.h"
//#include "vector.h"
#include "list.h"

namespace dds {

    /* OpenGL renderer class */

class Renderer: public BaseRenderer {
    /* todo:
        - THIS MAY NEED A SERIOUS REWRITE (maybe...)
        - mesh interface: use vertex buffers and display lists
        - shader interface: multitexturing, blending
            + texturematrices (glMatrixMode)
        - stencil buffer implementation (shadows, 2Dfx's)
        - interface to a Camera class
            - matrixmode(...);
            - loadmatrix(class Matrix);
        - rendering should be done like this (maybe):
            1. register all meshes to be rendered next frame
                - mesh references are stored in lists and commonly used shaders are found
            2. call "Renderer::render()"
                - uses current camera - renderer->setcamera(...) - & bounding spheres for clipping
    */

public:
    // setup
    Renderer(DeviceInfo &info);
    Renderer(int width, int height, int bpp, int zbits, int stencilbits, BaseConsole &console);
    ~Renderer();

        // High-level
        // ==========
    Texture* loadtexture(const char *name, Texture::textureMip mipmap = Texture::nomip);
    Texture* createtexture(BaseSurface *surface, Texture::textureMip mipmap = Texture::nomip);
//    virtual Shader* createshader(..) = 0;
//    virtual Camera* createcamera(..) = 0;
//    virtual VertexBuffer* createvertexbuffer(..) = 0;

        // Low-level
        // =========

    // clearing buffers
    inline void clearColor(float r, float g, float b, float a = 0)
        { glClearColor(r,g,b,a); }
    inline void clearDepth(float depth)
        { glClearDepth(depth); }
    inline void clear(int32 mask)
        { glClear(mask); }

    // color
    inline void color(float r, float g, float b, float a = 0)
        { glColor4f(r,g,b,a); }
    inline void color(char8 r, char8 g, char8 b, char8 a = 0)
        { glColor4b(r,g,b,a); }

    // texture
    void texcoord(float u, float v, int32 stage = 0);

    // vertex
    inline void vertex(double x, double y)
        { glVertex2d(x,y); }
    void vertex(double x, double y, double z)
        { glVertex3d(x,y,z); }

    // normal
    void normal(double nx, double ny, double nz)
        { glNormal3d(nx,ny,nz); }

private:
    // settings
    int m_width;
    int m_height;
    int m_bpp;
    int m_zbits;
    int m_stencilbits;

    // features
    GLint m_max_texture_size;

    // lists
    LinkedList<BaseSurface> *m_imglist;
    LinkedList<Texture> *m_texlist;
};


}   // namespace dds

#endif  // _DDS_RENDER_H
