/*
    "shader.cpp"   - OpenGL/C++ Shader interface
     
    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#include <string.h>
#include "shader.h"
#include "error.h"

namespace dds {

    /*  Q3A fx.shader parser
        -------------------- */

ShaderParser::ShaderParser(ifstream *ifs, int32 maxline)
{
    initialize();

    m_in = ifs;
    m_maxline = maxline;
    m_text = new char[m_maxline];
}

ShaderParser::~ShaderParser()
{
    delete []m_text;
}

void ShaderParser::update_level()
{
    if( strstr(m_text, "{") )
        m_level++;

    if( strstr(m_text, "}") ) {
        if( !m_level )
            throw Error("ShaderParser::update_level()","Level mismatch; already at level 0");
        m_level--;
    }
}


    /*  Shader class
        ------------ */

Shader::Shader()
{
    for(int32 i=0;i<SHADER_MAXSTAGES;i++) {
        m_stage[i].active = false;
        m_stage[i].blendfunc[0] = GL_ZERO;
        m_stage[i].blendfunc[1] = GL_ZERO;
        m_stage[i].clampmap[0] = GL_CLAMP;
        m_stage[i].clampmap[1] = GL_CLAMP;
        m_stage[i].texture = NULL;
    }

    culling(cull_disable);
    sorting(sort_disable);
}

Shader::Shader(const char script[], const char id[])
{
    // establish a parser
    ifstream ifs(script,ios::in|ios::nocreate);
    if( !ifs.is_open() )
        throw Error("Shader::Shader()","Shader script not found:",script);

    ShaderParser parser(&ifs,1024);

    // locate requested shader data
    while( !strstr(parser.text(),id) ) {
        if( !parser.getline() )
            throw Error("Shader::Shader()","Shader data not found:",id);
    }

    cout << "attempting to load shader data..\n";

    // get into shader block
    while( !parser.level() )
        parser.getline();

    // load shader stages
    int32 plevel = parser.level();
    int32 stage = 0;
    char *text;
    while( parser.level() > 0 ) {
        parser.getline();
        text = (char*)parser.text();

        // check for next stage, break if limit reached
        if( parser.level() > plevel ) {
            cout << "stage " << stage+1 << " reached\n";
            if( ++stage == SHADER_MAXSTAGES )
                break;
        }

        // TODO: parse settings:)

        plevel = parser.level();
    }
}

void Shader::texture(int32 stage, Texture *texture)
{
    if( stage > SHADER_MAXSTAGES )
        return;

    ShaderStage *st = &m_stage[stage];
    st->texture = texture;
}

}   // namespace dds

