/*
    "shader.h"   - OpenGL/C++ Shader interface

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_SHADER_H
#define _DDS_SHADER_H

#include "glbase.h"
#include "parser.h"
#include "texture.h"

namespace dds {

#define SHADER_MAXSTAGES 8

    /* Q3A fx.shader parser */

class ShaderParser: public Parser {
public:
	ShaderParser(ifstream *ifs, int32 maxline=1024);
	~ShaderParser();

protected:
    void update_level();
};

    /* Shader stage */

struct ShaderStage {

    bool active;

    Texture *texture;

    GLenum blendfunc[2];
    GLenum clampmap[2];

    /* todo:
        - alphafunc
        - rgbgen (colors?)
        -tcmod (use texturematrices)
    */
};

    /* Shader class */

class Shader {

public:
    Shader();
    Shader(const char script[], const char id[]);
    ~Shader() {};

    enum cullMode {
        cull_disable = 0,
        cull_front = 1,     // GL_CW
        cull_back = 2,      // GL_CCW
        cull_twosided = 3
    };

    enum sortMode {
        sort_disable = 0,
        sort_portal = 1,
        sort_sky = 2,
        sort_opaque = 3,
        sort_unknown = 5,
        sort_banner = 6,
        sort_underwater = 8,
        sort_additive = 9,
        sort_nearest = 16
    };

    inline const void culling(cullMode cull)
        { m_cull = cull; }
    inline const void sorting(sortMode sort)
        { m_sort = sort; }

    void texture(int32 stage, Texture *texture);

private:
    ShaderStage m_stage[SHADER_MAXSTAGES];

    // general settings
    cullMode m_cull;
    sortMode m_sort;
};


}   // namespace dds

#endif  // _DDS_SHADER_H
