/*
    "texture.h"   - OpenGL/C++ Texture class
     
    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_TEXTURE_H
#define _DDS_TEXTURE_H

#ifdef _WIN32_
# include <windows.h>
#endif
#include <GL/gl.h>
#include "sdlbase.h"

namespace dds {

    /*  Texture class  */

class Texture {

public:
    // mipmapping
    enum textureMip {
        nomip = 0,
        fastmip = 1,
        nicemip = 2
    };

    // setup
    Texture(BaseSurface *texture, textureMip mipmap = Texture::nomip);
    ~Texture();

    // texture options
    void filter(GLint min, GLint mag)
        { gl_texture_min_filter=min; gl_texture_mag_filter=mag; }
    void wrap(GLint s, GLint t)
        { gl_texture_wrap_s=s; gl_texture_wrap_t=t; }

    // opengl interface
    void upload();
    void bind(int32 stage=0);

private:
    void buildmipmaps();
    static BaseSurface* scale(BaseSurface *surface, int w, int h, bool smooth=false);

    BaseSurface *m_texture;
    int m_mipmap;

    GLenum gl_format;
    GLuint gl_texture_id;
    GLint gl_texture_min_filter;
    GLint gl_texture_mag_filter;
    GLint gl_texture_wrap_s;
    GLint gl_texture_wrap_t;
};


}   // namespace dds


#endif  // _DDS_TEXTURE_H
