/***************************************************************************
                          blckmap.cpp  -  description
                             -------------------
    begin                : Sun Jun 17 2001
    copyright            : (C) 2001 by dureks
    email                : 
 ***************************************************************************/

#include <blckmap.h>
#include <SDL/SDL.h>
#include <math.h>

BlockMapper::BlockMapper()
{
    block = NULL;
}

BlockMapper::BlockMapper(Uint32 blockx_, Uint32 blocky_, Uint32 width, Uint32 height)
{
    block_x_size = blockx_;
    block_y_size = blocky_;
    block_x = 5+width/block_x_size;
    block_y = 10+height/block_y_size;
    block = NULL;
    block = new Block[block_x*block_y];
}

void BlockMapper::initialize(Uint32 blockx_, Uint32 blocky_, Uint32 width, Uint32 height)
{
    delete[] block;
    block_x_size = blockx_;
    block_y_size = blocky_;
    block_x = 1+width/block_x_size;
    block_y = 2+height/block_y_size;
    block = new Block[block_x*block_y];
}

BlockMapper::~BlockMapper()
{
    delete[] block;
}

void BlockMapper::draw(BaseSurface *texture, BaseSurface *surface)
{
    for(Uint32 y=0;y<block_y-1;y++)
        for(Uint32 x=0;x<block_x-1;x++)
            map_block(x,y,texture,surface);
}

void BlockMapper::r0tten(BaseSurface *texture, BaseSurface *surface)
{
    for(Uint32 y=0;y<block_y-1;y++)
        for(Uint32 x=0;x<block_x-1;x++)
            r0tten_map_block(x,y,texture,surface);
}

void BlockMapper::map_block(Uint32 x, Uint32 y, BaseSurface *texture, BaseSurface *surface)
{
    Block br = block[(y+1)*block_x+x];
    Block bl = block[y*block_x+x];

    float ul = (float)bl.u;
    float vl = (float)bl.v;
    float cl = (float)bl.c;    //handle later

    float ul_step = (float)(br.u-ul) / (float)block_y_size;
    float vl_step = (float)(br.v-vl) / (float)block_y_size;
    float cl_step = (float)(br.c-cl) / (float)block_y_size;

    bl = block[y*block_x+x+1];
    br = block[(y+1)*block_x+x+1];
    float ur = (float)bl.u;
    float vr = (float)bl.v;
    float cr = (float)bl.c;    //handle later

    float ur_step = (float)(br.u-ur) / (float)block_y_size;
    float vr_step = (float)(br.v-vr) / (float)block_y_size;
    float cr_step = (float)(br.c-cr) / (float)block_y_size;

    Uint32* where = (Uint32*)surface->lock() +x*block_x_size+y*block_y_size*surface->width();
    Uint32* textur = (Uint32*)texture->lock();

    for(Uint32 j=0;j<block_y_size;j++) {
        float u_step = (float)(ur-ul) / (float)block_x_size;
        float v_step = (float)(vr-vl) / (float)block_x_size;
        float c_step = (float)(cr-cl) / (float)block_x_size;
        float u = ul;
        float v = vl;
        float c = cl; //handle later

        for(Uint32 i=0;i<block_x_size;i++) {
            Uint32 color = *(textur+(Uint32)u+(((Uint32)v)<<11));
            *where++ = color;
            u += u_step;
            v += v_step;
            c += c_step;
        }
        ul += ul_step;
        vl += vl_step;
        ur += ur_step;
        vr += vr_step;
        where += surface->width()-block_x_size;
    }

    surface->unlock();
    texture->unlock();
}

// fixed point version with evil torje-wanna-fuck-sty-effect

void BlockMapper::r0tten_map_block(Uint32 x, Uint32 y, BaseSurface *texture, BaseSurface *surface)
{
#define FP 10
    Block br = block[(y+1)*block_x+x];
    Block bl = block[y*block_x+x];

    Uint32 ul = bl.u << FP;
    Uint32 vl = bl.v << FP;
//    Uint32 cl = bl.c << FP;    //handle later

    Uint32 ul_step = (br.u << FP -ul) / block_y_size;
    Uint32 vl_step =  (br.v << FP -vl) / block_y_size;
//    Uint32 cl_step =  (br.c << FP -cl) / block_y_size;

    bl = block[y*block_x+x+1];
    br = block[(y+1)*block_x+x+1];
    Uint32 ur = bl.u << FP;
    Uint32 vr = bl.v << FP;
//    Uint32 cr = bl.c << FP;    //handle later

    Uint32 ur_step = (br.u << FP -ur) / block_y_size;
    Uint32 vr_step = (br.v << FP -vr) / block_y_size;
//    Uint32 cr_step = (br.c << FP -cr) / block_y_size;

    Uint32* where = (Uint32*)surface->lock() +x*block_x_size+y*block_y_size*surface->width();
    Uint32* textur = (Uint32*)texture->lock();

    for(Uint32 j=0;j<block_y_size;j++) {
        Uint32 u_step = (ur-ul) / block_x_size;
        Uint32 v_step = (vr-vl) / block_x_size;
//        Uint32 c_step = (cr-cl) / block_x_size;
        Uint32 u = ul;
        Uint32 v = vl;
//        Uint32 c = cl; //handle later

        for(Uint32 i=0;i<block_x_size;i++) {
            Uint32 color = *(textur+(u >> FP)+(v<<1));
            *where++ = color;
            u += u_step;
            v += v_step;
//            c += c_step;
        }
        ul += ul_step;
        vl += vl_step;
        ur += ur_step;
        vr += vr_step;
        where += surface->width()-block_x_size;
    }

    surface->unlock();
    texture->unlock();
}

/*
// fixed point with yo
void BlockMapper::map_block(Uint32 x, Uint32 y, BaseSurface *texture, BaseSurface *surface)
{
#define FP 10
    Block br = block[(y+1)*block_x+x];
    Block bl = block[y*block_x+x];

    Uint32 ul = bl.u << FP;
    Uint32 vl = bl.v << FP;
//    Uint32 cl = bl.c << FP;    //handle later

    Uint32 ul_step = (br.u << FP -ul) / block_y_size;
    Uint32 vl_step = (br.v << FP -vl) / block_y_size;
//    Uint32 cl_step =  (br.c << FP -cl) / block_y_size;

    bl = block[y*block_x+x+1];
    br = block[(y+1)*block_x+x+1];
    Uint32 ur = bl.u << FP;
    Uint32 vr = bl.v << FP;
//    Uint32 cr = bl.c << FP;    //handle later

    Uint32 ur_step = (br.u << FP -ur) / block_y_size;
    Uint32 vr_step = (br.v << FP -vr) / block_y_size;
//    fprintf(stderr,"step: %u %u\n",ur_step,vr_step);
//    Uint32 cr_step = (br.c << FP -cr) / block_y_size;

    Uint32* where = (Uint32*)surface->lock() +x*block_x_size+y*block_y_size*surface->width();
    Uint32* textur = (Uint32*)texture->lock();

    for(Uint32 j=0;j<block_y_size;j++) {
        Uint32 u_step = (ur-ul) / block_x_size;
        Uint32 v_step = (vr-vl) / block_x_size;
//        Uint32 c_step = (cr-cl) / block_x_size;
        Uint32 u = ul;
        Uint32 v = vl;
//        Uint32 c = cl; //handle later

        for(Uint32 i=0;i<block_x_size;i++) {
            Uint32 color = *(textur+(u >> FP)+(v<<1));
            *where++ = color;
            u += u_step;
            v += v_step;
//            c += c_step;
        }
        ul += ul_step;
        vl += vl_step;
        ur += ur_step;
        vr += vr_step;
//        fprintf(stderr,"ul: %u, vl: %u, ur: %u, vr: %u\n",ul_step,vl_step,ur_step,vr_step);
        where += surface->width()-block_x_size;
    }

    surface->unlock();
    texture->unlock();
}*/

Zoom360::Zoom360(Uint32 blockx_, Uint32 blocky_, BaseSurface *surface)
{
    block = NULL;
    initialize(blockx_,blocky_,surface->width(),surface->height());
    /* TODO */
    //BlockMapper(blockx_,blocky_,surface->width(),surface->height());
}

void Zoom360::update(float xscale, float yscale, float zr, float xsc, float ysc, float spunge)
{
    Vector2 vec;
    Matrix2 rmat;
    rmat.rotation(zr);
    Uint32 xc = 0, yc = 0;
    float tx = xscale*256;
    float ty = yscale*256;
    for(int c=0;c<block_x*block_y;c++) {
        if( xc >= block_x ) {
            yc++;
            xc = 0;
        }
        vec(((float)xc-(float)(block_x/2.f))/(float)(block_x)*(60.f/90.f),((float)yc-(float)(block_y/2.f))/(float)block_y*(60.f/90.f));
        rmat.mulvec(&vec);

        float tmp = spunge-sqrt(pow(vec.x(),2)+pow(vec.y(),2));
        block[c].u = vec.x()*tmp*tx+128+xsc;
        block[c].v = vec.y()*tmp*ty+128+ysc;
        //fprintf(stderr,"u, v: %u, %u\n",block[c].u,block[c].v);
        xc++;
    }
}