/***************************************************************************
                          blckmap.h  -  description
                             -------------------
    begin                : Sun Jun 17 2001
    copyright            : (C) 2001 by dureks
    email                : 
 ***************************************************************************/


#include <DDS/DDS.h>
#include <SDL/SDL.h>

#ifndef _BLCKMAP_H
#define _BLCKMAP_H

using namespace dds;

struct Block {
    Uint32 u;
    Uint32 v;
    Uint32 c;
};

class BlockMapper {
public:
    BlockMapper();
    BlockMapper(Uint32 blockx_, Uint32 blocky_, Uint32 width, Uint32 height);
    virtual void initialize(Uint32 blockx_, Uint32 blocky_, Uint32 width, Uint32 height);
    virtual ~BlockMapper();
    virtual void draw(BaseSurface *texture, BaseSurface *surface);
    virtual void r0tten(BaseSurface *texture, BaseSurface *surface);
protected:
    //Block **block;
    Block *block;
    Uint32 block_x_size;
    Uint32 block_y_size;
    Uint32 block_x;
    Uint32 block_y;
private:
    void map_block(Uint32 x, Uint32 y, BaseSurface *texture, BaseSurface *surface);
    void r0tten_map_block(Uint32 x, Uint32 y, BaseSurface *texture, BaseSurface *surface);
};



class Zoom360 : public BlockMapper {
public:
    Zoom360(Uint32 blockx_, Uint32 blocky_, BaseSurface *surface);

    void update(float xscale, float yscale, float zr, float xsc, float ysc, float spunge);
};


#endif // _BLCKMAP_H_