/***************************************************************************
                          evilstuff.cpp  -  description
                             -------------------
    begin                : Fri Jul 6 2001
    copyright            : (C) 2001 by dureks
    email                : 
 ***************************************************************************/

#include "evilstuff.h"

EvilDuck::EvilDuck(Uint32 x, Uint32 y, Uint32 _lifeticks, Sprite *sprite, Sample *sound_)
{
    x_pos = x;
    y_pos = y;
    x_put_pos = x_pos;
    y_put_pos = y_pos;
    lifeticks = _lifeticks;
    duck = sprite;
    starttick = SDL_GetTicks();
    put_frame = 0;
    sound = sound_;
}

EvilDuck::~EvilDuck()
{
}

bool EvilDuck::update()
{
    Uint32 tick = SDL_GetTicks()-starttick;
    if( tick > lifeticks)
        return( false );
    else {
        BaseSurface* frame = duck->frame_no(0);
        y_put_pos = y_pos -sin(((float)(tick))*M_PI/(float)lifeticks)*frame->height();

        float ratio = (float)tick/(float)lifeticks;
        if( ratio > duck->ratio(put_frame) ) {
            put_frame++;
            sound->play();
        }

        //fprintf(stderr,"frame num: %f\n", duck->ratio(put_frame));
        return( true );
    }
}

Area EvilDuck::area()
{
    BaseSurface* frame = duck->frame_no(put_frame);
    Area duck_area(x_put_pos,y_put_pos,x_put_pos+frame->width(),y_put_pos+frame->height());
    return( duck_area );
}

void EvilDuck::display(BaseSurface *surface)
{
    duck->draw(x_put_pos, y_put_pos, put_frame, surface);
}


    // feather physics class
    // ---------------------

Feather::Feather(float strength)
{
    m_strength = strength;
    cnt = 0;
}

void Feather::apply(Emitter *emitter)
{
    Particle *particle = emitter->particle(0);
    int32 particles = emitter->particles();

    while( particles-- ) {
        if( particle->active ) {
            if( particle->direction.x() >= 0 )
                particle->accel.x(particle->accel.x()-0.005f);
            else
                particle->accel.x(particle->accel.x()+0.005f);

            particle->direction += particle->accel;
//            Vector2 vec((float)sin(cnt)*m_strength,1.f);
         }
         particle++;
    }
    cnt += 6.28f/60.f;
}

void EvilPrintScore(char score[], Uint32 x, Uint32 y, EvilArea *evilarea, BaseSurface *source, BaseSurface *dest)
{
    Sint32 c = -1;
    Area put_area(x,y,640,480);
    while( score[++c] != '\0' ) {
        //fprintf(stderr,"Score: %u\n", score[c]);
        switch( score[c] ) {
            case '0':   dest->copy(source,evilarea->area[9],put_area); break;
            case '.':   dest->copy(source,evilarea->area[12],put_area); break;
            default: dest->copy(source,evilarea->area[score[c]-49],put_area);
        };
        put_area(put_area.x()+22,y,640,480);
    }
}