/***************************************************************************
                          evilstuff.h  -  description
                             -------------------
    begin                : Fri Jul 6 2001
    copyright            : (C) 2001 by dureks
    email                : 
 ***************************************************************************/

    /* the evil
       -------- */
#ifndef _EVILSTUFF_H
#define _EVILSTUFF_H


// includes
#include <DDS/DDS.h>

// evil definitions
#define ROTATE_EVIL_ANGLE .03f
#define EVIL_TRANSLATION M_PI/7.0f

#define CUBE_SPAWN_X 40
#define CUBE_KILL_X 600
#define CUBE_SPEED .5f
#define CUBE_SPEED_RAND .5f

#define CUBE_SIZE .8f
#define CUBE_SIZE_RAND .5f


using namespace dds;

struct EvilMesh {
    ~EvilMesh() { delete []vertex; }
    Vector2 *vertex;
    int32 length;
    float radius;
};

struct EvilArea {
    ~EvilArea() { delete []area; }
    Area *area;
    int32 length;
};

/* ---------------- evil duck class -------------------
*/
class EvilDuck
{
public:
    EvilDuck(Uint32 x, Uint32 y, Uint32 lifeticks, Sprite *sprite, Sample *sound);
    ~EvilDuck();

    bool update();
    void display(BaseSurface *surface);
    Area area();
private:
    float x_pos, y_pos;
    float x_put_pos, y_put_pos;
    Uint32 put_frame;
    Uint32 lifeticks;
    Uint32 starttick;
    Sprite *duck;
    Sample *sound;
};

struct marchCube {
    float x;
    float speed;
    float scale;
    Color line, fill;

    marchCube(float spd, float sca, Color cline, Color cfill)
    {
        x = CUBE_SPAWN_X;
        speed = spd;
        scale = sca;
        line = cline;
        fill = cfill;
    }
};

// this will try to emulate "feather-motion" :)
class Feather: public Physics {
public:
    Feather(float strength);
    ~Feather() {};
    void apply(Emitter *emitter);
private:
    float m_strength;
    float cnt;
};

void EvilPrintScore(char score[], Uint32 x, Uint32 y, EvilArea *evilarea, BaseSurface *source, BaseSurface *dest);


#endif // evilstuff