/***************************************************************************
                          x2k1intro.cpp  -  description
                             -------------------
    begin                : Fri Jul 6 2001
    copyright            : (C) 2001 by dureks
    email                : 
 ***************************************************************************/

// includes
#include "x2k1intro.h"

Xenox2001intro::Xenox2001intro()
{
    console = new Console(Console::video|Console::sound|Console::timer|Console::fullscreen);
    console->open("Xenox2001 invtro intro (C)Dureks 2001",320,240,32);
    console->cursor(false);

    if( console->depth() != 32 )
        throw Error("Xenox2001intro::Xenox2001intro()","32bpp display depth required, skipping intro -> invtro");


    buffer = new Surface(console->width(),console->height(),console->format());
    surface = new Surface(console->width(),console->height(),console->format());
    fadeout = new Surface(console->width(),console->height(),console->format());
    fadeout->clear();

    // interface data
    background[0] = new Image("data/s0rsida.jpg",console->format());
    background[1] = new Image("data/guldEX.jpg",console->format());
    backptr = 0;

    credit[0] = new Image("data/cred_anden_mrb.png",console->format());
    credit[1] = new Image("data/cred_spiff_sausage.png",console->format());
    credit_num = 0;
    logo[0] = new Image("data/dlogo.png",console->format());
    logo[1] = new Image("data/xlogo.png",console->format());
    logo[2] = new Image("data/dritbyen.png",console->format());

    bpd = new Zoom360(8,8,buffer);
    zr = xsc = ysc = ffade = zfac = 0;
    dfade = xfade = bfade = 1.f;
    xsc = 1.f;
    left_dir = 1.f;

    bshr = 255.f;
    amp = 255.f;
    per = 64.f;

    // muzak
    music = new Music("data/wafer.it");
//    music->order(4);
    music->play();
}

Xenox2001intro::~Xenox2001intro()
{
}

void Xenox2001intro::display()
{/*
    static Uint32 oldTime;
    Uint32 newTime = SDL_GetTicks();
    fprintf(stderr,"Time: %u\n", newTime-oldTime);
    oldTime = newTime;
*/
    if( (music->order() == 14) && (music->row() >= 96) ) {
        surface->copy(buffer);
    }
    else if( music->order() == 15) {
        zoom(256-zfac,256-zfac,40+sin(zfac*M_PI/64)*30,30+cos(zfac*M_PI/64)*30,surface,buffer);
        buffer->xfade(fadeout,fadeout->area(),1-((float)zfac/256.f));
    }
    else {
        bpd->update(1.f,1.f,zr,xsc,ysc,1.73f);
        if( (music->order() == 0) && (music->row() < 80) && (music->row() & 1) && ((SDL_GetTicks() & 1)) )
            bpd->r0tten(background[backptr],buffer);
        else
            bpd->draw(background[backptr],buffer);
        if( (music->order() > 3) && (music->order() < 9) ) {
            blur(surface->area(),bshr+(amp/8),credit[credit_num],surface);

            buffer->alpha(200);
            surface->alpha(210-bshr/2,SDL_SRCALPHA);
            buffer->copy(surface);
        }

        if( music->order() > 8 ) {
            buffer->alpha(200+55*ffade/137);
            surface->alpha(210-128-ffade*82/137);
           // fprintf(stderr,"yo: %u\n",ffade);
            buffer->copy(surface);
        }

        //blit.addgrade(0,0,dfade,logo[0],buffer);
        //blit.addgrade(320-130-8,240-46-8,xfade,logo[1],buffer);

        if( music->order() < 4 ) {
            Area area(0,0,logo[0]->width(),logo[0]->height());
            buffer->xfade(logo[0],area,0,0,dfade,0);

            area(0,0,logo[1]->width(),logo[1]->height());
            buffer->xfade(logo[1],area,182,186,xfade,0);

            area(0,0,logo[2]->width(),logo[2]->height());
            buffer->xfade(logo[2],area,100,103,bfade,0);
        }
    }
    // update screen
    console->copy(buffer);
    console->update();
}

void Xenox2001intro::update()
{
    if( xsc == 2048-256 ) {
        left_dir = -1;
        backptr = 1;
    }
    if( xsc == 0 )
        left_dir = 0.93f;

    xsc += left_dir;

    ysc = 128+cos(xsc*M_PI_2/200+M_PI/2)*92;

    //bshr = 129+sin(xsc*M_PI/32)*128;
    if( (music->order() == 4) || (music->order() == 6) ) {
        if( bshr > 48 ) {
            bshr = amp;
            amp -= 5.0f;
        }
        else {
            bshr = 1+abs(sin(xsc*M_PI/per)*amp);
            if( amp > 0.0f )
                amp -= 0.5f;
        }
        if( per > 1.0f )
            per -= 0.1f;
    }

    if( (music->order() == 5) || (music->order() == 8) ) {
        if( bshr > 48 ) {
            bshr = amp;
            amp += 5.0f;
        }
        else {
            bshr = 1+abs(sin(xsc*M_PI/per)*amp);
            amp += 0.5f;
        }
        if( per < 48.0f )
            per += 0.1f;
    }

    if( music->order() == 6 )
        credit_num = 1;

    if( bshr > 255.f ) bshr = 255.f;

/*    bshr = 129+sin(xsc*M_PI/32)*128;
    if( bshr == 257 )
        credit_num = !credit_num;*/

    zr = sin(xsc*M_PI_2/100.f)*0.4;

    if( (music->order() == 1) && (dfade>0.2f) )
        dfade -= 0.8f/60.f;

    if( (music->order() == 2) && (xfade>0.2f) )
        xfade -= 0.8f/60.f;

    if( (music->order() == 3) && (xfade < 1.f) ) {
        xfade += 0.8f/60.f;
        dfade += 0.8f/60.f;
        bfade += 0.8f/60.f;
    }

    if( (music->order() == 2) && (music->row() > 64) && (bfade>0.2f) )
        bfade -= 0.8f/60.f;
    //fprintf(stderr,"Order: %d, Row: %d\n", music->order(),music->row());

    if( (music->order() > 8) && (ffade < 137) )
        ffade++;

    if( music->order() == 15 )
        if( zfac++ >= 256 )
            request(quit);
}

void Xenox2001intro::blur(const Area &area,Uint32 bshr, BaseSurface *source, BaseSurface *dest)
{
    Uint32 counter,R=0,G=0,B=0;
    //char width = (char)(1<<bshr);
    Uint32 width = bshr;
    Uint32 right = area.x()+area.w();
    Uint32 left  = area.x();
    Uint32 top = area.y();
    Uint32 bottom = area.y()+area.h();
    Uint32 f_width = source->width();
    Uint32 w_width = dest->width()-(right-left);
    //Uint32 *from = (Uint32*)source->lock();
    Uint32 *from = (Uint32*)source->lock();
    Uint32 *where = (Uint32*)dest->lock();

    Uint32 j = top*f_width;

    for(int y=top;y<bottom;y++) {
        for(int x=left;x<right;x++) {

            R += (Uint32)((char8)(*(from+x+j+width-1)>>16)) & 0xFF;
            G += (Uint32)((char8)(*(from+x+j+width-1)>>8)) & 0xFF;
            B += (Uint32)((char8)(*(from+x+j+width-1))) & 0xFF;

            //where[counter] = ((R>>bshr)<<16) + ((G>>bshr)<<8) + (B>>bshr);
            Uint32 color = ((R/bshr)<<16) + ((G/bshr)<<8) + (B/bshr);
            //*where(x+y*w_width) = color;
            *where++ = color;

            R -= (Uint32)((char8)(*(from+x+j)>>16)) & 0xFF;
            G -= (Uint32)((char8)(*(from+x+j)>>8)) & 0xFF;
            B -= (Uint32)((char8)(*(from+x+j))) & 0xFF;
/*
            R += (Uint32)((*(from+((x+j+width-1)<<2)+1))) & 0xFF;
            G += (Uint32)((*(from+((x+j+width-1)<<2)+2))) & 0xFF;
            B += (Uint32)((*(from+((x+j+width-1)<<2)+3))) & 0xFF;

            //where[counter] = ((R>>bshr)<<16) + ((G>>bshr)<<8) + (B>>bshr);
            Uint32 color = ((R/bshr)<<16) + ((G/bshr)<<8) + (B/bshr);
            //*where(x+y*w_width) = color;
            *where++ = color;

            R -= (Uint32)((*(from+((x+j)<<2)+1))) & 0xFF;
            G -= (Uint32)((*(from+((x+j)<<2)+2))) & 0xFF;
            B -= (Uint32)((*(from+((x+j)<<2)+3))) & 0xFF;
*/
        }
        j += f_width;
        where += w_width;
    }
    source->unlock();
    dest->unlock();
}

void Xenox2001intro::zoom(Sint32 Xfac, Sint32 Yfac, Sint32 Xzp, Sint32 Yzp, BaseSurface *source, BaseSurface *dest)
{
    Sint32 sX, sY, iXfac, iYfac = 0;
    Sint32 spY, spX, x, y, scY;

    sX = Xzp-(Xzp*Xfac);
    sY = Yzp-(Yzp*Yfac);

//    if( source->depth() == 32 ) {
        Uint32 *fwhere = (Uint32*)source->lock();
        Uint32 *where = (Uint32*)dest->lock();
/*    }
    else {
        Uint16 *fwhere = (Uint16*)source->lock();
        Uint16 *where = (Uint16*)dest->lock();
    }*/

    for(y=0;y<240;y++) {
        iXfac = 0;
        spY = (Yzp+((sY+iYfac) >> 8))*320;
        for(x=0;x<320;x++) {
            spX = ((sX+iXfac) >> 8);
            //where[x+(y*320)] = fwhere[spY+Xzp+spX];
//            fprintf(stderr,"yo: %u %u\n",spX,spY);
            *where++ = *(fwhere+spY+Xzp+spX);
            iXfac += Xfac;
        }
        iYfac += Yfac;
    }
    source->unlock();
    dest->unlock();
}