/***************************************************************************
                          x2k1invtro.cpp  -  description
                             -------------------
    begin                : Fri Jul 6 2001
    copyright            : (C) 2001 by dureks
    email                : 
 ***************************************************************************/

#include "x2k1invtro.h"

 /* ---------------- C O D E -------------------
*/

Xenox2001::Xenox2001()
{
    // initialize libraries
    console = new Console(Console::video|Console::sound|Console::timer|Console::fullscreen);
    console->open("Xenox2001 invtro (C)Dureks 2001",640,480,32);
    console->cursor(false);

    SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);

    // determine fastest blitting mode (SW_SURFACEs)

    // setup mouse trail
    Vector2 pos(0,0);
    a_active = false;
    trail = new Emitter(2000,pos);
    trail->fade(0.015f);
    trail->speed(2.0f,0.4f);
    // gravity + attractor
    gravity = new Gravity(9.81f);
    Vector2 att(0.f,0.f);
    attract = new Attractor(att,10.f);
    // trail flares
    flare = new Image("data/flare.png",console->format());
    buffer = new Surface(640,480,console->format());
    surface = new Surface(640,480,console->format());
    surface->alpha(80);

    // mouse cursors
    cursor[0] = new Image("data/cursor.png",console->format());
    cursor[0]->colorkey(0);
    cursor[1] = new Image("data/shcursor.png",console->format());
    cursor[2] = new Image("data/snipe.png",console->format());
    cursor[2]->colorkey(0);
    cursor[3] = cursor[1];
    put_mouse = 0;
    mouse_pressed = false;

    // interface data
    infoarea(85,100,560,481);
    background = new Image("data/uidark.png",console->format());
    background->colorkey(0);
    light_buttons = new Image("data/ui.png",console->format());
    menumask = new Image("data/knpmap.png");
    info = new Image("data/stor.png",console->format());
    droole = new Image("data/sikle.png",console->format());
    //fonten = new GFXFont("data/ymetal.png",console->format());

    // parse
    evilgear = loadtxc("data/gear.txc");
    evilrotation = 0.f;
    gearline(255,255,255,128);
    gearfill(0x9D,0xB5,0xFB,128);

    page = loadtxc("data/page.txc");
    cube = loadtxc("data/cube.txc");

    //the duck gang
    duck[1] = new Sprite("data/duck2.tsc",console->format());
    duck[0] = new Sprite("data/duck1.tsc",console->format());
    duck[2] = new Sprite("data/duck3.tsc",console->format());
    duck[3] = new Sprite("data/duck4.tsc",console->format());
    duck[4] = new Sprite("data/duck5.tsc",console->format());
    duck[5] = new Sprite("data/duck6.tsc",console->format());
    duck[6] = new Sprite("data/duck7.tsc",console->format());
    duck[7] = new Sprite("data/duck2.tsc",console->format());

    fthr[0] = new Image("data/feath1.png",console->format());
    fthr[1] = new Image("data/feath2.png",console->format());
    fthr[2] = new Image("data/feath3.png",console->format());
    fthr[3] = new Image("data/feath4.png",console->format());

    blood[0] = new Image("data/the_blod.png",console->format());
    blood[1] = new Image("data/the_blod2.png",console->format());
    blood[2] = new Image("data/the_blod3.png",console->format());
    blood[3] = new Image("data/the_blod4.png",console->format());

    sfx[0] = new Sample("data/skudd.mp3");
    sfx[1] = new Sample("data/kvakk_skutt.mp3");
    sfx[2] = new Sample("data/kvakk_glad.mp3");
    kill = true;

    uimask = new Image("data/uimask.png", console->format());
    //blood[0]->colorkey(0);

    evilduck = NULL;
    ducks_left = 0;
    ducks_right = 0;
    duck_hit_left = 0;
    duck_hit_right = 0;
    feather = new Emitter(100,pos);
    feather->life(1.f,0.0f,0.010f);
    Vector2 dir(0.0f,0.4f);
    Vector2 rnd(1.f,0.1f);
    feather->direction(dir,rnd);
    feather->speed(4.f,0.5f);

    Vector2 fjed(0.f,0.f);
    fjederha = new Attractor(fjed,1.0f);

    scwong = new Feather(4.0f);

    mcube = new LinkedList<marchCube>;

    evilarea = loadtxa("data/butlight.txa");
    fontarea = loadtxa("data/fonten.txa");

    fonten = new Image("data/fonten.png",console->format());

    //bpd = new Zoom360(4,4,surface);

    // muzak
    music = new Music("data/knapp.it");
    music->play();

    info_ypos = 0;
    next_ypos = 0;
    a_active = false;
    b_active = 1;
    b_active_prev = 0;

    mouse_focus = true;
    active_app = true;
}

Xenox2001::~Xenox2001()
{
    //fprintf(stdout,"Ducks slaughtered left: %d / %d\n",duck_hit_left,ducks_left);
    //fprintf(stdout,"Ducks slaughtered right: %d / %d\n",duck_hit_right,ducks_right);
    delete trail;
    delete gravity;
    delete attract;
    delete flare;
    delete buffer;
    delete surface;
    delete cursor[0];
    delete cursor[1];
    delete background;
    delete light_buttons;
    delete menumask;
    delete info;
    delete music;
    delete mcube;
    delete evilarea;
    delete evilgear;
    delete page;
    delete cube;
}

void Xenox2001::display()
{

/*    static Uint32 oldTime;
    Uint32 newTime = SDL_GetTicks();
    fprintf(stderr,"Time: %u\n", newTime-oldTime);
    oldTime = newTime;*/

    if( !active_app )
        return;

    // ...we are still evil
    Area area(0,info_ypos,infoarea.w(),info_ypos+infoarea.h());
    buffer->copy(info,area,infoarea);

    draw_the_evil(110,120,1.f,evilrotation,gearline,gearfill,evilgear,buffer);
    draw_the_evil(540,120,1.f,-evilrotation+EVIL_TRANSLATION,gearline,gearfill,evilgear,buffer);

    for(int n=0;n<mcube->length();n++) {
        marchCube *cu = mcube->item(n);
        float radi = cube->radius*cu->scale;
        float rot = cu->x*1.57f/(2.f*radi);
        draw_the_evil(cu->x,buffer->height()-radi-fabs(sin(2.f*rot)*(radi/2.f)),cu->scale,rot,cu->line,cu->fill,cube,buffer);
    }

    //the duck gang
    area(0,0,95,100);
    Color color(0,0,0,128);
    buffer->clear(color,area);
    area(545,0,95,100);
    buffer->clear(color,area);

    if( evilduck != NULL )
        evilduck->display(buffer);

    // draw console
    buffer->copy(background);

    // highlight selected button
    float f_value = (info_ypos-page->vertex[b_active_prev].y())*1/(page->vertex[b_active].y() - page->vertex[b_active_prev].y());
    if( f_value > 1.f ) f_value = 1.f;
    buffer->xfade(light_buttons,evilarea->area[b_active], 1.f-f_value );
    buffer->xfade(light_buttons,evilarea->area[b_active_prev], f_value );

    // mouse cursor shadow
    if( mouse_focus )
        blit.sub(mousepos.x()-MOUSE_SHADOW_SKEW,mousepos.y()+MOUSE_SHADOW_SKEW,cursor[put_mouse+1],buffer);

    // mouse trail
    trail->draw(flare,buffer);

    // feather trail
    feather->draw(fthr[0],buffer);

    if( mouse_focus ) {
        // mouse cursor
        area(mousepos.x(),mousepos.y(),cursor[put_mouse+1]->width()+mousepos.x(),cursor[put_mouse+1]->height()+mousepos.y());
        buffer->copy(cursor[put_mouse],cursor[put_mouse]->area(),area);
    }

    //bpd->update(1.f,1.f,0,(float)SDL_GetTicks()/25.f,1.4f);
    /*bpd->update(1.f,1.f,sin((float)(SDL_GetTicks()*6.28f/5000.f))*0.3,(float)(SDL_GetTicks()/25.f),1.4f);//float xscale, float yscale, float zr, float isc, float spunge);
    bpd->draw(background,buffer);*/

    // update screen
    console->copy(buffer);
    console->update();
}

void Xenox2001::update()
{
    // mouse trail
    gravity->apply(trail);
    if( a_active ) {
        attract->apply(trail);
        trail->revive(1);
    }
    trail->update();

    scwong->apply(feather);
    fjederha->apply(feather);
    feather->update();

    // the evil
    slide_the_evil();

    // check which button to highlight
    if( info_ypos < page->vertex[b_active-1].y() ) {
        b_active_prev--;
        b_active--;
    }
    else if( (b_active < page->length-1) ) {
        if( info_ypos >= page->vertex[b_active].y() ) {
            b_active_prev = b_active;
            b_active++;
        }
    }

    // marching cubes
    for(int n=0;n<mcube->length();n++) {
        marchCube *cu = mcube->item(n);
        cu->x += cu->speed;

        if( cu->x >= CUBE_KILL_X ) {
            mcube->remove(cu);
            delete cu;
        }
    }

    // the duck gang
    if( evilduck != NULL ) {
        if( !evilduck->update() ) {
            delete evilduck;
            evilduck = NULL;
        }
    }
    else if( (rand() & 1023) > 1015 ) {
//        fprintf(stderr,"ducks++\n");
        kill = false;
        int duck_num = rand() & 7;
        int pos = duck_num & 1;
        if( pos )
            ducks_right++;
        else
            ducks_left++;
        evilduck = new EvilDuck(20 +550*pos,97,1500,duck[duck_num],sfx[2]);
    }
}

void Xenox2001::key_pressed(SDLKey key, SDLMod mod)
{
    // ESC
    if( key == SDLK_ESCAPE )
        request(quit);

    // Alt-F4
    if( key == SDLK_F4  && mod == KMOD_LALT )
        request(quit);

    // info page scrolling
    if( key == SDLK_DOWN )
        next_ypos += SCROLL_SPEED;
    if( key == SDLK_UP )
        next_ypos -= SCROLL_SPEED;
    if( key == SDLK_PAGEDOWN )
        next_ypos += SCROLL_QUICK;
    if( key == SDLK_PAGEUP )
        next_ypos -= SCROLL_QUICK;
    if( key == SDLK_HOME )
        next_ypos = 0;
    if (key == SDLK_END )
        next_ypos = (int)info->height()-(int)infoarea.h();
}

void Xenox2001::mouse_motion(int16 x, int16 y, int xrel, int yrel)
{
    if( !mouse_focus )
        return;

    mousepos(x,y);

    // update attractor
    char8 *data = (char8*)menumask->lock();
    int32 pixel = *(int32*)(data+x*4+y*menumask->pitch());
    menumask->unlock();
    char8 r,g,b;
    SDL_GetRGB(pixel,(SDL_PixelFormat*)&menumask->format().SDLPixelFormat(),&r,&g,&b);
    if( (b) && (b != 8)) {
        a_active = true;
        attract->position(mousepos);
    }
    else
        a_active = false;

    // change mousecursor on slaughterfield
    if( b == 8 )
        put_mouse = 2;
    else
        put_mouse = 0;

    // create new particles when moving mouse
    Vector2 dir(xrel,yrel);
    Vector2 off(1.0f,1.0f);
    trail->direction(dir,off);
    Vector2 pos(x,y);
    trail->position(pos);
    trail->revive(1);
}

void Xenox2001::mouse_button_pressed(char8 button, int16 x, int16 y)
{
    if( !mouse_focus )
        return;

    // make a particle boost on left buttonpress
    if( button == SDL_BUTTON_LEFT ) {
        Vector2 dt = trail->direction();
        Vector2 rt = trail->direction_rand();
        float spt = trail->speed();
        float srt = trail->speed_rand();
        Vector2 dir(0.f,0.f);
        Vector2 rnd(1.f,1.f);
        trail->direction(dir,rnd);
        trail->speed(4.f,2.f);
        trail->revive(PARTICLE_BOOST_COUNT);
        trail->direction(dt,rt);
        trail->speed(spt,srt);
    }

    if( button == SDL_BUTTON_RIGHT) {
        Color line(255,255,255,255);
        marchCube *cu = new marchCube(CUBE_SPEED+(float)(rand() % 100)/100.f*CUBE_SPEED_RAND,
                                      CUBE_SIZE+(float)(rand() % 100)/100.f*CUBE_SIZE_RAND,line,gearfill);
        mcube->push(cu);
    }

    // check interface buttons
    if( button == SDL_BUTTON_LEFT ) {
        char8 *data = (char8*)menumask->lock();
        int32 pixel = *(int32*)(data+x*4+y*menumask->pitch());
        menumask->unlock();

        char8 r,g,b;
        SDL_GetRGB(pixel,(SDL_PixelFormat*)&menumask->format().SDLPixelFormat(),&r,&g,&b);

        switch( b ) {
            case 1: next_ypos = page->vertex[0].y(); break;
            case 2: next_ypos = page->vertex[1].y(); break;
            case 3: next_ypos = page->vertex[2].y(); break;
            case 4: next_ypos = page->vertex[3].y(); break;

            case 5: // quit
                // TODO: yer fancy work
                request(quit);
                break;
            case 6: // arrow up
                next_ypos -= MOUSE_SCROLL_SPEED;
                break;
            case 7: // arrow down
                next_ypos += MOUSE_SCROLL_SPEED;
                break;
            case 8:
                if( !mouse_pressed ) {
                    static Uint32 lastGunned;
                    mouse_pressed = true;

                    if( (!lastGunned) || (SDL_GetTicks()-lastGunned) > 1200 ) {
                        sfx[0]->play();
                        lastGunned = SDL_GetTicks();

                        if( evilduck != NULL ) {
                            Area duck_area = evilduck->area();
                            if( (x >= duck_area.x()) && (x <= duck_area.w()+duck_area.x()) && (y >= duck_area.y()) && (y <= duck_area.h()+duck_area.y()) && (!kill)) {
                                kill = true;

                                Vector2 dt = feather->direction();
                                Vector2 rt = feather->direction_rand();
                                float spt = feather->speed();
                                float srt = feather->speed_rand();

                                Vector2 pos(duck_area.x(),duck_area.y());
                                Vector2 obs(x,y);
                                feather->position(pos);
                                feather->revive(FEATHER_BOOST_COUNT);

                                fjederha->position(obs);

                                feather->direction(dt,rt);
                                feather->speed(spt,srt);

                                // put the blood
                                Uint32 xD = x-32+20-40*(rand()&1);
                                Uint32 yD = y-32+20-40*(rand()&1);
                                Uint32 tR = rand()&3;
                                blit.mask(xD,yD,0,blood[rand() & 3],background);

                                //background->xfade(uimask,uimask->area(),0,0,0.f,254);
                                tadetvivilha(uimask,background,uimask->area());
                                sfx[1]->play();

                                if( duck_area.x() > 300 )
                                    duck_hit_right++;
                                else
                                    duck_hit_left++;

                                delete evilduck;
                                evilduck = NULL;
                            }
                        }
                    }
                }
                break;
        }
    }

    // mwheel :)
    if( button == 4 )
        next_ypos -= SCROLL_SPEED;
    if( button == 5 )
        next_ypos += SCROLL_SPEED;
}

void Xenox2001::mouse_button_is_pressed(char8 button, int16 x, int16 y)
{
    if( button == SDL_BUTTON_LEFT )
        mouse_button_pressed(button,x,y);
}

void Xenox2001::mouse_button_released(char8 button, int16 x, int16 y)
{
    mouse_pressed = false;
}

void Xenox2001::window_focus_gain(char8 state)
{
    switch( state ) {
        case SDL_APPMOUSEFOCUS:
            mouse_focus = true;
            break;
        case SDL_APPACTIVE:
            active_app = true;
            break;
    }
}

void Xenox2001::window_focus_lost(char8 state)
{
    switch( state ) {
        case SDL_APPMOUSEFOCUS:
            mouse_focus = false;
            break;
        case SDL_APPACTIVE:
            active_app = false;
            break;
    }
}

// crossfade with source on area
void Xenox2001::tadetvivilha(BaseSurface *source,BaseSurface *dest,const Area &area)
{
    Uint8 *s = (Uint8*)source->lock();
    Uint8 *t = (Uint8*)dest->lock();
    Uint32 f_x = area.x();
    Uint32 f_y = area.y();
    Uint32 h = area.h();
    Uint32 w = area.w();

    SDL_PixelFormat sformat = source->format().SDLPixelFormat();
    SDL_PixelFormat tformat = dest->format().SDLPixelFormat();
    Uint8 sR,sG,sB;
    // pixel pitch
    Uint8 sPPitch = sformat.BytesPerPixel;
    Uint8 tPPitch = tformat.BytesPerPixel;
    // scanline width
    Uint32 sPitch = source->pitch();
    Uint32 tPitch = dest->pitch();

    s += f_x*sPPitch+f_y*sPitch;
    t += f_x*tPPitch+f_y*tPitch;
    sPitch -= w*sPPitch;
    tPitch -= w*tPPitch;

    for(Uint32 y=0;y<f_y+h;y++) {
        for(Uint32 x=0;x<f_x+w;++x) {
            if( sformat.BytesPerPixel == 2 )
                SDL_GetRGB(*(Uint16*)s,&sformat,&sR,&sG,&sB);
            else
                SDL_GetRGB(*(Uint32*)s,&sformat,&sR,&sG,&sB);

            if( !sR && !sG && !sB ) {
                if( sformat.BytesPerPixel == 2 )
                    *(Uint16*)t = (Uint16)SDL_MapRGB(&tformat,sR,sG,sB);
                else
                    *(Uint32*)t = (Uint32)SDL_MapRGB(&tformat,sR,sG,sB);
            }

            t += tPPitch;
            s += sPPitch;
        }
        s += sPitch;
        t += tPitch;
   }
    source->unlock();
    dest->unlock();
}

EvilMesh* Xenox2001::loadtxc(const char name[])
{
    ifstream ifs(name,ios::in|ios::nocreate);

    if( !ifs.is_open() )
	    throw Error("Xenox2001::loadtxc()","Evil script not present:",name);

    Parser parser(&ifs);

    Vector2 rel;
    float sca = 1.f;
    Matrix2 mirror(1,0,0,1);

    EvilMesh *mesh = new EvilMesh;
    int32 ppos;
    while( parser.getline()) {
        float a,b;

        if( strstr(parser.text(),"vertices") ) {
            sscanf(parser.text(),"vertices %i",&mesh->length);
            mesh->vertex = new Vector2[mesh->length];
            ppos = 0;
            continue;
        }

        if( strstr(parser.text(),"relative") ) {
            sscanf(parser.text(),"relative %f,%f",&a,&b);
            rel(a,b);
            continue;
        }

        if( strstr(parser.text(),"scale") ) {
            sscanf(parser.text(),"scale %f",&sca);
            continue;
        }

        if( strstr(parser.text(),"mirror") ) {
            sscanf(parser.text(),"mirror %f,%f",&a,&b);
            mirror(a,0,0,b);

            int32 mid = mesh->length/2;
            ppos = mid;
            for(int32 s=mid;s>0;s--) {
                mesh->vertex[ppos] = mesh->vertex[s-1];
                mirror.mulvec(&mesh->vertex[ppos++]);
            }
            continue;
        }

        sscanf(parser.text(),"coord %f,%f",&a,&b);
        mesh->vertex[ppos](a,b);
        mesh->vertex[ppos] -= rel;
        mesh->vertex[ppos] *= sca;
        ppos++;
    }

    float max = 0.f, min = 0.f;
    for(int32 i=0;i<mesh->length;i++) {
        float x = mesh->vertex[i].x();
        if( x < min )
            min = x;
        if( x > max )
            max = x;
    }
    mesh->radius = (max-min)/2.f;

    return(mesh);
}

EvilArea* Xenox2001::loadtxa(const char name[])
{
    ifstream ifs(name,ios::in|ios::nocreate);

    if( !ifs.is_open() )
	    throw Error("Xenox2001::loadtxa()","Evil script not present:",name);

    Parser parser(&ifs);

    EvilArea *area = new EvilArea;
    int32 ppos = 0;
    while( parser.getline()) {
        int a,b,c,d;
        if( strstr(parser.text(),"areas") ) {
            sscanf(parser.text(),"areas %i",&area->length);
            area->area = new Area[area->length];
            continue;
        }

        if( strstr(parser.text(),"area") ) {
            sscanf(parser.text(),"area %i,%i -> %i,%i",&a,&b,&c,&d);
            area->area[ppos++](a,b,c,d);
            continue;
        }
    }

    return(area);
}

void Xenox2001::draw_the_evil(int cx, int cy, float scale, float angle, Color &line, Color &fill, EvilMesh *mesh, BaseSurface *surface)
{
    Vector2 *vec = mesh->vertex;
    Matrix2 rotateevil;
    Matrix2 scaleevil;
    rotateevil.rotation(angle);
    scaleevil.scalar(scale,scale);

    // we are evil
    Sint16 *rx = new Sint16[mesh->length];
    Sint16 *ry = new Sint16[mesh->length];
    Vector2 tmp;
    int32 i;

    for(i=0;i<mesh->length;i++) {
        tmp = *vec;
        rotateevil.mulvec(&tmp);
        scaleevil.mulvec(&tmp);
        rx[i] = (Sint16)(tmp.x()+cx);
        ry[i] = (Sint16)(tmp.y()+cy);
        vec++;
    }

    filledPolygonRGBA(surface->SDLSurface(),rx,ry,mesh->length,fill.r(),fill.g(),fill.b(),fill.a());

    for(i=0;i<mesh->length;i++) {
        int32 p = (i+1) % mesh->length;
        aalineRGBA(surface->SDLSurface(),rx[i],ry[i],rx[p],ry[p],line.r(),line.g(),line.b(),line.a());
    }

    delete []rx;
    delete []ry;

    surface->unlock();
}

void Xenox2001::slide_the_evil()
{
    if( next_ypos < 0 )
        next_ypos = 0;

    if( next_ypos > info->height()-infoarea.h() )
        next_ypos = info->height()-infoarea.h();

    if( fabs(next_ypos-info_ypos) <= EVIL_TOLERANCE /* = HIGH */ )
        info_ypos = next_ypos;
    else {
        info_ypos += (next_ypos-info_ypos)*SCROLL_EVIL/info->height();
        evilrotation -= (next_ypos-info_ypos)*6.28f/25000.f;
    }
}

void Xenox2001::eod()
{
/*
    fonten->write(540,120,"test",droole);
    fonten->write(540,155,"",droole);
    fonten->write(540,185,"123",droole);
    fonten->write(540,282,"!",droole);
    fonten->write(540,312,"?",droole);
    fonten->write(540,344,"f",droole);
*/
    char score[256];

    sprintf(score,"%d\0",ducks_left+ducks_right);
    EvilPrintScore(score,540,120,fontarea,fonten,droole);
    sprintf(score,"%d\0",duck_hit_left+duck_hit_right);
    EvilPrintScore(score,540,155,fontarea,fonten,droole);
    sprintf(score,"%2.2f.2\0",(float)(duck_hit_left+duck_hit_right)/(float)(ducks_left+ducks_right));
    EvilPrintScore(score,540,185,fontarea,fonten,droole);
    sprintf(score,"%d\0",ducks_right);
    EvilPrintScore(score,540,282,fontarea,fonten,droole);
    sprintf(score,"%d\0",ducks_left);
    EvilPrintScore(score,540,312,fontarea,fonten,droole);

    Area area(540,344,640,480);
    if( ((float)duck_hit_left/(float)ducks_left) > ((float)duck_hit_right/(float)(ducks_right)) )
        droole->copy(fonten,fontarea->area[11],area);
    else
        droole->copy(fonten,fontarea->area[10],area);

    int old_timer = SDL_GetTicks();
    BaseSurface *backup = new Surface(buffer);
    area(0,0,backup->width(),backup->height());

    do {
        buffer->copy(backup);
        buffer->xfade(droole,area,(float)(1.f-(SDL_GetTicks()-old_timer)/3010.f));

        console->copy(buffer);
        console->update();
    } while( SDL_GetTicks() - old_timer < 3000 );

    old_timer = SDL_GetTicks();

    while( SDL_GetTicks() - old_timer < 5000 );
}
