.org $1001-2
.word $1001

	.word bas_end
	.word 2003
	.byte $de,"1,1:"	;graphic1,1:
	.byte $9e,"4114",0	;sys4114
bas_end:
	.byte 0,0

xc = $02ad
yc = $02af
plot = $c1a5


.zeropage
	level = $d0
	dir = $d1
	xlo = $d2
	ylo = $d3
.code

sys4114:
	inc $84

	;init
	lda #0
	sta dir
	sta xlo
	sta ylo
	lda #5
	sta level
	lda #83
	sta xc
	lda #172
	sta yc


count = $2048

drawX:
	lda #<(commandsX-1)
	pha
draw:
	dec level
	beq end

	lda #21
	tsx
	sta count,x
cy:	ldy count,x

	pla
	pha
	sta cm
cm = *+1
	lda commandsX-1,y
	sta addr_lo
addr_lo = *+1
	jsr $1000
	tsx
	dec count,x
	bne cy

end:	inc level
	pla
	rts

drawY:
	lda #<(commandsY-1)
	pha
	jmp draw
	
step:
s4:	jsr s2
s2:	jsr s1
s1:	ldx dir
	clc
	lda xlo
	adc vec_x0,x
	sta xlo
	lda xc
	adc vec_x1,x
	sta xc
	lda xc+1
	adc vec_x2,x
	sta xc+1

	clc
	lda ylo
	adc vec_y0,x
	sta ylo
	lda yc
	adc vec_y1,x
	sta yc
	lda yc+1
	adc vec_y2,x
	sta yc+1
	
	jmp plot

left:
	ldx dir
	inx
	cpx #6
	bne :+
	ldx #0
:	stx dir
	rts

right:
	ldx dir
	dex
	bpl :+
	ldx #5
:	stx dir
	rts

;X -> X+YF++YF-FX--FXFX-YF+
commandsX:
.byte <drawX,<left,<drawY,<step,<left,<left,<drawY,<step,<right,<step,<drawX
.byte <right,<right,<step,<drawX,<step,<drawX,<right,<drawY,<step,<left

;Y -> -FX+YFYF++YF+FX--FX-Y
commandsY:
.byte <right,<step,<drawX,<left,<drawY,<step,<drawY,<step,<left,<left,<drawY
.byte <step,<left,<step,<drawX,<right,<right,<step,<drawX,<right,<drawY


one = 255;128;180
hal = one/2
mon = 256-one
mha = 256-hal

ony = 128+64;64+32;156
moy = 256-ony

vec_x0:	.byte one,hal,mha,mon,mha,hal
vec_x1:
vec_x2:	.byte   0,  0,255,255,255,  0

vec_y0:	.byte   0,ony,ony,  0,moy,moy
vec_y1:
vec_y2:	.byte   0,  0,  0,  0,255,255
