;
; Digi 128
;
; Written by Csabo of LOD, 2003
; 
 	ORG $115C-2	; = SYS4444
	DW $115C
	
wait  = $EF       
count = $EE
	
	SEI
	;
	LSR $FF06	; turn screen off
	;
restart	INC count	; increase pattern counter
	LDA count
	AND #$1F	; limit to 32 bytes in pattern
	TAX
	LDA track,x
	STA datapos+1	; load data position for current
	;
	LDY #$00	; starting frequency
	;
main	INX
	TXA
	AND #$0F
	TAX
datapos	LDA snare,x
	STA $FF11
	STA $FF19
	;
	STY wait
	;
delay	ASL $A9		; just to make it slower
	DEC wait	; delay loop
	BNE delay
	;
	INY
	CPY #$B0	; ending frequency
	BNE main
	;
	BEQ restart	; always jump

	;
	; Quiet noise to emulate hihat or silence
	;
noise	DB $95,$94,$94,$94,$94,$94,$94,$94 
	DB $95,$94,$94,$94,$94,$94,$94,$94
	;                                        
	; Sine wave to emulate bass drum
	;
bass	DB $B0,$B0,$B1,$B3,$B5,$B7,$B8,$B8 
	DB $B8,$B8,$B7,$B5,$B3,$B1,$B0,$B0
	;                              
	; Random white noise to emulate snare
	;
snare	DB $90,$98,$92,$94,$97,$94,$93,$91 
	DB $95,$92,$98,$96,$91,$98,$92,$93
	
b = bass & 255
h = noise & 255
s = snare & 255
	;
	; The beat
	;
track	DB b,h,h,h, s,h,h,b, h,h,b,h, s,h,h,h
	DB b,h,h,h, s,h,h,b, h,h,b,h, s,h,h,b
	;