/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "demo.h"
#include <iostream>
#ifdef unix
#include "SDL.h"
#include "SDL_image.h"
#endif
#ifdef WIN32
#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#endif

using namespace std;

c_demo::c_demo()
{
	/* Read config */
	config.load("../data/config.cfg", 0);
	
	/* Set video settings */
	sdl.video.set_w(config.demo["video"].width);
	sdl.video.set_h(config.demo["video"].height);
	sdl.video.set_b(config.demo["video"].bpp);
	sdl.video.set_fs(config.demo["video"].fullscreen);
	
	/* Init SDL video */
	sdl.video.init();
}

void c_demo::manager()
{
	int i = 0; 
	c_waves waves;
	
	//sdl.video.texture16(surface, "../data/xangle.png");
	
	/* Load texture, and make it 16bits */		
	SDL_Surface *ts = IMG_Load("../data/xangle2.png");
	SDL_Surface *surface = get_surface(&sdl, ts->w, ts->h); // Image
	SDL_Rect dest; dest.x = 0; dest.y = 0; dest.w = ts->w; dest.h = ts->h;
	SDL_BlitSurface(ts, NULL, surface, &dest);
	SDL_FreeSurface(ts);

	/* Setup results bliting surface */
	SDL_Surface *surface2 = get_surface(&sdl, surface->w, surface->h);


	/* Setup cleanup bliting surface */
	//SDL_Surface *black = get_surface(&sdl, surface->w, surface->h);
	SDL_Surface *black = SDL_CreateRGBSurface(SDL_HWSURFACE, surface->w, surface->h, sdl.video.get_b(), 200, 0, 0, 0);
		//get_surface(&sdl, sdl.video.get_w(), sdl.video.get_h());

	/* Hide the mouse */
//	SDL_ShowCursor(0);
		
//	sdl.video.blit(surface, 0, 0); // test
	
//	surface2 = SDL_CreateRGBSurface(SDL_SWSURFACE, surface->w, surface->h,
//		sdl.video.get_b(), 0, 0, 0, 0);

	while(1)
	{	
	#if 1 // text
//		cout << "vert_fadeout" << endl;
		vert_fadeout(surface, surface2, 0, &sdl);
		sdl.video.blit(surface2, 0, 100);
		SDL_Delay(1000);
	
		for(i = 0; i < 40; i++) {
			vert_fadeout(surface, surface2, i, &sdl);
			sdl.video.blit(surface2, 0, 100);
			sdl.event.check();
		} 
	
		//sdl.video.screen = get_surface(&sdl, surface->w, surface->h);
		//sdl.video.blit(black, 0, 0);
		
		
//		SDL_Delay(1000);

	#endif
	#if 0 // waves
		waves.clearWaves();
//		waves.setWaveSpawnPoint(320/2, 240/2, 1.0f);
		waves.setDefaultWavePoints();
		for(i=0; i<300; i++)
		{
			waves.draw_waves(&sdl, sdl.video.get_w(), sdl.video.get_h(), 0, 0);
			SDL_Flip(sdl.video.screen);
			sdl.event.check();
		}
	#endif

		sdl.event.check();
	}
}


void draw_pixel(SDL_Surface *surface, int x, int y, Uint8 R, Uint8 G, Uint8 B)
{
	/* Create a ~"color identifier" */
	Uint32 color = SDL_MapRGB(surface->format, R, G, B);
	
	/* Get the memory location of the requested pixel
	 *  and change the color of it */
	Uint16 *bufp = (Uint16 *) surface->pixels + (y * surface->pitch/2) + x;
	if(y < 100) *bufp = color;
}

void draw_pixelc(SDL_Surface *surface, int x, int y, Uint32 color)
{
	Uint16 *bufp = (Uint16 *) surface->pixels + (y * surface->pitch/2) + x;
	*bufp = color;
}

void get_pixel(SDL_Surface *surface, int x, int y, Uint8 *R, Uint8 *G, Uint8 *B)
{	
	/* Get the memory location of the requested pixel */
	Uint16 *bufp = (Uint16 *) surface->pixels + y * surface->pitch/2 + x;
	SDL_GetRGB(*bufp, surface->format, R, G, B);
}

SDL_Surface *get_surface(c_sdl *sdl, int w, int h)
{
	return SDL_CreateRGBSurface(SDL_HWSURFACE, w, h, sdl->video.get_b(), 0, 0, 0, 0);
}
