/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "demo.h"
#include <iostream>
#include <stdio.h>

using namespace std;

/* Read the cfg's and store the data */
void c_config::load(char *filename, int type)
{
	FILE *fp = fopen(filename, "r");
	char buffer[255];
	char name[255];
	char target[255];
	char value[255];
		
	if(!fp) {
		cout << "Error opening file " << filename << endl;
		quit(1);
	}

	int cline = 0;
	while(!feof(fp))
	{
		memset(buffer, 0, 255);
		memset(name, 0, 255);
		memset(target, 0, 255);
		memset(value, 0, 255);
		
		fgets(buffer, 255, fp); cline++;
		if(feof(fp)) break;
			
		/* Only read data if there are something to read... */
		if(buffer[0] == '/' && buffer[1] == '*') continue;
		else if(buffer[0] == '/' && buffer[1] == '/') continue;
		else if(buffer[0] == '\n') continue;
		
		/* Read name */
		unsigned int p = 0, i = 0;
		while(buffer[i] != '.' && !(i >= strlen(buffer)))
			name[p++] = buffer[i++];

		/* Read target */
		p = 0; i++; // Reset array pointer and jump over '.'
		while(buffer[i] != ':' && !(i >= strlen(buffer)))
			target[p++] = buffer[i++];
			
		/* If we have reached end of buffer before we expected it */
		if(i >= strlen(buffer)) {
			cout << filename << "[" << cline << "]: unrecognized line: " 
				<< buffer;
			quit(1);
		}
		
		/* Read value */
		p = 0;
		i += 2; // Reset array pointer and jump over ': '
		while(buffer[i] != 10 && !(i >= strlen(buffer)))
			value[p++] = buffer[i++];

		/* Store data 		
		   This code can handle many diffrent cfg files, however we only
		   use one, so type is always 0 */
		if(!type) 
		{				
			/* Sound */
			if(!strcmp(target, "freq")) demo[name].freq = atoi(value);
			else if(!strcmp(target, "active")) demo[name].active=atoi(value);
			else if(!strcmp(target, "file"))  strcpy(demo[name].file, value);
			
			/* Video */
			else if(!strcmp(target, "width")) demo[name].width = atoi(value);
			else if(!strcmp(target, "height")) demo[name].height = atoi(value);
			else if(!strcmp(target, "bpp")) demo[name].bpp = atoi(value);
			else if(!strcmp(target, "fullscreen")) demo[name].fullscreen = atoi(value);			
		} 
	}
}
