/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define SCENE_FLASH		1
#define SCENE_INTROTEXT	1
#define SCENE_WAVES		1
#define SCENE_STARS		1
#define SCENE_PARTICLES	1
#define SCENE_SCROLLER	1
#define SOUND 1

#include "demo.h"
#include <iostream>
#ifdef unix
#include "SDL.h"
#include "SDL_image.h"
#endif
#ifdef WIN32
#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#endif

using namespace std;

c_demo::c_demo()
{
	/* Read config */
	config.load("../data/config.cfg", 0);
	
	/* Set video settings */
	sdl.video.set_w(config.demo["video"].width);
	sdl.video.set_h(config.demo["video"].height);
	sdl.video.set_b(config.demo["video"].bpp);
	sdl.video.set_fs(config.demo["video"].fullscreen);
	
	/* Init SDL video */
	sdl.video.init();
	
	/* Initiate sdl text */
	sdl.text.init("../data/font");
}

void clear_surface(SDL_Surface *surf)
{
	for(int y=0;y<surf->h;y++) {
		for(int x=0;x<surf->w;x++) {
			((Uint16*)surf->pixels)[x+(y*surf->pitch/2)] = 0x0000;
		}
	}
}

void c_demo::manager()
{
	int i = 0; 
//	SDL_Surface *surface, *surface2;
	c_waves waves;
	c_particles particles(100, &sdl);
	c_stars stars;
	
	stars.init(1000);
	SDL_ShowCursor(0);
	SDL_Delay(2000);
#if SOUND
	if(config.demo["sound"].active)
	{
		sdl.sound.init(config.demo["sound"].freq);
		sdl.sound.play(config.demo["sound"].file);
	}
#endif	
	SDL_Surface *dest_surface;
	dest_surface = SDL_CreateRGBSurface(SDL_SWSURFACE, 320,
		240, sdl.video.get_b(), 0, 0, 0, 0);
		
	/* Constructing intro text's */	
	SDL_Surface *it_xangle = get_surface(&sdl, 320, 100);
	sdl.text.draw("~ the xAngle crew ~", it_xangle, 320/2, 100/2-8, &sdl);

	SDL_Surface *it_presents = get_surface(&sdl, 320, 100);
	sdl.text.draw("presents", it_presents, 320/2, 100/2-8, &sdl);
	
	SDL_Surface *it_demo = get_surface(&sdl, 320, 100);
	sdl.text.draw("xa-001", it_demo, 320/2, 100/2-8, &sdl);

	
#if SCENE_INTROTEXT
	/* Drawing intro text */
	// ~ the xAngle Crew ~
	for(i = 0; i < 100; i++)
	{
		vert_fadeout2(it_xangle,dest_surface,&sdl,0,
			it_xangle->h/2,0,it_xangle->w,40,220,48,10);
		sdl.video.blit(dest_surface, 0, 0);
		sdl.event.check();
	}
	clear_surface(dest_surface);
	for(i = 0; i < 40; i++)
	{
		clear_surface(dest_surface);
		vert_fadeout2(it_xangle, dest_surface,&sdl,i,
			it_xangle->h/2,0,it_xangle->w,40,220,48, 5);
		sdl.video.blit(dest_surface, 0, 0);
		sdl.event.check();
		SDL_Delay(20);
	}
	clear_surface(dest_surface);
	

	// Presents
	for(i = 0; i < 100; i++)
	{
		vert_fadeout2(it_presents, dest_surface,&sdl,0,
			it_xangle->h/2,0,it_xangle->w,40,220, 100, 10);
		sdl.video.blit(dest_surface, 0, 0);
		sdl.event.check();
	}
	clear_surface(dest_surface);
	for(i = 0; i < 30; i++)
	{
		clear_surface(dest_surface);
		vert_fadeout2(it_presents, dest_surface,&sdl,i,
			it_xangle->h/2,0,it_xangle->w,30,220, 100, 10);
		sdl.video.blit(dest_surface, 0, 0);
		sdl.event.check();
		SDL_Delay(20);
	}
	clear_surface(dest_surface);

	
	// xa-001
	for(i = 0; i < 100; i++)
	{
		vert_fadeout2(it_demo, dest_surface,&sdl,0,
			it_xangle->h/2,0,it_xangle->w,40,290, 150, 10);
		sdl.video.blit(dest_surface, 0, 0);
		sdl.event.check();
	}

	clear_surface(dest_surface);
	for(i = 0; i < 30; i++)
	{
		clear_surface(dest_surface);
		vert_fadeout2(it_demo, dest_surface,&sdl,i,
			it_xangle->h/2,0,it_xangle->w,30,290, 150, 10);
		sdl.video.blit(dest_surface, 0, 0);
		sdl.event.check();
		SDL_Delay(20);
	}
	clear_surface(dest_surface);

#endif

	
	//while(1)
	//{	
	
	#if SCENE_WAVES // waves
		/* Rendering waves, and some text */
		waves.clearWaves();
		waves.setWaveSpawnPoint(320/2, 240/2, 1.0f);
		
		for(i=0; i<200; i++)
		{
			if(rand()%5==0) {
				waves.setWaveSpawnPoint(rand()%310+5,rand()%230+5,
					(float)rand()/RAND_MAX);
			}
			waves.draw_waves(&sdl,sdl.video.screen, 320, 240, 0, 0);
			SDL_Flip(sdl.video.screen);

			sdl.event.check();
		}

		// Waves - the xAngle crew's first
		clear_surface(it_xangle);
		sdl.text.draw("this is xAngle's first demo...", it_xangle, 70, 100/2-8, &sdl);
		for(i = 0; i < 200; i++)
		{
			if(rand()%5==0)
			{
				waves.setWaveSpawnPoint(rand()%310+5,
					rand()%230+5,(float)rand()/RAND_MAX);
			}
			waves.draw_waves(&sdl,dest_surface, 320, 240, 0, 0);
			vert_fadeout2(it_xangle,dest_surface,&sdl,0,
				it_xangle->h/2,0,320,40,-50,0,10);
			sdl.video.blit(dest_surface, 0, 0);
			sdl.event.check();
		}
		for(i = 0; i < 40; i++) {
			if(rand()%5==0) {
				waves.setWaveSpawnPoint(rand()%310+5,rand()%230+5,
					(float)rand()/RAND_MAX);
			}
			waves.draw_waves(&sdl,dest_surface, 320, 240, 0, 0);
			vert_fadeout2(it_xangle,dest_surface,&sdl,i,
				it_xangle->h/2,0,320,40,-50,0,10);
			sdl.video.blit(dest_surface, 0, 0);
			sdl.event.check();
		}
		
		clear_surface(it_xangle);
		sdl.text.draw("...but hopefully not the last", it_xangle, 70, 100/2-8, &sdl);
		
		for(i = 0; i < 200; i++) {
			if(rand()%5==0) {
				waves.setWaveSpawnPoint(rand()%310+5,rand()%230+5,
					(float)rand()/RAND_MAX);
			}
			waves.draw_waves(&sdl,dest_surface, 320, 240, 0, 0);
			vert_fadeout2(it_xangle,dest_surface,&sdl,0,
				it_xangle->h/2,0,320,40,-50,0,10);
			sdl.video.blit(dest_surface, 0, 0);
			sdl.event.check();
		}
		
		for(i = 0; i < 40; i++) {
			if(rand()%5==0) {
				waves.setWaveSpawnPoint(rand()%310+5,rand()%230+5,
					(float)rand()/RAND_MAX);
			}
			waves.draw_waves(&sdl,dest_surface, 320, 240, 0, 0);
			vert_fadeout2(it_xangle,dest_surface,&sdl,i,
				it_xangle->h/2,0,320,40,-50,0,10);
			sdl.video.blit(dest_surface, 0, 0);
			sdl.event.check();
		}

	#endif

		// particles
	#if SCENE_PARTICLES
		if(SCENE_FLASH)
			flash(&sdl);
		
		float h=0;
		float ts=0;
		for(i=0;i<100;i++)
		{
			clear_surface(dest_surface);
			
/*			//flash, fram och tebax
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,10.37,10.37,
				9.22,0.77,0.03,70,dest_surface->w/2,
				dest_su rface->h/2,0.3,0.3,40.0,40.0,0,0);
 */
			
     		particles.draw2(&sdl,dest_surface,1.0,0.12f,0.37,0.37,
		     1.22,0.77,0.03,70,dest_surface->w/2,
		     dest_surface->h/2,0.3,0.3,40.0,40.0,0,0,0,15*ts,31*ts); // \o/
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
			ts+=0.01f;
		}
		float svans = 1.0f;
		for(i=0;i<250;i++)
		{
			clear_surface(dest_surface);
			
/*			//flash, fram och tebax
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,10.37,10.37,
				9.22,0.77,0.03,70,dest_surface->w/2,
				dest_surface->h/2,0.3,0.3,40.0,40.0,0,0);
 */
			
     		particles.draw2(&sdl,dest_surface,1.0*svans,0.12f,0.37,0.37,
		     1.22,0.77,0.03+h,70,dest_surface->w/2,
		     dest_surface->h/2,0.3,0.3,40.0,40.0,0.3f,0.0f,0,15,31); // \o/
			h+=0.0002f;
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
			svans+=0.02f;
		}
		float colors = 0.0;
		for(i=0;i<50;i++)
		{
			clear_surface(dest_surface);
			
/*			//flash, fram och tebax
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,10.37,10.37,
				9.22,0.77,0.03,70,dest_surface->w/2,
				dest_surface->h/2,0.3,0.3,40.0,40.0,0,0);
 */
			
     		particles.draw2(&sdl,dest_surface,1.0*svans,0.12f,0.37,0.37,
		     1.22,0.77,0.03+h,70,dest_surface->w/2,
		     dest_surface->h/2,0.3,0.3,40.0,40.0,0.3f,0.0f,31*colors,15 + (16*colors),31); // \o/
			h+=0.0002f;
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
			svans+=0.02f;
			colors+=0.02;
		}
		particles.killall();
		for(i=0;i<250;i++) {
			clear_surface(dest_surface);
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,16.37,16.37,
			1.22,0.77,0.03,70,dest_surface->w/2,
			dest_surface->h/2,0.3,0.3,40.0,40.0,0,0,31,31,31);
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
		}
		colors = 0;
		for(i=0;i<50;i++) {
			clear_surface(dest_surface);
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,16.37,16.37,
			1.22,0.77,0.03,70,dest_surface->w/2,
			dest_surface->h/2,0.3,0.3,40.0,40.0,0,0,31,31-(16*colors),31);
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
			colors+=0.02;
		}
		for(i=0;i<200;i++) {
			clear_surface(dest_surface);
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,10.37,10.37,
				9.22,0.77,0.03,70,dest_surface->w/2,
				dest_surface->h/2,0.3,0.3,40.0,40.0,0,0,31,15,31);
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
		}
		for(i=0;i<200;i++) {
//			clear_surface(dest_surface);
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,10.37,10.37,
				9.22,0.77,0.03,70,dest_surface->w/2,
				dest_surface->h/2,0.3,0.3,40.0,40.0,0,0,31,31,31);
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
		}
	#endif
		if(SCENE_FLASH)
			flash(&sdl);
		
	#if SCENE_STARS
		stars.draw(&sdl);
		flash(&sdl);
	#endif
		flash(&sdl);
		for(i=0;i<300;i++) {
			clear_surface(dest_surface);
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,10.37,10.37,
				9.22,0.77,0.03,1,dest_surface->w/2,
				dest_surface->h/2,0.3,0.3,40.0,40.0,0,0,31,31,31);
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
		}
		float cc = 0;
		for(i=0;i<125;i++) {
			cc+=0.5;
			clear_surface(dest_surface);
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,10.37,10.37,
				9.22,0.77,0.03,1,dest_surface->w/2,
				dest_surface->h/2,0.3,0.3,40.0,40.0,0,0,(sin(cc*cc) * 35/2) + 35/2,(sin(cc*cc) * 35/2) + 35/2,(sin(cc*cc) * 35/2) + 35/2);
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
		}

		float colorsaken=1;
		for(i=0;i<62;i++) {
			cc+=0.5;
			colorsaken-=1.0/62.0;
			clear_surface(dest_surface);
			particles.draw2(&sdl,dest_surface,1.0,0.000000012f,10.37,10.37,
				9.22,0.77,0.03,1,dest_surface->w/2,
				dest_surface->h/2,0.3,0.3,40.0,40.0,0,0,((sin(cc*cc) * 35/2) + 35/2)*colorsaken,
							((sin(cc*cc) * 35/2) + 35/2)*colorsaken,
							((sin(cc*cc) * 35/2) + 35/2)*colorsaken);
			sdl.video.blit(dest_surface, 0, 0);				
			sdl.event.check();
		}
		
		clear_all(&sdl);
		if( SCENE_SCROLLER )
			end_text(&sdl, &config);
		
		sdl.event.check();
	//}
}


void draw_pixel(SDL_Surface *surface, int x, int y, Uint8 R, Uint8 G, Uint8 B)
{
	/* Create a ~"color identifier" */
	Uint32 color = SDL_MapRGB(surface->format, R, G, B);
	
	/* Get the memory location of the requested pixel
	 *  and change the color of it */
	Uint16 *bufp = (Uint16 *) surface->pixels + (y * surface->pitch/2) + x;
	if(y < 100) *bufp = color;
}

void draw_pixelc(SDL_Surface *surface, int x, int y, Uint32 color)
{
	Uint16 *bufp = (Uint16 *) surface->pixels + (y * surface->pitch/2) + x;
	*bufp = color;
}

void get_pixel(SDL_Surface *surface, int x, int y, Uint8 *R, Uint8 *G, Uint8 *B)
{	
	/* Get the memory location of the requested pixel */

/*	cout << "format->BitsPerPixel: " << (int)(surface->format->BitsPerPixel) << endl;
	cout << "format->BytePerPixel: " << (int)(surface->format->BytesPerPixel) << endl;
	cout << "format->Rloss: " << (int)(surface->format->Rloss) << endl;
	cout << "format->Gloss: " << (int)(surface->format->Gloss) << endl;
	cout << "format->Bloss: " << (int)(surface->format->Bloss) << endl;
	cout << "format->Aloss: " << (int)(surface->format->Aloss) << endl;
	cout << "format->Rshift: " << (int)(surface->format->Rshift) << endl;
	cout << "format->Gshift: " << (int)(surface->format->Gshift) << endl;
	cout << "format->Bshift: " << (int)(surface->format->Bshift) << endl;
	cout << "format->Ashift: " << (int)(surface->format->Ashift) << endl;
	cout << "format->Rmask: " << (int)(surface->format->Rmask) << endl;
	cout << "format->Gmask: " << (int)(surface->format->Gmask) << endl;
	cout << "format->Bmask: " << (int)(surface->format->Bmask) << endl;
	cout << "format->Amask: " << (int)(surface->format->Amask) << endl;
*/
	Uint16 *bufp = (Uint16 *) surface->pixels + y * surface->pitch/2 + x;
	SDL_GetRGB(*bufp, surface->format, R, G, B);
}

SDL_Surface *get_surface(c_sdl *sdl, int w, int h)
{
	return SDL_CreateRGBSurface(SDL_HWSURFACE, w, h,
		sdl->video.get_b(), 0, 0, 0, 0);
}

void clear_all(c_sdl *sdl)
{
	SDL_Surface *black = get_surface(sdl, 
		sdl->video.get_w(), sdl->video.get_h());
	sdl->video.blit(black, 0, 0);
}
