/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef DEMO_H
#define DEMO_H

#include <string>
#include <map>

#ifdef unix
#include "SDL.h"
#endif
#ifdef WIN32
//#include <windows.h>
#include "SDL/SDL.h"
#endif

using namespace std;

#define WINDOW_TITLE "xa-001: a demo by the xAngle crew."

#define OUR_PI 3.1415926535897932384626433832795

/* config.cpp */
typedef struct {
	/* sound. cfg items */
	int freq, active;
	char file[256];
	
	/* video. cfg items */
	int width, height, bpp, fullscreen;
} c_democonfig;

class c_config {
public:
	void load(char *filename, int type);
	map<string, c_democonfig> demo;
};

/* support.cpp */
void quit(int exitcode);

/* sdls.cpp */
class c_sdl_text {
public:
	void init(char *file);
	void draw(char *text, SDL_Surface *surface,
		int x, int y, class c_sdl *sdl, ...);
private:
	int *widths;
	SDL_Surface *font;
};

class c_sdl_video {
public:
	void init();
	void blit(SDL_Surface *surface, int x, int y);
	void blitc(SDL_Surface *source, SDL_Surface *target, int x, int y);
	void texture16(SDL_Surface *surface, char *file);

	/* Video info accessors */
	int get_fs() { return fs; };
	int get_w() { return w; };
	int get_h() { return h; };
	int get_b() { return b; };
	
	/* Video info sets */
	void set_fs(int fullscreen) { fs = fullscreen; };
	void set_w(int width) { w = width; };
	void set_h(int height) { h = height; };
	void set_b(int bpp) { b = bpp; };
	
	int flags; // Video flags
	SDL_Surface *screen;
private:
	int fs, w, h, b;
};

class c_sdl_sound {
public:
	void init(int freq);
	void play(char *file);
	void stop();
};

class c_sdl_event {
public:
	void check();
private:
	SDL_Event event;
};

class c_sdl  {
public:
	c_sdl();
	c_sdl_video video;
	c_sdl_sound sound;
	c_sdl_event event;
	c_sdl_text text;
};


/* graphics.cpp */
struct c_color { Uint8 r, g, b, x; };
#if 0
class c_surface {
public:
	c_surface(int w, int h) { pixels = new c_color[w*h]; };
	unsigned int width, height, pitch;
	c_color *pixels;
};

class c_graphics {
public:
	void blit(c_surface *surface, int x, int y, c_sdl *sdl);
};
#endif

/* demo.cpp */
class c_demo {
public:
	c_demo();
	void manager();
private:
	c_sdl sdl;
	c_config config;
};

void draw_pixelc(SDL_Surface *surface, int x, int y, Uint32 color);
void draw_pixel(SDL_Surface *surface, int x, int y, Uint8 R, Uint8 G, Uint8 B);
void get_pixel(SDL_Surface *surface, int x, int y,
						Uint8 *R, Uint8 *G, Uint8 *B);
SDL_Surface *get_surface(c_sdl *sdl, int w, int h);
void clear_all(c_sdl *sdl);
void clear_surface(SDL_Surface *surf);

/** SCENES **/

/* Waves */
class c_waves
{
public:
	c_waves();
	~c_waves()
	{
		delete [] z;
		delete [] z1;
	}

	void draw_waves(c_sdl *sdl,SDL_Surface *dest, unsigned int width, unsigned int height,
		unsigned int texture_height, unsigned int texture_width);
	void clearWaves();
	void setDefaultWavePoints();
	void setWaveSpawnPoint(int spawnX, int spawnY, float life);

	void setWaveframe(int frame) { cp = frame; };
	int getWaveframe() { return cp; };
	
private:
	float* z;
	float* z1;
	int cp;
};

/* Vertical fadeout */
//void vert_fadeout(SDL_Surface *src_surface, int amt, c_sdl *sdl);

void vert_fadeout2(SDL_Surface *src_surface,SDL_Surface *dest_surface, c_sdl *sdl, int amt,
				   int effect_middle, int xstart, int xend, int amt_max,
				   int dst_x, int dst_y, int height);

/* End text */
void end_text(c_sdl *sdl, c_config *config);

/* Pariticles */
struct c_part {
    //Uint8 active; // Active
    float life;   // Particle Life
    //int fade;   // Fade Speed

    Uint8 r, g, b;  // RGB
    int x, y;    // Position
    float xdir, ydir; // Direction	
};

class c_particles {
public:
	c_particles(int partnum, c_sdl *sdl);
	~c_particles();
	void draw(c_sdl *sdl);
	void draw2(c_sdl *sdl,SDL_Surface *dest,float life,float life_decay,
						float x_speed,float y_speed,float x_scale,float y_scale,
						float rotation_speed, float rotation_distance, int x_center,
						int y_center,float x_framespeed,float y_framespeed,
						float x_radius,float y_radius,float x_gravity,float y_gravity,
						float color_r,float color_g,float color_b);
	void killall() {for(int i=0;i<num_of_parts;i++) parts[i].life = -1.0f;}
private:
	SDL_Surface *particle;
	SDL_Surface *src_particle;
	int num_of_parts;
	c_part *parts;
	int x_emit;
	int y_emit;
	float t;
};

/* Flash */
void flash(c_sdl *sdl);

/* Starfield */
typedef struct {
  float x, y;
  short z, spd;
  Uint16 color;
} c_star;

class c_stars {
public:
	void init(int numstars);
	void sinit(c_star *star, int i);
	void draw(c_sdl *sdl);
private:
	int num_of_stars;
	c_star *stars;
	Uint16 color;
	int r,g,b;
};


#endif
