/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "demo.h"
#include <string>
#include <stdarg.h>

#ifdef unix
#include "SDL.h"
#include "SDL_mixer.h"
#include "SDL_image.h"
#endif
#ifdef WIN32
#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"
#include "SDL/SDL_image.h"
#endif

#include <iostream>

using namespace std;

c_sdl::c_sdl()
{	
	if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_TIMER) < 0) {
		cout << "Unable to init SDL: " << SDL_GetError() << endl;
		quit(1);
	}		
}

void c_sdl_sound::init(int freq)
{
	/* Open 44.1KHz, signed 16bit, system byte order, stereo audio,
	 * using 1024 byte chunks */
	if(Mix_OpenAudio(freq, MIX_DEFAULT_FORMAT, 2, 1024) == -1)	
		cout << "Mix_OpenAudio: " << Mix_GetError() << endl;
}

void c_sdl_sound::play(char *file)
{
	Mix_Music *music;
	FILE *fp = fopen(file, "r");
	if(fp)
	{
		/* Open 44.1KHz, signed 16bit, system byte order, stereo audio,
		 * using 1024 byte chunks */
		if(-1 == Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 1024))
		{
			fprintf(stderr, "Mix_OpenAudio: %s\n", Mix_GetError());
		}
		Mix_VolumeMusic(MIX_MAX_VOLUME);
		
		/* Load the music file specified in config */
		music = Mix_LoadMUS(file);

		if(!music)
		{
			/* This might be a critical error... */
			fprintf(stderr, "Mix_LoadMUS(\"%s\"): %s\n", file, Mix_GetError());
		}

		/* Start playing in an infinite loop */
		if(-1 == Mix_PlayMusic(music, -1))
		{
			/* No music */
			fprintf(stderr, "Mix_PlayMusic: %s\n", Mix_GetError());
		}
	}
	else
	{
		fprintf(stderr, "Could not open %s.\n", file);
		fprintf(stderr, "Sound dissabled\n");
	}
}

void c_sdl_video::init()
{
		
		/* Fetch the video info */
    	const SDL_VideoInfo *video_info;
		if(!(video_info = SDL_GetVideoInfo())) {
	   		cout << "Video query failed: " << SDL_GetError() << endl;
	    	exit(1);
		}
    	
		flags = SDL_HWPALETTE;       /* Store the palette in hardware */
		
    	if(video_info->hw_available)
			flags |= SDL_HWSURFACE;
    	else
			flags |= SDL_SWSURFACE;

	    /* Check if hardware blits can be done */
   		if(video_info->blit_hw)
			flags |= SDL_HWACCEL;

		if(fs)
			flags |= SDL_FULLSCREEN;
		
		
		/* Create the screen */		
		if(!(screen = SDL_SetVideoMode(w, h, b, flags))) {
	    	cout << "Video mode set failed: " << SDL_GetError() << endl;
	    	quit(1);
		}
	
		SDL_WM_SetCaption(WINDOW_TITLE, NULL);
}

void c_sdl_video::blit(SDL_Surface *surface, int x, int y)
{		
	SDL_Rect dest;
	dest.x = x;
	dest.y = y;
	dest.w = surface->w;
	dest.h = surface->h;
	
	SDL_BlitSurface(surface, NULL, screen, &dest);
	SDL_UpdateRect(screen, dest.x, dest.y, dest.w, dest.h);
	SDL_Flip(screen);
}

void c_sdl_video::blitc(SDL_Surface *source, SDL_Surface *target,
	int x, int y)
{		
	SDL_Rect dest;
	dest.x = x;
	dest.y = y;
	dest.w = source->w;
	dest.h = source->h;
	
	SDL_BlitSurface(source, NULL, target, &dest);
}

void c_sdl_video::texture16(SDL_Surface *surface, char *file)
{
	SDL_Surface *ts = IMG_Load(file);
	surface = SDL_CreateRGBSurface(SDL_SWSURFACE, ts->w, ts->h,
		get_b(), 0, 0, 0, 0);
	SDL_Rect dest; dest.x = 0; dest.y = 0; dest.w = ts->w; dest.h = ts->h;
	SDL_BlitSurface(ts, NULL, surface, &dest);
	SDL_FreeSurface(ts);
}

void c_sdl_event::check()
{
	while(SDL_PollEvent(&event))
	{
	    switch(event.type)
		{		    
		case SDL_KEYDOWN:
			switch (event.key.keysym.sym)
			{
			case SDLK_ESCAPE:
				quit(0);
				break;
			default:
				break;
			} break;
		case SDL_QUIT:
			quit(0);
		    break;
		default:
		    break;
		}
	}
}
void c_sdl_text::init(char *fontname)
{
	char temp[128], temp2[128], buffer[3];
	int i = 0;
	widths = new int[256];
	
	
	sprintf(temp, "%s%s", fontname, ".fs");
	sprintf(temp2, "%s%s", fontname, ".bmp");
	FILE *fp = fopen(temp, "rb");
	
	while(!feof(fp))
	{
		/* Read one line(a number) characters */
		fgets(buffer, 3, fp);
		
		/* Fill widths with these numbers */
		widths[i++] = atoi(buffer);
	}
	
	/* Load font */
	font = SDL_LoadBMP(temp2);
}
/* This functions draws text to the surface sent to it */
void c_sdl_text::draw(char *text, SDL_Surface *surface,
		int x, int y, c_sdl *sdl, ...)
{
	char string[1024];              // Temporary string

	va_list ap;                     // Pointer To List Of Arguments
	va_start(ap, sdl);              // Parses The String For Variables
	vsprintf(string, text, ap);      // And Converts Symbols To Actual Numbers
	va_end(ap);                     // Results Are Stored In Text

	Uint16 len = strlen(string);	// Get the number of chars in the string
	
	SDL_Rect dest, src;

	dest.x = x;
	dest.y = y;
	src.h  = 16;

	/* Loop through all the chars in the string and print them */
	for (int i=0 ; i<len ; i++)
	{
		if (string[i] == '\n')	//new line
		{
			dest.y += 16;
			dest.x = x;
		}
		else
		{
			src.w	= widths[string[i]]+2;
			src.x	= ((string[i]%16)*16) + (16-widths[string[i]])/2;
			src.y	= (Uint16(string[i])/16)*16;

			SDL_BlitSurface(font, &src, surface, &dest);
			
			/* Now we increase dest.x by the width of the
			 * drawn character */
			dest.x += widths[string[i]];
		}
	}
	
	//sdl->video.blit(font, 0, 0);
}
