/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../demo/demo.h"

using namespace std;

/* Vertical fadeout */
void vert_fadeout(SDL_Surface *src_surface, SDL_Surface *dest_surface, int amt, c_sdl *sdl)
{
	/* This function will fade the src_surface vertically the ammount
	 * of "amt", with the result ending up in dest_surface which is
	 * then blited to screen. */
		
	/* Middle y of the picture */
	int y = src_surface->h/2, x; 

	/* Create storage for pixels */
	c_color *c = new c_color[src_surface->w];

	/* Get the color of every pixel in middle y */
	for(x = 0; x < src_surface->w; x++)
	{
		get_pixel(src_surface, x, y, &c[x].r, &c[x].g, &c[x].b);

	}

	/* Draw fade downwards */
	for(y = src_surface->h/2; y < src_surface->h/2+amt; y++)
	{
		for(x = 0; x < src_surface->w; x++)
		{
			if(c[x].r || c[x].g || c[x].b)
				draw_pixel(dest_surface, x, y,
					c[x].r-amt*4, c[x].g-amt*4, c[x].b-amt*4);
	 	}
	}

	/* Draw fade upwards */
	for(y = src_surface->h/2; y > src_surface->h/2-amt; y--)
	{
		for(x = 0; x < src_surface->w; x++)
		{
			if(c[x].r || c[x].g || c[x].b)
				draw_pixel(dest_surface, x, y,
					c[x].r-amt*4, c[x].g-amt*4, c[x].b-amt*4);
		}
	}
	

	/* Draw the rest */
	Uint8 r,g,b;
	for(y = (src_surface->h/2); y > 0; y--)
	{
		for(x = 0; x < src_surface->w; x++)
		{
			get_pixel(src_surface, x, y, &r, &g, &b);
			
			if(y-amt >= 0 && (r || g || b))
				draw_pixel(dest_surface, x, y-amt,
					r-amt*4, g-amt*4, b-amt*4);
		}
	}
	
	for(y = src_surface->h/2; y < src_surface->h; y++)
	{
		for(x = 0; x < src_surface->w; x++)
		{
			get_pixel(src_surface, x, y, &r, &g, &b);
			if(y+amt <= src_surface->h && (r || g || b))
				draw_pixel(dest_surface, x, y+amt,
					r-amt*4, g-amt*4, b-amt*4);
		}
	}
	
	delete [] c;
}
