/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../demo/demo.h"
#ifdef unix
#include "SDL_image.h"
#include "SDL_mixer.h"
#endif
#ifdef WIN32
#include "SDL/SDL_image.h"
#include "SDL/SDL_mixer.h"
#endif

using namespace std;

void end_text(c_sdl *sdl, c_config *config)
{
	/* Cleating end scroller */
	SDL_Surface *it_end = get_surface(sdl, 320, 660);
	
	
	sdl->text.draw("xa-001: a demo by the xAngle crew", it_end, 0, 16, sdl);
	sdl->text.draw("xAngle:", it_end, 0, 16*3-5, sdl);
	sdl->text.draw("targhan {coding}", it_end, 0, 16*4, sdl);
	sdl->text.draw("trejs   {coding, gfx}", it_end, 0, 16*5, sdl);
	sdl->text.draw("damnter {coding, gfx}", it_end, 0, 16*6, sdl);
	sdl->text.draw("Dinny   {music}", it_end, 0, 16*7, sdl);
	
	sdl->text.draw("Thanks:", it_end, 0, 16*11, sdl);
	sdl->text.draw("                   The GNU Project", it_end, 0, 16*13, sdl);
	
	
	sdl->text.draw("The people behind the", it_end, 0, 16*23, sdl);
	sdl->text.draw("Simple Directmedia Layer, SDL!",it_end,40,16*24, sdl);
	
	sdl->text.draw("The people who manages the great sites", it_end, 0, 16*27, sdl);
	sdl->text.draw("http://www.lnxscene.org", it_end, 60, 16*28, sdl);
	sdl->text.draw("and", it_end, 80, 16*29, sdl);
	sdl->text.draw("http://unixscene.kameli.net", it_end, 60, 16*30, sdl);
	
	sdl->text.draw("The great deadline party of 2003", it_end, 30, 16*33, sdl);
	sdl->text.draw("where this demo was coded.", it_end, 30, 16*34, sdl);
		
	sdl->text.draw("...the end.", it_end, 0, 16*40, sdl);
	
	SDL_Surface *gnu = IMG_Load("../data/gnu.png");
	SDL_Surface *xangle = IMG_Load("../data/xangle_logo.png");
	
	sdl->video.blitc(gnu, it_end, 0, 16*13);
	sdl->video.blitc(xangle, it_end, 320 - xangle->w, 16*2);
	
	
	Uint32 vol = 128;
	int a = 0;
	for(int i = 240; i > -420; i--) {
		if(++a == 5 && config->demo["sound"].active)
		{
			a = 0;			
			Mix_VolumeMusic(vol--);
		}
		sdl->video.blit(it_end, 0, i);
		sdl->event.check();
		SDL_Delay(15);
	}

	SDL_Delay(4000);
}
