/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../demo/demo.h"
#include <iostream>

using namespace std;

void vert_fadeout2(SDL_Surface *src_surface,SDL_Surface *dest_surface, c_sdl *sdl, int amt,
				   int effect_middle, int xstart, int xend, int amt_max,
				   int dst_x, int dst_y, int height)
{
	/* Get the middle row pixels and extrude up/down by amt */
	int x,y;
	unsigned int src_pitch, dst_pitch;
	unsigned int t_y;
	
	Uint16 colors;
	
	float alpha = ((amt_max - (float)amt) / amt_max);
	float inv_alpha = 1-alpha;
	
	float r,g,b,sr,sg,sb;
	
	src_pitch = src_surface->pitch/2;
	dst_pitch = dest_surface->pitch/2;
	for(x=xstart;x<xend;x++) {
		colors = ((Uint16*)src_surface->pixels)[x + ((effect_middle) * src_pitch)];
			if(colors) {
			sr = colors>>11;
			sg = (colors&2016)>>6;
			sb = colors&31;

			for(t_y = effect_middle;t_y < (unsigned)(effect_middle+amt);t_y++)
			{
				colors = ((Uint16*)dest_surface->pixels)[dst_x + x + ((dst_y + t_y) * dst_pitch)];
				r = colors>>11;
				g = (colors&2016)>>6;
				b = colors&31;
				r = sr*alpha + r*inv_alpha;
				g = sg*alpha + g*inv_alpha;
				b = sb*alpha + b*inv_alpha;
				colors = (((int)r)<<11) + (((int)g)<<6) + (((int)b));
				((Uint16*)dest_surface->pixels)[dst_x + x + ((dst_y + t_y) * dst_pitch)] = colors;
//				alpha *= 0.95f;
//				inv_alpha = 1-alpha;
			}
//cout << "m03" << endl;	
			alpha = ((amt_max - (float)amt) / amt_max);
			inv_alpha = 1-alpha;
			for(t_y = effect_middle-1;t_y > (unsigned)(effect_middle-amt);t_y--)
			{
				colors = ((Uint16*)dest_surface->pixels)[dst_x + x + ((dst_y + t_y) * dst_pitch)];
				r = colors>>11;
				g = (colors&2016)>>6;
				b = colors&31;
				r = sr*alpha + r*inv_alpha;
				g = sg*alpha + g*inv_alpha;
				b = sb*alpha + b*inv_alpha;
				colors = (((int)r)<<11) + (((int)g)<<6) + (((int)b));
				((Uint16*)dest_surface->pixels)[dst_x + x + ((dst_y + t_y) * dst_pitch)] = colors;
//				alpha *= 0.95f;www.gamedev.net/
//				inv_alpha = 1-alpha;
			}
		}
	}
//cout << "m004" << endl;	
	for(y=effect_middle;y<effect_middle+height;y++)
	{
		for(x=xstart;x<xend;x++)
		{
			colors = ((Uint16*)src_surface->pixels)[x + (y * src_pitch)];
			if(colors)
			{
				sr = colors>>11;
				sg = (colors&2016)>>6;
				sb = colors&31;
				colors = ((Uint16*)dest_surface->pixels)[dst_x + x + ((dst_y + y + amt) * dst_pitch)];
				r = colors>>11;
				g = (colors&2016)>>6;
				b = colors&31;
				r = sr*alpha + r*inv_alpha;
				g = sg*alpha + g*inv_alpha;
				b = sb*alpha + b*inv_alpha;
				colors = (((int)r)<<11) + (((int)g)<<6) + (((int)b));
				((Uint16*)dest_surface->pixels)[dst_x + x + ((dst_y + y + amt) * dst_pitch)] = colors;
			}
		}
	}
//cout << "m005" << endl;	
	for(y=effect_middle;y>effect_middle-height;y--)
	{
		for(x=xstart;x<xend;x++)
		{
			colors = ((Uint16*)src_surface->pixels)[x + (y * src_pitch)];
			if(colors)
			{
				sr = colors>>11;
				sg = (colors&2016)>>6;
				sb = colors&31;
				colors = ((Uint16*)dest_surface->pixels)[dst_x + x + ((dst_y + y - amt) * dst_pitch)];
				r = colors>>11;
				g = (colors&2016)>>6;
				b = colors&31;
				r = sr*alpha + r*inv_alpha;
				g = sg*alpha + g*inv_alpha;
				b = sb*alpha + b*inv_alpha;
				colors = (((int)r)<<11) + (((int)g)<<5) + (((int)b));
				((Uint16*)dest_surface->pixels)[dst_x + x + ((dst_y + y - amt) * dst_pitch)] = colors;
			}
		}
	}
//cout << "m006" << endl;	
}

/* Vertical fadeout */
void vert_fadeout(SDL_Surface *src_surface, int amt, c_sdl *sdl)
{
	/* This function will fade the src_surface vertically the ammount
	 * of "amt", with the result ending up in dest_surface which is
	 * then blited to screen. */
	
	SDL_Surface *dest_surface;

	/* Create the destination surface */
	dest_surface = SDL_CreateRGBSurface(SDL_SWSURFACE, src_surface->w,
		src_surface->h, sdl->video.get_b(), 0, 0, 0, 0);
	
	/* Middle y of the picture */
	int y = src_surface->h/2, x; 

	/* Create storage for pixels */
	c_color *c = new c_color[src_surface->w];

	/* Get the color of every pixel in middle y */
//cout << "m00 ";
	for(x = 0; x < src_surface->w; x++)
	{
//cout << "i:" << i++ << endl;
		get_pixel(src_surface, x, y, &c[x].r, &c[x].g, &c[x].b);
		sdl->event.check();

	}
//cout << "m00 ";

	/* Draw fade downwards */
	for(y = src_surface->h/2; y < src_surface->h/2+amt; y++)
	{
		for(x = 0; x < src_surface->w; x++)
		{
			if(c[x].r || c[x].g || c[x].b)
				draw_pixel(dest_surface, x, y,
					c[x].r-amt*4, c[x].g-amt*4, c[x].b-amt*4);
	 	}
		sdl->event.check();
	}

//cout << "m00 ";
	/* Draw fade upwards */
	for(y = src_surface->h/2; y > src_surface->h/2-amt; y--)
	{
		for(x = 0; x < src_surface->w; x++)
		{
			if(c[x].r || c[x].g || c[x].b)
				draw_pixel(dest_surface, x, y,
					c[x].r-amt*4, c[x].g-amt*4, c[x].b-amt*4);
		}
		sdl->event.check();
	}
//cout << "m00 ";
	

	/* Draw the rest */
	Uint8 r,g,b;
	for(y = (src_surface->h/2); y > 0; y--)
	{
		for(x = 0; x < src_surface->w; x++)
		{
//cout << i << " ";
			get_pixel(src_surface, x, y, &r, &g, &b);
			
			if(y-amt >= 0 && (r || g || b))
				draw_pixel(dest_surface, x, y-amt,
					r-amt*4, g-amt*4, b-amt*4);
		}
		sdl->event.check();
	}
//cout << "m00 ";
	
	for(y = src_surface->h/2; y < src_surface->h; y++)
	{
		for(x = 0; x < src_surface->w; x++)
		{
			get_pixel(src_surface, x, y, &r, &g, &b);
			if(y+amt <= src_surface->h && (r || g || b))
				draw_pixel(dest_surface, x, y+amt,
					r-amt*4, g-amt*4, b-amt*4);
		}
		sdl->event.check();
	}
//cout << "m00 ";

	sdl->video.blit(dest_surface, 0, (sdl->video.get_h()) - dest_surface->h);
	
//cout << "END " << endl;
	delete [] c;
}
