/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../demo/demo.h"
#include <iostream>

using namespace std;

void flash(c_sdl *sdl)
{
	SDL_Surface *surface = get_surface(sdl, sdl->video.screen->w,
		sdl->video.screen->h);
	int go = 1, run = 0, r, g, b;
	float color = 0;
	Uint16 clrs;
	
	/* Draw black-to-white-to-black fade */
	while(run != 3)
	{
		if(go == 1 && color <= 0.0f) { go = 2; run++; }
		else if(go == 2 && color > 1.0f) { go = 1; run++; }
			
		if(go == 1) color -= 0.03f;
		else if(go == 2) color += 0.03f;
		
		r = (int)(31 * color);
		g = (int)(63 * color);
		b = (int)(31 * color);
		for(int i = 0; i < surface->w; i++)
		{
			for(int j = 0; j < surface->h; j++)
			{
				
				clrs = (((int)r)<<11) + (((int)g)<<5) + (((int)b));
				
				
				((Uint16*)surface->pixels)
						[i + j * surface->pitch/2] = clrs;
			}
		}
		//draw
		//SDL_Delay(500);
		sdl->video.blit(surface, 0, 0);
		sdl->event.check();
	}
}
