/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../demo/demo.h"
#include <iostream>
#include <cmath>
#ifdef unix
#include "SDL_image.h"
#endif
#ifdef WIN32
#include "SDL/SDL_image.h"
#endif

using namespace std;

c_particles::c_particles(int partnum, c_sdl *sdl)
{
	num_of_parts = partnum;
	
	/* Load particle image */
	src_particle = IMG_Load("../data/particle.png");
	particle = get_surface(sdl, src_particle->w, src_particle->h);
	sdl->video.blitc(src_particle, particle, 0, 0);
	
	/* Create storage for particle data */
	parts = new c_part[num_of_parts];
	
#if 1
	
	x_emit = (sdl->video.get_w()/2) - 20;
	y_emit = (sdl->video.get_h()/2) - 20;
	
	/* Reset all particles */
    for(int i = 0; i < num_of_parts; i++)
	{
		parts[i].life = rand()/RAND_MAX; 
		parts[i].x = (int)(x_emit + (40.0 *(((float)rand()/RAND_MAX) - 0.5)));
		parts[i].y = (int)(y_emit + (40.0 *(((float)rand()/RAND_MAX) - 0.5)));
			float delta = ((float)rand()/RAND_MAX)*2*3.1415;
		parts[i].xdir = (20.0 * sin(delta));
		parts[i].ydir = (20.0 * cos(delta));
		parts[i].r = 50;
		parts[i].g = 50;
		parts[i].b = 255;
	}
	
	t = 0;
#endif
	
}
c_particles::~c_particles()
{
	delete [] parts;
}

void c_particles::draw2(c_sdl *sdl,SDL_Surface *dest,float life,float life_decay,
						float x_speed,float y_speed,float x_scale,float y_scale,
						float rotation_speed, float rotation_distance, int x_center,
						int y_center,float x_framespeed,float y_framespeed,
						float x_radius,float y_radius,float x_gravity,float y_gravity,
						float color_r,float color_g,float color_b)
{
	Uint16 colors, colors2;
	SDL_Surface *surface = dest;
	
	t+=rotation_speed;
	
	x_emit = (int)((x_center) - 20 + (sin(t)*rotation_distance*x_scale));
	y_emit = (int)((y_center) - 20 + (cos(t)*rotation_distance*y_scale));
	
	for(int i = 0; i < num_of_parts; i++)
	{
		parts[i].y += (int)(parts[i].ydir * x_framespeed);
		parts[i].x += (int)(parts[i].xdir * y_framespeed);
		parts[i].life -= life_decay;

		if(parts[i].y >= sdl->video.get_h() - 3
			|| parts[i].x <= -16
			|| parts[i].y <= -16
		 	|| parts[i].x >= sdl->video.get_w() - 3
			|| parts[i].life < 0)
		{
	  		parts[i].life = life * ((float)rand()/RAND_MAX);
			parts[i].x = (int)(x_emit + 
				(x_radius * (((float)rand()/RAND_MAX) - 0.5))); 
			parts[i].y = (int)(y_emit + (y_radius *
				(((float)rand()/RAND_MAX) - 0.5)));
			float delta = ((float)rand()/RAND_MAX)*2*OUR_PI;
			parts[i].xdir = (x_speed * sin(delta));
			parts[i].ydir = (y_speed * cos(delta));
	  		continue;
		}
		
		parts[i].ydir+=x_gravity;
		parts[i].xdir+=y_gravity;
		
		for(int q = 0; q < particle->w; q++)
		{

			for(int j = 0; j < particle->h; j++)
			{
				colors = ((Uint16*)particle->pixels)
					[q + (j * particle->pitch/2)];
			
				if( (parts[i].y + j) < surface->h && (parts[i].y + j) > 0 &&
					(parts[i].x + q) < surface->w && (parts[i].x + q) > 0)
				{
					colors2 = ((Uint16*)surface->pixels)
						[(parts[i].x + q) + ((parts[i].y + j) *
						surface->pitch/2)];
						
					Uint32 col = (colors - -colors2);
						
						/* COMMENT */
					
					int b = (colors2&31) + ((float)(colors&31) / 31.0) * color_r;
					int g = ((colors2&(32+64+128+256+512+1024))>>5) + ((float)(colors&31) / 31.0 * 2) * color_g;
					int r = (colors2>>11) + ((float)(colors&31) / 31.0) * color_b;
					b=b>31?31:b;
					g=g>63?63:g;
					r=r>31?31:r;
//					r=0;
//					g=0;
//					b=0;
					
					col = b + (g<<5) + (r<<11);
						
/*					if(col>0xFFFF) col = 0xFFFF;
					else if((col&2016)>>5 < (unsigned)(((colors&2016)>>6) +
						((colors2&2016)>>6))) col = 0xFFFF;*/
					
					((Uint16*)surface->pixels)
						[(parts[i].x + q) + ((parts[i].y + j) *
						surface->pitch/2)] = col;
				}
			}
		}
	}
}

void c_particles::draw(c_sdl *sdl)
{

	Uint16 colors, colors2;
	SDL_Surface *surface = get_surface(sdl, 320, 240);

#if 1	
	for(;;)
	{
		t+=0.05f;
		
		x_emit = (int)((sdl->video.get_w()/2) - 20 + (sin(t)*70));
		y_emit = (int)((sdl->video.get_h()/2) - 20 + (cos(t)*70));
		
		clear_surface(surface);
		//clear_all(sdl);
		
		for(int i = 0; i < num_of_parts; i++)
		{
			sdl->event.check();
			/* Move particle in it's current direction */
			parts[i].y += (int)(parts[i].ydir * 0.3f);
			parts[i].x += (int)(parts[i].xdir * 0.3f);
			
			/* Check if particle has left the screen, if so
			 * remove it */
			parts[i].life -= 0.1f;
			if(parts[i].y >= sdl->video.get_h() - 3
				|| parts[i].x <= -16
				|| parts[i].y <= -16
			 	|| parts[i].x >= sdl->video.get_w() - 3
				|| parts[i].life < 0)
			{
		  		parts[i].life = 1.0 * ((float)rand()/RAND_MAX);
				parts[i].x = (int)(x_emit + (40.0 *
					(((float)rand()/RAND_MAX) - 0.5))); 
				parts[i].y = (int)(y_emit + (40.0 *
					(((float)rand()/RAND_MAX) - 0.5)));
				float delta = ((float)rand()/RAND_MAX)*2*OUR_PI;
				parts[i].xdir = (0.37 * sin(delta));
				parts[i].ydir = (0.37 * cos(delta));
		  		continue;
			}
			
			/* Add some gravity */
//			parts[i].ydir+=0.6f;
//cout << "i:" << i << endl;
						
			for(int q = 0; q < particle->w; q++)
			{

				for(int j = 0; j < particle->h; j++)
				{
					colors = ((Uint16*)particle->pixels)
						[q + (j * particle->pitch/2)];
					
					if( (parts[i].y + j) < surface->h && (parts[i].y + j) > 0 &&
						(parts[i].x + q) < surface->w && (parts[i].x + q) > 0)
					{
						colors2 = ((Uint16*)surface->pixels)
							[(parts[i].x + q) + ((parts[i].y + j) *
							surface->pitch/2)];
						
						Uint32 col = (colors - -colors2);
						
						/* COMMENT */
						
						if(col>0xFFFF) col = 0xFFFF;
						else if((col&2016)>>6 < (unsigned)
							(((colors&2016)>>6) + ((colors2&2016)>>6)))
						col = 0xFFFF;
					
						((Uint16*)surface->pixels)
							[(parts[i].x + q) + ((parts[i].y + j) *
							surface->pitch/2)] = col;
					}
				}
			}
			
			
			/* Make a 5, 6, 5 (RGB) (16bit) colorkey... */
	/*		colors = (((int)parts[i].r)<<11) +
				(((int)parts[i].g)<<6) +
				(((int)parts[i].r));*/
			
			//cout << parts[i].x << endl << parts[i].y << endl;
			
	
			
			
			/* Set the color at the requested pixel */

		/*	((Uint16*)sdl->video.screen->pixels)
				[parts[i].x + (parts[i].y * sdl->video.screen->pitch/2)]
				= colors;*/
			//SDL_Delay(10);
			
		}
		sdl->video.blitc(surface, sdl->video.screen, 0, 0);
		SDL_Flip(sdl->video.screen);
		
	
	}
#endif
}
