/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../demo/demo.h"
#include <iostream>
#include <stdio.h>

using namespace std;

void c_stars::init(int numstars)
{
	num_of_stars = numstars;
	stars = new c_star[num_of_stars];
}

void c_stars::sinit(c_star *star, int i)
{
	/* Randomly init stars, generate them around the center of the screen */
	star->x =  -10.0f + (20.0f * (rand()/(RAND_MAX+1.0f)));
	star->y =  -10.0f + (20.0f * (rand()/(RAND_MAX+1.0f)));
  
	/* Change viewpoint */
	star->x *= 3072.0; 
	star->y *= 3072.0;

	star->z = i;
	star->spd = 2 + (int)(2.0 * (rand()/(RAND_MAX+1.0)));

	/* The closer to the viewer the brighter */
	star->color = i >> 2; 
}

void c_stars::draw(c_sdl *sdl)
{
	int tx=1, ty=1;
	SDL_Surface *surface = get_surface(sdl, sdl->video.screen->w,
		sdl->video.screen->h);
	float c = 1.0f;
	int fr = 0;
	
	while(fr < 1000)
	{	
	
		fr++;
			r = (int)(31) * c;
			g = (int)(63) * c;
			b = (int)(31) * c;
		
			color = (((int)r)<<11) + (((int)g)<<5) + (((int)b));
		
		clear_surface(surface);	
		
		if(fr >= 0 && fr <= 400)
			sdl->text.draw("Pixels flying over the screen", surface, 30, 150/2-8, sdl);
		if(fr >= 400 && fr <= 800)
			sdl->text.draw("Why these stars, we want nice gfx!", surface, 30, 150/2-8, sdl);
		if(fr >= 800 && fr <= 1000)
			sdl->text.draw("That's more like it...", surface, 30, 150/2-8, sdl);

		
		for(int i = 0; i < num_of_stars; i++)
		{			
			if(fr >700) {
				if(i >= 0 && i <= 50) {
					c -= 0.01;
					stars[i].spd -= 30;
				} else c += 0.01;
			}
			stars[i].z -= stars[i].spd;
	  
			if(stars[i].z <= 0) sinit(stars + i, i + 1);
		
			tx = (stars[i].x / stars[i].z) + surface->w/2;
			ty = (stars[i].y / stars[i].z) + surface->h/2;

			/* Check if a star leaves the screen */
			if(tx < 0 || tx > surface->w - 1
				|| ty < 0 || ty > surface->h - 1) 
			{
				sinit(stars + i, i + 1);
				continue;
			}
			
			((Uint16*)surface->pixels)
						[tx + (ty *
						surface->pitch/2)] = color;
			//draw here		
			sdl->event.check();
		}
		sdl->video.blit(surface, 0, 0);
	}
}


