/*  xa-001
 *  Copyright (C) xAngle 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../demo/demo.h"
#include <iostream>

using namespace std;

/* Waves */
c_waves::c_waves()
{
	z = new float[320*240];
	z1 = new float[320*240];

	clearWaves();
	setDefaultWavePoints();
}

void c_waves::setDefaultWavePoints()
{
	z[100*320 + 70] = 1.0f;
	z[5*320 + 19] = 1.0f;
	z[40*320 + 200] = 1.0f;
	z[80*320 + 250] = 1.0f;
	z[100*320 + 450] = 1.0f;
	z[120*320 + 20] = 1.0f;
	z[140*320 + 190] = 1.0f;
	z[200*320 + 100] = 1.0f;
	z[110*320 + 120] = 1.0f;
	z[90*320 + 30] = 1.0f;
}

void c_waves::setWaveSpawnPoint(int spawnX, int spawnY, float life)
{
	if(spawnX >= 1 && spawnX <= 318 &&
		spawnY >= 1 && spawnY <= 238)
	z[spawnY*320 + spawnX] = life;
	else 
	cout << "could not set the spawn point: "
		<< spawnX << "x" << spawnY << endl;
}

void c_waves::clearWaves()
{
	for(int i=0;i<320*240;i++)
	{
		z[i] = 0.0f;
		z1[i] = 0.0f;
	}
}

void c_waves::draw_waves(c_sdl *sdl,SDL_Surface *dest , unsigned int width, unsigned int height,
		unsigned int texture_height, unsigned int texture_width)
{
	// wave constants
	const float c = 1.9f;
	const float h = 0.2f;
	const float dampness = 0.999f; //0.98f;
	// Time difference
	const float	dt = 0.0333f;
	
	const float A = (c*dt/h)*(c*dt/h);
	const float B = 2-4*A;

	unsigned int y,x;


	// Lock gfx here later

	for(y=1; y<height-1; y++)
	{
		for(x=1; x<width-1; x++)
		{
			z1[y*width+x]=(A*(z[(y-1)*width+x]+z[(y+1)*width+x]+z[y*width+x-1]+z[y*width+x+1])
				+B*z[y*width+x]-z1[y*width+x])*dampness;

			draw_pixelc(dest, x, y, (Uint32)(z1[y*width+x]<0?0:z1[y*width+x]*64));
		}
	}

//	cout << "cp:" << cp << endl;
	std::swap(z, z1);
	cp++;
	// Release gfx here later
}



/* targhans orginal

class CWaves
{

public:

	CWaves()
	{
		z = new float[320*240];
		z1 = new float[320*240];

		for(int i=0;i<320*240;i++) {
			z[i] = 0.0f;
			z1[i] = 0.0f;
		}

		z[100*320 + 70] = 1.0f;
		z[5*320 + 19] = 1.0f;
		z[40*320 + 200] = 1.0f;
		z[80*320 + 250] = 1.0f;
		z[100*320 + 450] = 1.0f;
		z[120*320 + 20] = 1.0f;
		z[140*320 + 190] = 1.0f;
		z[200*320 + 100] = 1.0f;
		z[110*320 + 120] = 1.0f;
		z[90*320 + 30] = 1.0f;
	}

	~CWaves()
	{
		delete [] z;
		delete [] z1;
	}

	void DrawWaves(Uint16 *pixels, Uint16 *texture,unsigned int width,unsigned 
int height,unsigned int texture_height,unsigned int texture_width,HWND 
preview)
	{
		const float c = 0.9f;
		const float dt = 0.0333f;
		const float h = 0.2f;

		const float A = (c*dt/h)*(c*dt/h);
		const float B = 2-4*A;

		HDC dc = GetDC(preview);

		unsigned int i,j;

		for(i=1;i<height-1;i++) {
			for(j=1;j<width-1;j++) {
				z1[i*width+j]=A*(z[(i-1)*width+j]+z[(i+1)*width+j]+z[i*width+j-1]+z[i*width+j+1])
					+B*z[i*width+j]-z1[i*width+j];

				if(cp %10==0)
				{
					SetPixelV(dc,i,j,z1[i*width+j]*256);
					SetPixelV(dc,i+1,j,0xffffff);
				}

			}
		}
		std::swap(z,z1);
		cp++;
		ReleaseDC(preview,dc);
	}
private:
	float* z;
	float* z1;

};




*/
