#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <SDL/SDL.h>
#include "fmod/inc/fmod.h"
#include "bmp.h"
#define SCREEN_X 320
#define SCREEN_Y 240
#define PI 3.141592653589793
#define RADIAN(x) (x*(PI/180))
#define RAD1 RADIAN(1)

struct point3d {
    float x, y, z;
};

struct point2d {
    int x, y;
};

struct tcube {
    struct point3d coords3d[8];
    struct point2d coords2d[8];
    int color;
};

struct timersEx {
    int start;
    int current;
    int stop;
    int time;
} timers[128];
int timer_num;

short deinit(void);
short checkkey(void);
int gtimer_add();
int gtimer();
void scale(SDL_Surface * in, SDL_Surface * out, short x0, short y0,
	   short x1, short y1);
void updatescreen(SDL_Surface * bob);
void readdata(SDL_Surface * img, int x0, int y0, int x1, int y1);
Uint8 getp(SDL_Surface * surface, int x, int y);
void plot(SDL_Surface * surface, int x, int y, Uint32 pixel);
void transplot(SDL_Surface * surface, int x, int y, Uint32 pixel);
int loadbitmap();
char *bitmap_printerror(short error);
struct point2d project(struct point3d point);
void rotate(float alpha, float x, float y, float z);
void mul_matrix(float matrix1[4][4], float matrix2[4][4],
		float dest[4][4]);
void mul_vector(float vector[4][1], float matrix[4][4], float dest[4][1]);
void init_matrix(float matrix[4][4]);
void line(int x0, int y0, int x1, int y1, int color);
void translate(float tx, float ty, float tz);
void watersc(void);
void cubesc(void);
void endsc(void);


extern SDL_Surface *screen;
extern SDL_Surface *realscreen;
extern SDL_Surface *sinefont[64];
extern SDL_Color palette[256];
extern SDL_Color savedpalette[256];
extern FSOUND_STREAM *tuneptr;
extern bmp graphics;
extern float omatrix[4][4];
extern Uint32 prevTicks;
extern Uint16 latency;

short busy;
short transparent;

int millisecond;
