/* bitmap loading code by gammy. thanks fredd.
 *
 * Supports:
 * 8-bit non-compressed bitmaps
 * 8-bit RLE bitmaps
 *
 * To-doies:
 * - perhaps 16 and 24-bit bitmap support..or at least 24. 888 should be dead easy.
 * - dynamic memory goo */

#include "main.h"

#define BMSIGNATURE "BM"

char *bitmap_printerror(short error){
  memset(errortext, 0, 20);

  switch(error){
  case BMP_NOFILE:
    sprintf(errortext, "Could not open bitmap");
    break;
  case BMP_NOBITMAP:
    sprintf(errortext, "File is not a bitmap");
  case BMP_CORRUPTFILE:
    sprintf(errortext, "File is corrupted");
    break;
  case BMP_NOSUPPORTRLE:
    sprintf(errortext, "RLE type not supported");
    break;
  case BMP_NOSUPPORTBPP:
    sprintf(errortext, "Bitdepth not supported");
    break;
  case BMP_NOMEMORY:
    sprintf(errortext, "Not enough memory");
    break;
  }

  return errortext;

}

int fixvalue(int value){
  if(value < 0) value = 256 + value;
  return value;
}

int loadbitmap(bmp *bitmap, char *filename)
{
  FILE *fp;
  long i;
  long offset;
  long offset_norm;
  long offset_flip;
  char bmsign[2];
  char rle_data[2];
  char delta[2];
  short x, y;
  short pixel_norm;
  short pixel_flip;
  short value;
  short eol; /* end of line flag   */
  short eob; /* end of bitmap flag */

  fp = fopen(filename, "rb");
  if(!fp)
    return BMP_NOFILE;

  /* Initialize variables */
  
  i = 0;
  bitmap->width = 0;
  bitmap->height = 0;

  bmsign[0]   = 0;
  bmsign[1]   = 0;
  rle_data[0] = 0;
  rle_data[1] = 0;
  delta[0]    = 0;
  delta[1]    = 0;
  x           = 0;
  y           = 0;
  offset      = 0;
  offset_flip = 0;
  offset_norm = 0;
  pixel_norm  = 0;
  pixel_flip  = 0;
  eob         = 0;

  fread(bmsign, sizeof(BMSIGNATURE), 1, fp);

  if(strncmp(bmsign, BMSIGNATURE, 2) != 0)
    return BMP_NOBITMAP;

  fseek(fp, 18, SEEK_SET);                /* Offset of width in pixels  */
  fread(&bitmap->width, 2, 1, fp);
  fseek(fp, 22, SEEK_SET);                /* Offset of height in pixels */
  fread(&bitmap->height, 2, 1, fp);
  fseek(fp, 28, SEEK_SET);                /* Offset of bit depth        */
  fread(&bitmap->bpp, 2, 1, fp);          /* And data type after it..   */
  fread(&bitmap->compression, 4, 1, fp);
  fseek(fp, 46, SEEK_SET);                /* Offset of colors used      */
  fread(&bitmap->usedcolors, 2, 1, fp);
  fseek(fp, 54, SEEK_SET);                /* Offset of palette          */

  
  /* Temporary... */
  if(bitmap->bpp != 8){
    fclose(fp);
    return BMP_NOSUPPORTBPP;
  }

  /* Get the palette, 8bpp only of course */
  if(bitmap->usedcolors == 0) bitmap->usedcolors = 256;
  for(i = 0; i < bitmap->usedcolors; i++){
    bitmap->palette[i].r = bitmap->palette[i].g = bitmap->palette[i].b = 0;
    fread(&bitmap->palette[i].b, 1, 1, fp);
    fread(&bitmap->palette[i].g, 1, 1, fp);
    fread(&bitmap->palette[i].r, 1, 1, fp);
    fseek(fp, 1, SEEK_CUR); /* Skip a byte */
  }

  bitmap->imagesize = (bitmap->bpp / 8) * (bitmap->width * bitmap->height);

  bitmap->image = malloc(bitmap->imagesize); /* Allocate memory for image data */
  if(!bitmap->image){
    fclose(fp);
    return BMP_NOMEMORY;
  }
  memset(bitmap->image, 0, (bitmap->imagesize - 1));

  switch(bitmap->compression){
  case BMP_NORLE:
    /* Read the bitmap in to memory backwards */
    printf("Non-compressed bitmap...\n");
    for(i = ((bitmap->height - 1) * bitmap->width); i >= 0; i -= bitmap->width)
      fread(&bitmap->image[i], bitmap->width, 1, fp);
    break;

  case BMP_RLE_8BPP:
    printf("Compressed bitmap...\n");
    offset = 0;
    while(!eob){
      eol = 0;
      while(eol == 0 && eob == 0){
	fread(&rle_data[0], 1, 1, fp);
	fread(&rle_data[1], 1, 1, fp);
	value = fixvalue((int)rle_data[1]);

	/* Normal encoded data */
	if(fixvalue((int)rle_data[0]) > 0){
	  for(i = 0; i < fixvalue((int)rle_data[0]); i++){
	    bitmap->image[offset] = value;
	    offset++;
	  }
	}else{
	  switch(value){
	  case BMP_RLE_EOL: 
	    eol = 1;
	    break;
	  case BMP_RLE_EOB:
	    eob = 1;
	    break;
	  case BMP_RLE_DELTA:
	    /* Delta mode. Shift n right, n down */
	    fread(&delta[0], 1, 1, fp);
	    fread(&delta[1], 1, 1, fp);
	    x = fixvalue(delta[0]);
	    y = fixvalue(delta[1]);
	    offset += x * y;
	    break;
	  default:
	    /* Absolute mode */
	    for(i = 0; i < value; i++){
	      fread(&rle_data[1], 1, 1, fp);
	      bitmap->image[offset] = fixvalue((int)rle_data[1]); 
	      offset++;
	    }
	    /* Align position */
	    if(i % 2 == 1)
	      fseek(fp, 1, SEEK_CUR);
	    break;
	  }
	}
      }
    }

    /* Flip the buffer */
    
    for(y = 0; y < (bitmap->height / 2); y++){
      for(x = 0; x < bitmap->width; x++){
	offset_norm = x + (y * bitmap->width);
	offset_flip = x + (((bitmap->height - 1)- y) * bitmap->width);
	pixel_norm = bitmap->image[offset_norm];
	pixel_flip = bitmap->image[offset_flip];
	bitmap->image[offset_flip] = pixel_norm;
	bitmap->image[offset_norm] = pixel_flip;
      }
    }
   
    break; 

  default:
    return BMP_NOSUPPORTRLE;
    break;    
    
  }

  fclose(fp);

    printf("%s(%ldb allocated): %dx%dx%d, %d colors used.\n", filename, bitmap->imagesize, bitmap->width, bitmap->height, bitmap->bpp, bitmap->usedcolors);
      
      
  return 0;
}
