/* Demo initialization code.
 *
 * By the introx team.
 *
 */

#include "main.h"

#define GRAPHICS "data/img/data.bmp"
#define LE_MUSIC "data/snd/tune.ogg"

SDL_Surface *screen;
FSOUND_STREAM *tuneptr;
bmp graphics;

short init(void){
  
  int audio_samplerate;
  int returncode;
  int sndinit_tries;

  sndinit_tries = 1;
  returncode = 0;
  audio_samplerate = 44100;
  
  returncode = loadbitmap(&graphics, GRAPHICS);
  
  if(returncode != 0){
    printf("%s!\n", bitmap_printerror(returncode));
    return -1;
  }

  /* Initialize fmod */
  
  
  printf("init fmod..");
  while(!FSOUND_Init(audio_samplerate, 24, 0)){
    audio_samplerate = (44100 / ++sndinit_tries);
    printf("\nFailed! Trying a lower samplerate..");
    if(audio_samplerate <= 5512){
      printf("\nERROR: ");
       switch (FSOUND_GetError()) {
       case FMOD_ERR_INIT:
	 printf("Could not initialize output device.\n");
	 break;
       case FMOD_ERR_ALLOCATED:
	 printf("Output device already in use.\n");
	 break;
       case FMOD_ERR_OUTPUT_FORMAT:
	 printf("Output device not capable of 16-bit stereo output.\n");
	 break;    
       default:
	 printf("Unknown error.\n");
	 break;
       }
       return -1;
    }
  }    
  printf("%dhz.\n", audio_samplerate);

  
  printf("init tune..");
  tuneptr = FSOUND_Stream_Open(LE_MUSIC, FSOUND_LOOP_NORMAL, 0, 0);
  if(tuneptr == NULL){
    printf("Could not load tune!\n");
    return -1;
  }
  FSOUND_Stream_SetLoopCount(tuneptr, -1);  
  printf("Ok\n");
    
  /* Initialize graphics last */
  printf("init SDL ..");
  if(SDL_Init(SDL_INIT_VIDEO) < 0){
    printf("failed!\n");
    return -1;
  }
  SDL_ShowCursor(SDL_DISABLE); 
  atexit(SDL_Quit);
#ifdef FULLSCREEN
  realscreen = SDL_SetVideoMode(640,480,8,SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_HWPALETTE|SDL_HWACCEL|SDL_FULLSCREEN);
#else
  realscreen = SDL_SetVideoMode(640,480,8,SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_HWPALETTE|SDL_HWACCEL);
#endif
  if(!realscreen){
    printf("Could not set video mode!\n");
    return -1;
  }
  SDL_WM_SetCaption("Introx dhw2004 demo","POOPERS");
  printf("Ok.\n");
 
  return 0;

}

short deinit(void){
  
  FSOUND_Stream_Stop(tuneptr);
  FSOUND_Stream_Close(tuneptr);
  FSOUND_Close();

  free(graphics.image);
  exit(0);

  return 0;
}
