#include "main.h"
#include <math.h>

float omatrix[4][4];

void init_matrix( float matrix[4][4] ){
  /* load our identity matrix */
  matrix[0][0]=1.0f;
  matrix[0][1]=0.0f;
  matrix[0][2]=0.0f;
  matrix[0][3]=0.0f;

  matrix[1][0]=0.0f;
  matrix[1][1]=1.0f;
  matrix[1][2]=0.0f;
  matrix[1][3]=0.0f;

  matrix[2][0]=0.0f;
  matrix[2][1]=0.0f;
  matrix[2][2]=1.0f;
  matrix[2][3]=0.0f;

  matrix[3][0]=0.0f;
  matrix[3][1]=0.0f;
  matrix[3][2]=0.0f;
  matrix[3][3]=1.0f;

  return;
}


void mul_vector( float vector[4][1], float matrix[4][4], float dest[4][1] ){
  float num = 0;
  int i,j;

  for( i = 0; i < 4; i++){
    for( j = 0; j < 4; j++){
      num += vector[j][0] * matrix[j][i];
    }
    dest[i][0] = num;
    num = 0;
  }
  return;
}

void mul_matrix( float matrix1[4][4], float matrix2[4][4], float dest[4][4] ){
  int i,j,k;

  for( i = 0; i < 4; i++ ){
    for( j = 0; j < 4 ; j++ ){
      dest[i][j] = 0;
      for( k = 0; k < 4; k++ ){
        dest[i][j] += matrix1[i][k]*matrix2[k][j];
      }
    }
  }
  return;
}

void translate( float tx, float ty, float tz){

  float tmatrix[4][4] = {
      { 1,  0,  0,  0 },
      { 0,  1,  0,  0 },
      { 0,  0,  1,  0 },
      { tx, ty, tz, 1 }
  };
  float tmp[4][4];
  int j,k;

  mul_matrix( omatrix, tmatrix, tmp );

  for( j = 0; j < 4; j++ )
    for( k = 0; k < 4; k++ )
      omatrix[j][k] = tmp[j][k];

  return;
}
void rotate( float alpha, float x, float y, float z){

  float rzmatrix[4][4] = {                      /* Z-axis */
      { cos(z) , sin(z), 0, 0 },
      { -sin(z), cos(z), 0, 0 },
      { 0      , 0     , 1, 0 },
      { 0      , 0     , 0, 1 }
  };

  float rxmatrix[4][4] = {                      /* X-axis */
      { 1, 0      , 0     , 0 },
      { 0, cos(x) , sin(x), 0 },
      { 0, -sin(x), cos(x), 0 },
      { 0, 0      , 0     , 1 }
  };

  float matrix[4][4] = {
      { 1, 0, 0, 0 },
      { 0, 1, 0, 0 },
      { 0, 0, 1, 0 },
      { 0, 0, 0, 1 }
  };

  float rymatrix[4][4] = {                      /* Y-axis */
      { cos(y), 0, -sin(y), 0 },
      { 0     , 1, 0      , 0 },
      { sin(y), 0,  cos(y), 0 },
      { 0     , 0, 0      , 1 }
  };

  float tmp[4][4];
  int j,k;
  float matrix1[4][4], matrix2[4][4];

  mul_matrix( matrix, rymatrix, matrix1);
  mul_matrix( matrix1, rxmatrix, matrix2);
  mul_matrix( matrix2, rzmatrix, tmp );

  for( j = 0; j < 4; j++ )
    for( k = 0; k < 4; k++ )
      omatrix[j][k] = tmp[j][k];

  return;
}


struct point2d project( struct point3d point){
  struct point2d retval;
  float tpoint[4][1] = {
      { point.x },
      { point.y },
      { point.z },
      {    1    }
  };
  float tmpoint[4][1];
  mul_vector( tpoint, omatrix, tmpoint );

  retval.x = (256*tmpoint[0][0]/(tmpoint[2][0]) )+ (SCREEN_X/2);
  retval.y = (256*tmpoint[1][0]/(tmpoint[2][0]) )+ (SCREEN_Y/2);

  return retval;
}


void swap( int *a, int *b ){
  int tmpswap;

  tmpswap = *a;
  *a      = *b;
  *b      = tmpswap;
}

/* draw a line using the Bresenham algorithm *
 * needs major optimization */
void line(int x0, int y0, int x1, int y1, int color)
{
  int i;
  int steep = 1;
  int sx, sy;
  int dx, dy;
  int e;
  dx = abs(x1 - x0);
  sx = ((x1 - x0) > 0) ? 1 : -1;
  dy = abs(y1 - y0);
  sy = ((y1 - y0) > 0) ? 1 : -1;
  if (dy > dx) {
    steep = 0;
    swap( &x0, &y0);
    swap( &dx, &dy );
    swap( &sx, &sy );
  }
  e = (dy << 1) - dx;
  for (i = 0; i < dx; i++) {
    if (steep) {
      if( x0 > 0 && x0 < SCREEN_X && y0>0 && y0 < SCREEN_Y)
        plot(screen,x0,y0,color);
    } else {
      if( x0 > 0 && x0 < SCREEN_X && y0>0 && y0 < SCREEN_Y)
        plot(screen,y0,x0,color);
    }
    while (e >= 0) {
      y0 += sy;
      e -= (dx << 1);
    }
    x0 += sx;
    e += (dy << 1);
  }
}

