#include <stdio.h>
#include <stdlib.h>
#include "alloc_check.h"

static int malloc_calls, free_calls;
static size_t mem_alloc;

void *chk_malloc(size_t size) {
	malloc_calls++;
	mem_alloc += size;

	return malloc(size);
}

void *chk_realloc(void *ptr, size_t size) {
	if(!ptr) {
		malloc_calls++;
	}
	
	return realloc(ptr, size);
}

void chk_free(void *ptr) {
	if(ptr) {
		free_calls++;
		free(ptr);
	}
}

void get_alloc_stats(FILE *out) {
	fprintf(out, "Total allocated memory: %d\n", mem_alloc);
	fprintf(out, "Calls to chk_malloc(): %d\n", malloc_calls);
	fprintf(out, "Calls to chk_free(): %d\n", free_calls);
}
