/* #include <GL/glut.h> */
#include <GL/gl.h>
#include "main.h"
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <pthread.h>
#include "xlib.h"
#include <sys/time.h>

#define TEX(n) glBindTexture(GL_TEXTURE_2D, textures[n].texid)

void draw_distortion (int, float, int, int, int);
double t_play_music (void);

pid_t pid = 0;

float t_time, dude;
double timer;
int lol;

float
getTime()
{
  struct timeval t1;
  gettimeofday(&t1, NULL);
  return ((t1.tv_sec * 1000) + (t1.tv_usec / 1000) - starttime);
/*   return stream_pos(); */
}


void drawGLScene(void)
{
  t_time = getTime ();

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  if (t_time/1000 > 0 && t_time/1000 <= 8.5)
    {
      glEnable (GL_TEXTURE_2D);
      glLoadIdentity ();
      glTranslatef (0, 0, -60);

      glColor3f (t_time/5000, t_time/5000, t_time/5000);
      draw_distortion (64, dude, SINE, 4, 2);

      glEnable (GL_BLEND);
      glLoadIdentity ();

      glColor3f (1, 1, 1);
      TEX(0);
      glBegin (GL_QUADS);
      glTexCoord2f (0, 1); glVertex3f (-1,-1, 0);
      glTexCoord2f (0, 0); glVertex3f (-1, 1, 0);
      glTexCoord2f (1, 0); glVertex3f ( 1, 1, 0);
      glTexCoord2f (1, 1); glVertex3f ( 1,-1, 0);
      glEnd ();
      glDisable (GL_BLEND);
    }

  if (t_time/1000 > 8.5 && t_time/1000 <= 28)
    {
      glLoadIdentity ();
      glTranslatef (0, 0, -40);
      draw_distortion (64, dude, TING, 4, 1);

      glBlendFunc (GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR);
      glEnable (GL_BLEND);

      glLoadIdentity ();
      glTranslatef (45-(t_time/500), 0.4, -4);
      TEX(3);
      glBegin (GL_QUADS);
      glTexCoord2f (0, 1); glVertex3f (-10,-2, 0);
      glTexCoord2f (0, 0); glVertex3f (-10, 2, 0);
      glTexCoord2f (1, 0); glVertex3f ( 10, 2, 0);
      glTexCoord2f (1, 1); glVertex3f ( 10,-2, 0);
      glEnd ();
      
    }
  if (t_time/1000 > 28 && t_time/1000 <= 60)
    {
      glClearColor (sin(t_time/50), sin(t_time/50), sin(t_time/50), 1);

      glBlendFunc (GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR);
      glEnable (GL_BLEND);
      glLoadIdentity ();
      glTranslatef (0, 0, -71.3+sin(t_time/10)*0.1);

      if (t_time/1000 <= 32) 
	draw_distortion (64, (t_time/1000)+rand()%3, WEIRD, 4, 1);
      if (t_time/1000 > 32)
	{
	  /* 	draw_distortion (64, (t_time/1000), WEIRD, 4, 1); */
	  glTranslatef (0,0,68);
	  TEX(1);
	  glBegin (GL_QUADS);
	  glTexCoord2f (0, 1); glVertex3f (-1.6,-1, 0);
	  glTexCoord2f (0, 0); glVertex3f (-1.6, 1, 0);
	  glTexCoord2f (1, 0); glVertex3f ( 1.6, 1, 0);
	  glTexCoord2f (1, 1); glVertex3f ( 1.6,-1, 0);
	  glEnd ();
	  glBlendFunc (GL_ONE_MINUS_SRC_COLOR, GL_SRC_COLOR);
	  glEnable (GL_BLEND);
	  glLoadIdentity ();
	  glTranslatef (0,0,-70);
	  draw_distortion (64, dude, NOISE, 4, 2);
	}
    }

  if (t_time/1000 > 60)
    {
      glDisable (GL_BLEND);
      glEnable (GL_DEPTH_TEST);
      glLoadIdentity ();
      glTranslatef (0, 0, -2);

      TEX(4);
      glBegin (GL_QUADS);
      glTexCoord2f (0, 1); glVertex3f (-1,-1, 0);
      glTexCoord2f (0, 0); glVertex3f (-1, 1, 0);
      glTexCoord2f (1, 0); glVertex3f ( 1, 1, 0);
      glTexCoord2f (1, 1); glVertex3f ( 1,-1, 0);
      glEnd ();

      if (t_time/1000 > 64)
	{
	  glLoadIdentity ();
	  glTranslatef (0, 0, -1.9);
	  TEX(5);
	  glBegin (GL_QUADS);
	  glTexCoord2f (0, 1); glVertex3f (-0.5,-0.125, 0);
	  glTexCoord2f (0, 0); glVertex3f (-0.5, 0.125, 0);
	  glTexCoord2f (1, 0); glVertex3f ( 0.5, 0.125, 0);
	  glTexCoord2f (1, 1); glVertex3f ( 0.5,-0.125, 0);
	  glEnd ();

	}
    }

  dude += 0.01;
  lol++;
  glXSwapBuffers(GLWin.dpy, GLWin.win);
}

void
load_textures (void)
{
  make_texture ();

  load_tex ("pictures/lol.png", 0);
  load_tex ("pictures/back.png", 1);
  load_tex ("pictures/test.png", 2);
  load_tex ("pictures/scroll.png", 3);
  load_tex ("pictures/lolsex.png", 4);
  load_tex ("pictures/error.png", 5);
}

void
initGL(void)
{
  glBlendFunc (GL_ONE_MINUS_SRC_COLOR, GL_SRC_COLOR);
/*   glBlendFunc (GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR); */
  load_textures ();
  resizeGLScene(GLWin.width, GLWin.height);
}

void key(unsigned char key, int x, int y)
{
  if(key == 27) /* clean up shit and exit if esc is pressed */
    {
      kill (pid, SIGINT);
      exit(0);
    }
}

int main(int argc, char *argv[])
{
  pthread_t thread;
  struct timeval temp;

  createGLWindow("WE KICK", 640, 480, 1);
  if (pid = fork())
    {
      t_play_music ();
    }
  else
    {
      gettimeofday(&temp, NULL);
      starttime = (temp.tv_sec * 1000) + (temp.tv_usec / 1000);

      glMainLoop("WE KICK", 640, 480);
      killGLWindow();
    }
  kill (pid, SIGINT);

  return 0;
}
