#include <stdlib.h>
#include <linux/soundcard.h>
#include <fcntl.h>
#include "vorbis/codec.h"
#include "vorbis/vorbisfile.h"

int fd_dsp, current_sec = 0;
OggVorbis_File vf;
long ret = 1;
char buf[4096];
int bytes_written = 0;

int
t_ioctl (int arg, int val)
{
  return ioctl (fd_dsp, arg, &val);
}

void
t_init_player (char *filename)
{
  FILE *file;

  if ((file = fopen (filename, "rb")) == NULL)
    {
      fprintf (stderr, "Could not open file %s\n", filename);
      exit (1);
    }
  if ((ov_open (file, &vf, NULL, 0)) < 0)
    {
      fprintf (stderr, "Input file is not a valid ogg file\n");
      exit (1);
    }

  fd_dsp = open("/dev/dsp", O_WRONLY, 0);
  t_ioctl (SOUND_PCM_WRITE_RATE, 44100);
  t_ioctl (SOUND_PCM_WRITE_CHANNELS, 2);
  t_ioctl (SNDCTL_DSP_SETFMT, AFMT_S16_LE);
}

float
stream_pos (void)
{
  int l_delay;
  ioctl (fd_dsp, SNDCTL_DSP_GETODELAY, &l_delay);

  printf ("%d %d\n", bytes_written, l_delay);
  return (bytes_written - l_delay)*0.0001 / (44100*2*2);

}

t_play_music (void)
{
  FILE *file;

  if ((file = fopen ("yo.ogg", "rb")) == NULL)
    {
      fprintf (stderr, "Could not open file\n");
      exit (1);
    }
  if ((ov_open (file, &vf, NULL, 0)) < 0)
    {
      fprintf (stderr, "Input file is not a valid ogg file\n");
      exit (1);
    }

  fd_dsp = open("/dev/dsp", O_WRONLY, 0);
  t_ioctl (SOUND_PCM_WRITE_RATE, 44100);
  t_ioctl (SOUND_PCM_WRITE_CHANNELS, 2);
  t_ioctl (SNDCTL_DSP_SETFMT, AFMT_S16_LE);

  while (ret)
    {
      if ((ret = ov_read (&vf, buf, sizeof(buf), 0, 2, 1, &current_sec)) == 0)
	{
	  ov_clear (&vf);
	  exit (0);
	}
      if (write(fd_dsp, buf, ret) == -1)
	exit (1);
      bytes_written += ret;
    }
}
