#include "general.h"
#include "defines.h"
#include "texture.h"
#include "CTileFile.h"
#include "CText.h"
#include "hud_base.h"
#include "CHudTetris.h"
#include <gl/glut.h>

CHudTetris::CHudTetris():text(16,20)
{
}

void CHudTetris::activateTga()
{
	this->tgaFile.activate();
}

void CHudTetris::processData(void *data)
{
	static float fa=0;
static 	GLfloat mat_trans[]={1.0,1.0,1.0,0.4};
	SHudTetrisData *tetrisData;
	tetrisData=(SHudTetrisData*)data;
	text.printNumber(tetrisData->score,50,118);
	glEnable(GL_CULL_FACE);
	glDisable(GL_BLEND);
	glDepthMask(GL_TRUE);
	PerspectiveMode();
	switch(tetrisData->nextLick)
	{
	case 0:
	
	glLoadIdentity();
	
	glDisable(GL_TEXTURE_2D);
	glTranslatef(-(6*0.1)+0.15,2.0-0.05,-5.0);
	
	glColor3f(1.0,1.0,1.0);
	texture.activate();
	glEnable(GL_BLEND);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
//glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);

glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);



	glPushMatrix();
	glTranslatef(13*0.2,5*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(13*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,6*0.2*-1,0.0); 
    glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,7*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();
	break;

	case 1:
		
	glLoadIdentity();
	
	glDisable(GL_TEXTURE_2D);
	glTranslatef(-(6*0.1)+0.15,2.0-0.05-0.05,-5.0);
	
	glColor3f(1.0,1.0,1.0);
	texture.activate();
	glEnable(GL_BLEND);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
//glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);

glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);



	glPushMatrix();
	glTranslatef(12*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(13*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,6*0.2*-1,0.0); 
    glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(15*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();
	break;

		case 2:
		
	glLoadIdentity();
	
	glDisable(GL_TEXTURE_2D);
	glTranslatef(-(6*0.1)+0.15,2.0-0.05+0.05,-5.0);
	
	glColor3f(1.0,1.0,1.0);
	texture.activate();
	glEnable(GL_BLEND);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
//glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);

glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);



	glPushMatrix();
	glTranslatef(13*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(13*0.2,7*0.2*-1,0.0); 
    glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,7*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();
	break;

		case 3:
		
	glLoadIdentity();
	
	glDisable(GL_TEXTURE_2D);
	glTranslatef(-(6*0.1)+0.15,2.0-0.05-0.05,-5.0);
	
	glColor3f(1.0,1.0,1.0);
	texture.activate();
	glEnable(GL_BLEND);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
//glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);

glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);



	glPushMatrix();
	glTranslatef(14*0.2,5*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(13*0.2,6*0.2*-1,0.0); 
    glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(13*0.2,7*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();
	break;

	case 4:
		
	glLoadIdentity();
	
	glDisable(GL_TEXTURE_2D);
	glTranslatef(-(6*0.1)+0.05,2.0-0.05-0.2,-5.0);
	
	glColor3f(1.0,1.0,1.0);
	texture.activate();
	glEnable(GL_BLEND);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
//glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);

glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);



	glPushMatrix();
	glTranslatef(14*0.2,5*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(13*0.2,6*0.2*-1,0.0); 
    glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(15*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();
	break;

	case 6:
		
	glLoadIdentity();
	
	glDisable(GL_TEXTURE_2D);
	glTranslatef(-(6*0.1)+0.25,2.0-0.05-0.15,-5.0);
	
	glColor3f(1.0,1.0,1.0);
	texture.activate();
	glEnable(GL_BLEND);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
//glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);

glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);



	glPushMatrix();
	glTranslatef(12*0.2,5*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(12*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(13*0.2,6*0.2*-1,0.0); 
    glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();
	break;

		case 5:
		
	glLoadIdentity();
	
	glDisable(GL_TEXTURE_2D);
	glTranslatef(-(6*0.1)+0.25,2.0-0.05-0.15,-5.0);
	
	glColor3f(1.0,1.0,1.0);
	texture.activate();
	glEnable(GL_BLEND);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);
	glDisable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
//glDepthMask(GL_FALSE);
glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_trans);

glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);



	glPushMatrix();
	glTranslatef(14*0.2,5*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(12*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(13*0.2,6*0.2*-1,0.0); 
    glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();

	glPushMatrix();
	glTranslatef(14*0.2,6*0.2*-1,0.0); 
	glRotatef(fa,0,1,0);
	glutSolidCube(0.2);
	glPopMatrix();
	break;

	}
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);

	fa+=0.3;
}

void CHudTetris::setTga(char *tgaFile)
{
	this->tgaFile.setFormat(TGA);
	this->tgaFile.initTexture(tgaFile);
}

void CHudTetris::init()
{
	text.init();
}

	
	