!!ARBfp1.0  
PARAM lightpos0     = state.light[0].position;  
PARAM lightdiff0    = state.lightprod[0].diffuse ;
PARAM lightspec0    = state.light[0].specular ;
PARAM lighthalf0    = state.light[0].half ;
PARAM lightdir0     = state.light[0].spot.direction ;
PARAM lightparam0   = program.local[0] ; 
PARAM matemission   = state.material.emission ;
PARAM matshininess  = state.material.shininess ;
PARAM c				= {1,0,2,3} ;
ATTRIB pixelpos		= fragment.texcoord[4] ;
ATTRIB pixelnorm	= fragment.texcoord[5] ;
ATTRIB lightglobal  = fragment.texcoord[6] ;
TEMP   temp,temp1,L,V,norm,spot,spec ;	
TEMP   diffuse_color0,specular_color0 ;
#Vector orientet to light direction
SUB		temp,lightpos0,pixelpos ;
DP3     L.w,temp,temp ;
RSQ		L.w,L.w ;
MUL     L.xyz,L.w,temp ;
#Vector orientet to position
SUB		temp,pixelpos,lightpos0 ;
DP3     V.w,temp,temp ;
RSQ		V.w,V.w ;
MUL     V.xyz,V.w,temp ;
#Normalize normal-vector
DP3     norm.w,pixelnorm,pixelnorm ;
RSQ		norm.w,norm.w ;
MUL     norm.xyz,norm.w,pixelnorm ;
#Caclulate spotlight
DP3		temp,V,lightdir0;
MOV		temp1.x, temp.x;
MOV		temp1.y, lightparam0.y;
ADD		temp1.y, -lightparam0.x, temp1;
ADD		temp1.x, -lightparam0.x, temp1;
RCP		temp1.y, temp1.y;
MUL		temp1.x, temp1, temp1.y;
MIN		temp1.x, temp1, c.x ;
MAX		temp1.x, temp1, c.y;
MAD		temp1.y, -temp1.x, c.z, c.w;
MUL		temp1.x, temp1, temp1;
MUL		spot, temp1.x, temp1.y;
MUL		spot,spot,lightglobal.w ;
#Diffuse light element
DP3		temp,norm,L ;
MAX		temp,temp,0 ;					
MUL		temp,temp,spot ;	   
MUL     diffuse_color0,temp,lightdiff0 ;
#Specular light element
DP3		temp,norm,lighthalf0 ;
MAX		temp1,temp,0 ;
POW		temp,temp1.x,matshininess.x ;
TEX		spec,fragment.texcoord[3],texture[3],2D;
MUL		temp1,temp,spec.xxxx ;
MUL		temp1,lightspec0,temp1 ;
SGE		temp,diffuse_color0,0 ;
MAD		specular_color0,temp,temp1,diffuse_color0; 
MUL		specular_color0,spot,specular_color0; 
#All together
ADD		temp,lightglobal,specular_color0 ;
TEX		temp1,fragment.texcoord[0],texture[0],2D;
TEX		norm, fragment.texcoord[1],texture[1],2D;
LRP		norm,program.local[1],temp1,norm ;
MUL		norm,norm,spot;
MAD_SAT	result.color,temp,norm,matemission ;
MOV		result.color.w,spec.z;
END  
