/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Vector3D;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;

public class LapsuusScene
extends Effect {
    private static final int rotationIncrement = 10;
    Texture terrainTex;
    Figure terrain;
    Texture[] textures = new Texture[6];
    Figure skyBox;
    Texture envObjTex;
    Figure envObj;
    private static int currentFrame = 0;
    private Vector3D ROBOT_POSITION = new Vector3D(0, 100, 700);
    private Vector3D ROBOT_LOOK = new Vector3D(0, 0, -4096);
    private Vector3D ROBOT_UP = new Vector3D(0, 4096, 0);
    private int ROBOT_PERSPECTIVE = 512;
    ObjectTransformation terrainTrans;
    ObjectTransformation envObjTrans;
    int rotationX = 3800;
    int rotationY = 3650;
    FigureLayout robotLayout;
    Effect3D effect;
    Effect3D envEff;
    FigureLayout envLayout;
    private Command changeCommand;
    private Command exitCommand;
    private Graphics3D cachedGraphics3D;

    public LapsuusScene(DemoCanvas canvas) {
        super(canvas);
    }

    public void init(int[] timePoints) {
        super.init(timePoints);
        try {
            this.terrainTex = this.demo.loadTexture("/map_fixed.bmp", true);
            this.textures[0] = this.demo.loadTexture("/naamiotaus1_256_8bpp.bmp", true);
            this.textures[1] = this.demo.loadTexture("/naamiotaus1_256_8bpp.bmp", true);
            this.textures[2] = this.demo.loadTexture("/naamiotaus1_256_8bpp.bmp", true);
            this.textures[3] = this.demo.loadTexture("/naamiotaus1_256_8bpp.bmp", true);
            this.textures[4] = this.demo.loadTexture("/naamiotaus1_256_8bpp.bmp", true);
            this.textures[5] = this.demo.loadTexture("/naamiotaus1_256_8bpp.bmp", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.terrain = this.demo.loadFigure("/mumi2.mbac");
            this.skyBox = this.demo.loadFigure("/terrain_sky.mbac");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain.setTexture(this.terrainTex);
        this.skyBox.setTexture(this.textures);
        this.effect = new Effect3D();
        this.effect.setShadingType(0);
        this.envEff = new Effect3D();
        this.envEff.setShadingType(0);
        this.envEff.setSphereTexture(this.envObjTex);
        this.terrainTrans = new ObjectTransformation();
        this.envObjTrans = new ObjectTransformation();
        this.robotLayout = new FigureLayout();
        this.robotLayout.setPerspective(1, 4096, this.ROBOT_PERSPECTIVE);
        this.robotLayout.setCenter(this.width / 2, this.height / 2);
        this.envLayout = new FigureLayout();
        this.envLayout.setPerspective(1, 4096, this.ROBOT_PERSPECTIVE);
        this.envLayout.setCenter(this.width / 2, this.height / 2);
    }

    public void doLogic(int msPassed) {
        this.rotationY += msPassed / 20;
        this.rotationX += Math.max(msPassed / 50, 1);
        if (this.rotationY > 4096) {
            this.rotationY -= 4096;
        }
        this.terrainTrans.identity();
        this.terrainTrans.setLookAt(this.ROBOT_POSITION, this.ROBOT_LOOK, this.ROBOT_UP);
        this.terrainTrans.setRotation(this.rotationX, this.rotationY, 0);
        this.robotLayout.setAffineTrans(this.terrainTrans.calculateTransformation());
        this.envObjTrans.identity();
        this.envObjTrans.setLookAt(this.ROBOT_POSITION, this.ROBOT_LOOK, this.ROBOT_UP);
        this.envObjTrans.setTranslation(0, 0, -1400);
        this.envObjTrans.setRotation(-this.rotationX, this.rotationX, this.rotationY);
        this.envLayout.setAffineTrans(this.envObjTrans.calculateTransformation());
    }

    public void draw(Graphics g) {
        Graphics3D g3d = this.demo.getGraphics3D();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.width, this.height);
        try {
            g3d.bind(g);
            g3d.renderFigure(this.skyBox, 0, 0, this.robotLayout, this.effect);
            g3d.flush();
            this.terrainTrans.identity();
            this.terrainTrans.setLookAt(this.ROBOT_POSITION, this.ROBOT_LOOK, this.ROBOT_UP);
            this.terrainTrans.setTranslation(0, -1200, -1800);
            this.terrainTrans.setRotation(this.rotationX, this.rotationY, 0);
            this.robotLayout.setAffineTrans(this.terrainTrans.calculateTransformation());
            g3d.renderFigure(this.terrain, 0, 0, this.robotLayout, this.effect);
            g3d.flush();
            g3d.release(g);
        }
        catch (Throwable h) {
            h.printStackTrace();
        }
    }

    synchronized void processKeyState() {
        int keyStates = this.demo.getKeyStates();
        if ((keyStates & 2) != 0) {
            this.rotationX += 10;
            if (this.rotationX > 4096) {
                this.rotationX = 0;
            }
        }
        if ((keyStates & 0x40) != 0) {
            this.rotationX -= 10;
            if (this.rotationX < 0) {
                this.rotationX = 4096;
            }
        }
        if ((keyStates & 4) != 0) {
            this.rotationY += 10;
            if (this.rotationY > 4096) {
                this.rotationY = 0;
            }
        }
        if ((keyStates & 0x20) != 0) {
            this.rotationY -= 10;
            if (this.rotationY < 0) {
                this.rotationY = 4096;
            }
        }
        if ((keyStates & 0x100) != 0) {
            this.rotationX = 100;
            this.rotationY = 0;
        }
    }
}

