-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- NonConForm (c)kRadD  
-- -------------------
--    kradd@tscc.de
-- -------------------
-- lua library file
-- -------------------
-- Description: lua base variables and functions
-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++

-- ********************************************************
--- Internal variables
-- the variables are global in the whole framework. 
-- The idear of the framework is, to not change them. 
-- Do not hesitate to read them
-- @nonMasterPad:					jagpad packet of the pad that will be tested for events
-- @nonMasterPadKeys:			jagpad keys packet of the pad that will be tested for events
-- @nonExitEvent:					(NON_NOTHING) nothing, (NON_NEXTEVENT) next screen, (NON_INITEVENT) initstage, (NON_MENUEVENT) menustage
-- @nonPaintList1: 				list of objects that need to be painted on screen1 during next vbl
-- @nonPaintList2: 				list of objects that need to be painted on screen2 during next vbl
-- @nonAvailablePlayers: 	number of players in the beeHead database
-- @nonPlayerPics: 				pictures of the selected players
-- @nonBeeHeadPlayers: 		the playerdata from the beeHead database
-- @nonPlayerShapes: 			shapes of the selected players
-- @nonPlayers: 					the playerdata of the selected players
-- @nonGameover:					set to true in the game, if a round is over
-- @nonKeyBoard:					the global KeyBoard object
-- @nonTeamTaps:					the global TeamTaps object
-- @nonJagPads:						the global JagPads object
-- @nonControllers:				the global controllers object which maps either to nonTeamTaps or nonJagPads
-- @nonRoundCounter:			the actual round
-- @nonBeeHeadPath:				path to the beehead folder
-- @nonSprites						list of sprites to draw

nonInternals={
	nonMasterPad=0;
	nonMasterPadKeys=0;
	nonExitEvent=NON_NOTHING;
	nonPaintList1={};
	nonPaintList2={};
	nonAvailablePlayers=0,
	nonPlayerPics={},
	nonBeeHeadPlayers={},
	nonPlayerShapes={},
	nonPlayers={},
	nonGameover=false,
	nonKeyBoard=nil,
	nonTeamTaps=nil,
	nonJagPads=nil,
	nonControllers=nil,
	nonRoundCounter=0,
	nonBeeHeadPath=nil;
	nonSprites={};
	-- internal		
	nonSprites_bg1={};
	nonSprites_bg2={};
	nonDevNull=nil,
	nonNextStageType=nil,
	nonNextStage=nil,
	nonLastStage=nil,
	nonPostInitStage=nul,
	nonEventStages={
		_default_={
			init=function() return nonInternals.nonPostInitStage(); end,
			menu=function() return ncf_Stage_GameInit,NON_STAGE; end,
		}
	}
}

-- ********************************************************
--- Global variables
-- Global variables in the whole framework. These variables 
-- will be changes by one or more controllers
-- @nonNumberOfPlayers:					number of players
-- @nonNumberOfRounds:					number of rounds
-- @nonTournamentScores:				roundresult,lastplace,points,actuallplace,tournamentresults (a table),playernumber,beeHeadPlayer},
-- @nonGameResults: 						the results of a game: points the player earned (points), place he scores (result)

nonGlobals={
	nonNumberOfHighscoredictionaryentries=0,
	nonNumberOfPlayers=1,
	nonNumberOfRounds=1,
	nonDifficulty=1,
	nonHighscoreFileNameParts={},
	nonTournamentScores={
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=1,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=2,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=3,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=4,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=5,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=6,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=7,beeHeadPlayer=-1},
		{roundpoints=0,roundresult=0,lastplace=0,points=0,actuallplace=0,tournamentresults={0,0,0,0,0,0,0,0},playernumber=8,beeHeadPlayer=-1}
	},
	nonSingleScores={
		{id=17,score=100,newscore=false},
		{id=17,score=99,newscore=false},
		{id=17,score=98,newscore=false},
		{id=17,score=97,newscore=false},
		{id=17,score=96,newscore=false},
		{id=17,score=95,newscore=false},
		{id=17,score=94,newscore=false},
		{id=17,score=93,newscore=false},
		{id=17,score=92,newscore=false},
		{id=17,score=91,newscore=false},
		{id=17,score=90,newscore=false},
		{id=17,score=89,newscore=false},
		{id=17,score=88,newscore=false},
		{id=17,score=87,newscore=false},
		{id=17,score=86,newscore=false},
		{id=17,score=85,newscore=false},
		{id=17,score=84,newscore=false},
		{id=17,score=83,newscore=false},
		{id=17,score=82,newscore=false},
		{id=17,score=81,newscore=false},
		{id=17,score=80,newscore=false},
		{id=17,score=79,newscore=false},
		{id=17,score=78,newscore=false},
		{id=17,score=77,newscore=false},
		{id=17,score=76,newscore=false},
		{id=17,score=75,newscore=false},
		{id=17,score=74,newscore=false},
		{id=17,score=73,newscore=false},
		{id=17,score=72,newscore=false},
		{id=17,score=71,newscore=false},
		{id=17,score=70,newscore=false},
		{id=17,score=69,newscore=false},
		{id=17,score=68,newscore=false},
		{id=17,score=67,newscore=false},
		{id=17,score=66,newscore=false},
		{id=17,score=65,newscore=false},
		{id=17,score=64,newscore=false},
		{id=17,score=63,newscore=false},
		{id=17,score=62,newscore=false},
		{id=17,score=61,newscore=false},
		{id=17,score=60,newscore=false},
		{id=17,score=59,newscore=false},
		{id=17,score=58,newscore=false},
		{id=17,score=57,newscore=false},
		{id=17,score=56,newscore=false},
		{id=17,score=55,newscore=false},
		{id=17,score=54,newscore=false},
		{id=17,score=53,newscore=false},
		{id=17,score=52,newscore=false},
		{id=17,score=51,newscore=false},
		{id=17,score=50,newscore=false},
		{id=17,score=49,newscore=false},
		{id=17,score=48,newscore=false},
		{id=17,score=47,newscore=false},
		{id=17,score=46,newscore=false},
		{id=17,score=45,newscore=false},
		{id=17,score=44,newscore=false},
		{id=17,score=43,newscore=false},
		{id=17,score=42,newscore=false},
		{id=17,score=41,newscore=false},
		{id=17,score=40,newscore=false},
		{id=17,score=39,newscore=false},
		{id=17,score=38,newscore=false},
		{id=17,score=37,newscore=false},
		{id=17,score=36,newscore=false},
		{id=17,score=35,newscore=false},
		{id=17,score=34,newscore=false},
		{id=17,score=33,newscore=false},
		{id=17,score=32,newscore=false},
		{id=17,score=31,newscore=false},
		{id=17,score=30,newscore=false},
		{id=17,score=29,newscore=false},
		{id=17,score=28,newscore=false},
		{id=17,score=27,newscore=false},
		{id=17,score=26,newscore=false},
		{id=17,score=25,newscore=false},
		{id=17,score=24,newscore=false},
		{id=17,score=23,newscore=false},
		{id=17,score=22,newscore=false},
		{id=17,score=21,newscore=false},
		{id=17,score=20,newscore=false},
		{id=17,score=19,newscore=false},
		{id=17,score=18,newscore=false},
		{id=17,score=17,newscore=false},
		{id=17,score=16,newscore=false},
		{id=17,score=15,newscore=false},
		{id=17,score=14,newscore=false},
		{id=17,score=13,newscore=false},
		{id=17,score=12,newscore=false},
		{id=17,score=11,newscore=false},	
		{id=17,score=10,newscore=false},
		{id=17,score=9,newscore=false},
		{id=17,score=8,newscore=false},
		{id=17,score=7,newscore=false},
		{id=17,score=6,newscore=false},
		{id=17,score=5,newscore=false},
		{id=17,score=4,newscore=false},
		{id=17,score=3,newscore=false},
		{id=17,score=2,newscore=false},
		{id=17,score=1,newscore=false},
	};
	nonGameResults={
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
		{points=0,result=0},
	},
	-- internal
	nonNumberOfHighscoredictionaryentries=0;
	nonHighscoredictionaryentries={};
	nonTopBeeHeadPlayerID=nil;
	nonLastSelection=nil;
	nonBeeHeadPlayerMenuPoint=nil;
	nonBeeHeadMenuPoint=nil;
}

-- ********************************************************
--- Global Defines
-- variables that are enumaration values
-- @NON_NOTHING: nothing
-- @NON_NEXTEVENT: the controlls detection detected a next stage event
-- @NON_INITEVENT: the controlls detection detected a init stage event
-- @NON_MENUEVENT: the controlls detection detected a menu stage event
-- @NON_CONTROLLERNONE: (test of) no diretion or button of a pad
-- @NON_CONTROLLERUP: direction up of a pad
-- @NON_CONTROLLERDOWN: direction down of a pad
-- @NON_CONTROLLERLEFT: direction left of a pad
-- @NON_CONTROLLERRIGHT: direction right of a pad
-- @NON_JAGPADFIRE_A: Button A of a pad
-- @NON_JAGPADFIRE_B: Button B of a pad
-- @NON_JAGPADFIRE_C: Button C of a pad
-- @NON_JAGPADKEY_STAR: Key * of a pad
-- @NON_JAGPADKEY_0:	Key 0 of a pad
-- @NON_JAGPADKEY_HASH: Key # of a pad
-- @NON_JAGPADKEY_7: Key 7 of a pad
-- @NON_JAGPADKEY_8: key 8 of a pad
-- @NON_JAGPADKEY_9: key 9 of a pad
-- @NON_JAGPADKEY_4: key 4 of a pad
-- @NON_JAGPADKEY_5: key 5 of a pad
-- @NON_JAGPADKEY_6: key 6 of a pad
-- @NON_JAGPADKEY_1: key 1 of a pad
-- @NON_JAGPADKEY_2: key 2 of a pad
-- @NON_JAGPADKEY_3: key 3 of a pad
-- @NON_JAGPADKEY_PAUSE: pause key of a pad
-- @NON_JAGPADKEY_OPTION: option key of a pad
-- @NON_NOTRANSPARENCY: don not use transprancy for a shape
-- @NON_TRANSPARENCY: use transprancy for a shape
-- @NON_INCREASE: used for scoring to indicate an increase
-- @NON_DECREASE: used for scoring to indicate an decrease

NON_NOTHING=0
NON_NEXTEVENT=1
NON_INITEVENT=2
NON_MENUEVENT=3
NON_CONTROLLERNONE=0
NON_CONTROLLERUP=1
NON_CONTROLLERDOWN=2
NON_CONTROLLERLEFT=4
NON_CONTROLLERRIGHT=8
NON_JAGPADFIRE_A=128
NON_JAGPADFIRE_B=64
NON_JAGPADFIRE_C=32
NON_JAGPADKEY_STAR=1
NON_JAGPADKEY_0=16
NON_JAGPADKEY_HASH=256
NON_JAGPADKEY_7=2
NON_JAGPADKEY_8=32
NON_JAGPADKEY_9=512
NON_JAGPADKEY_4=4
NON_JAGPADKEY_5=64
NON_JAGPADKEY_6=1024
NON_JAGPADKEY_1=8
NON_JAGPADKEY_2=128
NON_JAGPADKEY_3=2048
NON_JAGPADKEY_PAUSE=8192
NON_JAGPADKEY_OPTION=4096
NON_NOTRANSPARENCY=0;
NON_TRANSPARENCY=1;
NON_INCREASE=0;
NON_DECREASE=1;

-- internal constantes

NON_STAGE=0;
NON_SUBSTAGE=1;

-- ********************************************************
--- non_Disptcher
-- The main NonConForm function. Dispatches from one stage to another.
-- At the end of each stage, a carbagecollection is done.

function non_Dispatcher()
	nonInternals.nonLastStage="_init_";
	nonInternals.nonNextStage=ncf_Stage_Init;

	while nonInternals.nonNextStage~="exit" do
		-- set exit event to nothing +++++++++++++++++++++++++++++++++
		nonInternals.nonExitEvent=NON_NOTHING;
		
		-- +++ call next stage +++++++++++++++++++++++++++++++++++++++ 
		nonInternals.nonLastStage,nonInternals.nonNextStage,nonInternals.nonNextStageType=nonInternals.nonNextStage();

		-- +++ test events +++++++++++++++++++++++++++++++++++++++++++
		if nonInternals.nonExitEvent==NON_INITEVENT then
			nonInternals.nonNextStage,nonInternals.nonNextStageType=non_StageSelection("init",nonInternals.nonEventStages);
		elseif nonInternals.nonExitEvent==NON_MENUEVENT then
			nonInternals.nonNextStage,nonInternals.nonNextStageType=non_StageSelection("menu",nonInternals.nonEventStages);
		end

		-- +++ lua carbage collection ++++++++++++++++++++++++++++++++
		collectgarbage();
	end
end

-- ********************************************************
--- non_StageSelection
-- caculate the next stage
-- @nextStage: the variable the holds the next Stage or the string the represents the next stage
-- @stages: the actual nextstages table
-- @@: (function): the next stage function

function non_StageSelection(nextStage,stages)
	if stages[nonInternals.nonLastStage]~=nil then
		return stages[nonInternals.nonLastStage][nextStage]();
	else
		return stages["_default_"][nextStage]();
	end
end

-- ********************************************************
--- non_ScoreEntry
-- creates a score entry because of a record
-- @scoreentry: the record

function non_ScoreEntry(scoreentry)
	table.insert(nonGlobals.nonSingleScores,{id=scoreentry.id,score=scoreentry.score,newscore=scoreentry.newscore});	
end

-- ********************************************************
--- non_highscoredictionaryentry
-- creates a highscoredictionary entry because of a record
-- @entry: the record

function non_highscoredictionaryentry(entry)
	nonGlobals.nonHighscoredictionaryentries[entry.key]=entry.filenumber;
	nonGlobals.nonNumberOfHighscoredictionaryentries=nonGlobals.nonNumberOfHighscoredictionaryentries+1;
end