dofile("..\\lib\\non_base.lua"); 
dofile("..\\lib\\non_f030.lua");
dofile("..\\lib\\non_util.lua");
dofile("..\\lib\\non_vdeo.lua");
dofile("..\\lib\\non_pain.lua");
dofile("..\\lib\\non_cont.lua");
dofile("..\\lib\\non_ctl.lua");
dofile("..\\lib\\non_bHea.lua");

dofile("..\\noncon\\multimed.lua");

dofile("..\\noncon\\ncfgame.lua");

-- ***************************************************
-- Additional Global Variables
-- ***************************************************

nonGlobals.propBarriers=0;
nonGlobals.propDelLine=true;
nonGlobals.propPoints=false;

-- ***************************************************
-- Constants
-- ***************************************************

NON_MAXIMUMPLAYERS=8;
NON_MINIMUMPLAYERS=1;
-- **************************************************
-- Init Stage
-- **************************************************
function ncf_Stage_Init()
	local model={
		stagename="Init",
		screenwidth=320,
		screenheight=240,
		useKeyBoard=true,
		useTeamTaps=true,
		useJagPads=false,
		beehead={
			useBeeHead=true,
			searchinfolders={"c:","d:","e:","f:","g:","h:","i:","j:","/user/local"},
			defaultplayershapewidth=20,
			defaultplayershapeheight=20,
		},
		nextstages={
			_default_={
				next=function() return ncf_Stage_Logo,NON_STAGE; end
			}
		}
	}
	
	local view={
	}

	return non_controllInit(view,model);
end
-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- Logo Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_Logo()
	local model={
		stagename="Logo",
		events={
			usePad=true,
			mastermode=false,
			useKeyBoard=true,
			useInitEvent=true,
			useMenuEvent=false,
			useScreenDump=true,
		},
		nextstages={
			_default_={
				next=function() return ncf_Stage_Title,NON_STAGE; end
			},
		},
	}

	local view={
		NonBox.new(0,0,320,240,0),
		NonPicture.new(0,0,320,240,0,nonShapes.tscclogo);
	}
	
	nonMods.mainmod:playMod();
	
	return non_controllWaitForInput(view,model);
end	
-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- Title Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_Title()
	local model={
		stagename="Title",
		events={
			usePad=true,
			mastermode=false,
			useKeyBoard=true,
			useInitEvent=true,
			useMenuEvent=false,
			useScreenDump=true,
		},
		nextstages={
			_default_={
				next=function() return ncf_Stage_Credits,NON_STAGE; end
			},
		},
	}

	local view={
		NonBox.new(0,0,320,240,0),
		NonPicture.new(0,0,320,240,0,nonShapes.titlepic)
	}
	
	return non_controllWaitForInput(view,model);
end	
-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- Credits Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_Credits()
	local model={
		stagename="Credits",
		events={
			usePad=true,
			mastermode=false,
			useKeyBoard=true,
			useInitEvent=true,
			useMenuEvent=false,
			useScreenDump=true,
		},
		nextstages={
			Title={
				next=function() return ncf_Stage_GameInit,NON_STAGE; end
			},
			Menu={
				next=function() return ncf_Stage_Menu,NON_STAGE; end
			},
		},
	}

	local view={
		NonPicture.new(0,0,320,240,0,nonShapes.creditsbackground),
		NonText.new(148,10,nonFonts.font77,"CODE",0),
		NonText.new(123,25,nonFonts.font1616,"KRADD",0),
		NonText.new(142,55,nonFonts.font77,"COVER",0),
		NonText.new(54,70,nonFonts.font1616,"SAMURAI/INTER",0),
		NonText.new(142,95,nonFonts.font77,"FONTS",0),
		NonText.new(38,110,nonFonts.font1616,"TITUS/RABENAUGE",0),
		NonText.new(148,135,nonFonts.font77,"MSX",0),
		NonText.new(72,150,nonFonts.font1616,"505/PARADOX",0),
		NonText.new(118,222,nonFonts.font77,"(C)2008 TSCC",0),
	}
	
	return non_controllScrollerWaitForInput(view,model);
end	
-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- GameInit Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_GameInit()
	local model={
		stagename="GameInit",
		nextstages={
			_default_={
				next=function() return ncf_Stage_Menu,NON_STAGE; end
			}
		}
	}

	local view={
	}
	
	return non_controllGameInit(view,model);
end
-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- Menu Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_Menu()
	local view={
		viewgroups={
			background={
				NonPicture.new(0,0,320,240,0,nonShapes.menubackground),
				NonText.new(88,43,nonFonts.font1616,"MAIN MENU",0),
				NonPicture.new(62,68,36,25,1,nonShapes.icons.start),
				NonPicture.new(62,101,36,25,1,nonShapes.icons.controllers),
				NonPicture.new(62,134,36,25,1,nonShapes.icons.options),
				NonPicture.new(62,167,36,25,1,nonShapes.icons.credits),
				NonPicture.new(62,200,36,25,1,nonShapes.icons.quit),
			},
			menu={
				options={
					NonText.new(110,70,nonFonts.font1616,"START",0),
					NonText.new(110,103,nonFonts.font1616,"PLAYERS",0),
					NonText.new(110,136,nonFonts.font1616,"OPTIONS",0),
    			NonText.new(110,169,nonFonts.font1616,"CREDITS",0),
					NonText.new(110,202,nonFonts.font1616,"EXIT",0)
				},
			}
		},
		"background",
		"menu"
	}
	
	local model={
		stagename="Menu",
		events={
			usePad=false,
			mastermode=true,
			useKeyBoard=true,
			useInitEvent=true,
			useMenuEvent=false,
			useScreenDump=true,
		},
		choices=5,
		choice=0,
		fonts={
			--active=nonFonts.red,
			active=nonFonts.font1616g,
			--inactive=nonFonts.white
			inactive=nonFonts.font1616b,
		},
		menupoint=1,
		nextstages={
			_default_={
				function() return ncf_Stage_GameRound,NON_STAGE; end,
				function() return ncf_Stage_Players,NON_STAGE; end,
				function() return ncf_Stage_Options,NON_STAGE; end,
				function() return ncf_Stage_Credits,NON_STAGE; end,
				function() return "exit"; end,
			},
		},
		viewelements=view.viewgroups.menu
	}
	
	return non_controllMenu(view,model);
end
-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- Options Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_Options()
	local model={
		stagename="Options",
		events={
			usePad=true,
			mastermode=true,
			useKeyBoard=true,
			useInitEvent=true,
			useMenuEvent=false,
			useScreenDump=true,
		},
		globalvalues={
			"nonNumberOfPlayers",
			"propBarriers",
			"propDelLine",
			"nonNumberOfRounds",
			"propPoints"
		},
		texts={
			"PLAYER",
			"BARRIERS",
			"DEL@LINE",
			"ROUNDS",
			"POINTS"
		},
		pictures={
			nonShapes.icons.players,
			nonShapes.icons.barriers,
			nonShapes.icons.delline,
			nonShapes.icons.rounds,
			nonShapes.icons.points
		},
		min={1,0,0,1,0},
		max={8,99,1,99,1},
		checkpictures={
			nonShapes.icons.no,
			nonShapes.icons.yes
		},
		choices=5,
		choice=0,
		menupoint=1,
		fonts={
			active=nonFonts.font1616g,
			inactive=nonFonts.font1616b
		},
		nextstages={
			_default_={
				next=function() return ncf_Stage_Menu,NON_STAGE; end
			},
		},
	}

	local view={
		viewgroups={
			background={
				NonPicture.new(0,0,320,240,0,nonShapes.optionsbackground),
				NonText.new(104,43,nonFonts.font1616,"OPTIONS",0),
			},
			options={
				NonText.new(60,70,nonFonts.font1616g,"",0),
				NonText.new(60,103,nonFonts.font1616b,"",0),
				NonText.new(60,136,nonFonts.font1616b,"",0),
				NonText.new(60,169,nonFonts.font1616b,"",0),
				NonText.new(60,202,nonFonts.font1616b,"",0)
			},
			valuecomponents={
				NonText.new(264,70,nonFonts.font1616b,"",0),
				NonText.new(264,103,nonFonts.font1616b,"",0),
				NonPicture.new(260,134,36,25,1,model.checkpictures[1],model.checkpictures[1]),
				NonText.new(264,169,nonFonts.font1616b,"",0),
				NonPicture.new(260,200,36,25,1,model.checkpictures[1],model.checkpictures[1])
			},
			picturecomponents={
				NonPicture.new(10,68,36,25,1,model.pictures[1]),
				NonPicture.new(10,101,36,25,1,model.pictures[2]),
				NonPicture.new(10,134,36,25,1,model.pictures[3]),
				NonPicture.new(10,167,36,25,1,model.pictures[4]),
				NonPicture.new(10,200,36,25,1,model.pictures[5])
			},
		},
		"background",
		"options",
		"valuecomponents",
		"picturecomponents"
	}
	
	return non_controllOption(view,model);
end

-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- Players Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_Players()
	local view={
		viewgroups={
			background={
				NonPicture.new(0,0,320,240,0,nonShapes.playerbackground),
				NonText.new(100,10,nonFonts.font1616,"Players",0),
				NonText.new(91,92,nonFonts.font1616,"beeheads",0),
				NonText.new(34,200,nonFonts.font77,"press pad key 1-8 to select players",0),
				NonText.new(66,210,nonFonts.font77,"press pad button b to exit",0),
			},
			playersselect={
				numbers={
  				[1]=NonText.new(46,36,nonFonts.font77,"1",0),
	  			[2]=NonText.new(76,36,nonFonts.font77,"2",0),
	 				[3]=NonText.new(106,36,nonFonts.font77,"3",0),
					[4]=NonText.new(136,36,nonFonts.font77,"4",0),
					[5]=NonText.new(166,36,nonFonts.font77,"5",0),
					[6]=NonText.new(196,36,nonFonts.font77,"6",0),
					[7]=NonText.new(226,36,nonFonts.font77,"7",0),
					[8]=NonText.new(256,36,nonFonts.font77,"8",0),
				},
				optionpictures={
					[1]=NonPicture.new(40,50,20,20,0,nonInternals.nonPlayerShapes[1]),
					[2]=NonPicture.new(70,50,20,20,0,nonInternals.nonPlayerShapes[2]),
					[3]=NonPicture.new(100,50,20,20,0,nonInternals.nonPlayerShapes[3]),
					[4]=NonPicture.new(130,50,20,20,0,nonInternals.nonPlayerShapes[4]),
					[5]=NonPicture.new(160,50,20,20,0,nonInternals.nonPlayerShapes[5]),
					[6]=NonPicture.new(190,50,20,20,0,nonInternals.nonPlayerShapes[6]),
					[7]=NonPicture.new(220,50,20,20,0,nonInternals.nonPlayerShapes[7]),
					[8]=NonPicture.new(250,50,20,20,0,nonInternals.nonPlayerShapes[8])
				},
				options={
					[1]=NonText.new(39,76,nonFonts.font77,"123",0),
					[2]=NonText.new(69,76,nonFonts.font77,"123",0),
					[3]=NonText.new(99,76,nonFonts.font77,"123",0),
					[4]=NonText.new(129,76,nonFonts.font77,"123",0),
					[5]=NonText.new(159,76,nonFonts.font77,"123",0),
					[6]=NonText.new(189,76,nonFonts.font77,"123",0),
					[7]=NonText.new(219,76,nonFonts.font77,"123",0),
					[8]=NonText.new(249,76,nonFonts.font77,"123",0)
				}
			},
			beeheadselect={
				optionpictures={
					NonPicture.new(16,118,20,20,0,nonInternals.nonPlayerShapes[1]),
					NonPicture.new(116,118,20,20,0,nonInternals.nonPlayerShapes[1]),
					NonPicture.new(216,118,20,20,0,nonInternals.nonPlayerShapes[1]),
					NonPicture.new(16,144,20,20,0,nonInternals.nonPlayerShapes[1]),
					NonPicture.new(116,144,20,20,0,nonInternals.nonPlayerShapes[1]),
					NonPicture.new(216,144,20,20,0,nonInternals.nonPlayerShapes[1]),
					NonPicture.new(16,170,20,20,0,nonInternals.nonPlayerShapes[1]),
					NonPicture.new(116,170,20,20,0,nonInternals.nonPlayerShapes[1]),
					NonPicture.new(216,170,20,20,0,nonInternals.nonPlayerShapes[1])
				},
				options={
					NonText.new(46,124,nonFonts.font77,"12345678",0),
					NonText.new(146,124,nonFonts.font77,"12345678",0),
					NonText.new(246,124,nonFonts.font77,"12345678",0),
					NonText.new(46,150,nonFonts.font77,"12345678",0),
					NonText.new(146,150,nonFonts.font77,"12345678",0),
					NonText.new(246,150,nonFonts.font77,"12345678",0),
					NonText.new(46,176,nonFonts.font77,"12345678",0),
					NonText.new(146,176,nonFonts.font77,"12345678",0),
					NonText.new(246,176,nonFonts.font77,"12345678",0)
				}
			}
		},
		"background",
		"playersselect",
		"beeheadselect"		
	}
	
	local model={
		stagename="players",
		events={
			usePad=true,
			mastermode=true,
			useKeyBoard=true,
			useInitEvent=true,
			useMenuEvent=false,
			useScreenDump=true,
		},
		center=false,
		topplayerid=17,
		allplayerpics={nil,nil,nil,nil,nil,nil,nil,nil,nil};
		allplayershapes={nil,nil,nil,nil,nil,nil,nil,nil,nil};
		maximumplayerstochoose=8,
		numberofbeeheads=9,
		choices=9,
		choice=0,
		ybeeheads=3,
		xbeeheads=3,
		fonts={
			active=nonFonts.font77red,
			inactive=nonFonts.font77,
		},
		menupoint=1,
		nextstages={
			_default_={
				next=function() return ncf_Stage_Menu,NON_STAGE; end
			}
		},
		viewelements=view.viewgroups.beeheadselect,
		globalvalues={
			topbeeheadplayerid="nonTopBeeHeadPlayerID",
		}
	}
	
	return non_controllBeeHeadSelection(view,model);
end

-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- GameRound Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_GameRound()
	local model={
		stagename="gameround",
		nextstages={
			_default_={
				next=function() return ncf_Stage_Game,NON_STAGE; end,
				finish=function() return ncf_Stage_GameInit,NON_STAGE; end
			}
		}
	}
	
	local view={
	}
	
	return non_controllGameRound(view,model);
end
-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- Game Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_Game()
	local model={
		stagename="Game",
		events={
			usePad=false,
			mastermode=true,
			useKeyBoard=true,
			useInitEvent=true,
			useMenuEvent=true,
			useScreenDump=true,
		},
		nextstages={
			_default_={
				next=function() return ncf_Stage_Scoring,NON_STAGE; end
			}
		}
	}

	local view={
		NonPicture.new(0,0,320,240,0,nonShapes.gamebackground),
	}
	
	-- the game
	showGame(model,view);
	
	return non_controllNothing(view,model);
end

-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- Scoring Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_Scoring()
	-- +++ model +++++++++++++++++++++++++++++++++++++++++++++++++
	local model={
		stagename="scoring",
		globalvalues={
			scores="nonTournamentScores",
			results="nonGameResults"
		},
		nextstages={
			_default_={
				next=function() return ncf_Stage_TournamentTable,NON_STAGE; end
			},
		},
	};

	-- +++ view ++++++++++++++++++++++++++++++++++++++++++++++++++	
	local view={
	};

	-- +++ controller ++++++++++++++++++++++++++++++++++++++++++++
	return non_controllTournamenScoring(view,model);
end

-- +++++++++++++++++++++++++++++++++++++++++++++++++++
-- TournamentTable Stage
-- +++++++++++++++++++++++++++++++++++++++++++++++++++ 
function ncf_Stage_TournamentTable()
	local model={
		stagename="TournamentTable",
		events={
			usePad=false,
			mastermode=false,
			useKeyBoard=true,
			useInitEvent=true,
			useMenuEvent=true,
			useScreenDump=true,
		},
		buttonpressed=nonShapes.buttonpressed,
		globalvalues={
			scores="nonTournamentScores"
		},
		fonts={
			notroundresult=nonFonts.font77,
			roundresult=nonFonts.font77red,
		},
		shapes={
			same=nonShapes.icons.same,
			increase=nonShapes.icons.increase,
			decrease=nonShapes.icons.decrease
		},
		showMaximumOfPlayers=false,
		showMaximumCompetitionResults=false,
 		showMissingInActions=true,
 		nextstages={
			_default_={
				next=function() return ncf_Stage_GameRound,NON_STAGE; end
			},
		},
	};
	
	local view={
		sprites={
			[1]=NonSprite.new(6,35,16,18,nonShapes.buttonnotpressed,0,0),
			[2]=NonSprite.new(6,61,16,18,nonShapes.buttonnotpressed,0,0),
			[3]=NonSprite.new(6,87,16,18,nonShapes.buttonnotpressed,0,0),
			[4]=NonSprite.new(6,113,16,18,nonShapes.buttonnotpressed,0,0),
			[5]=NonSprite.new(6,139,16,18,nonShapes.buttonnotpressed,0,0),
			[6]=NonSprite.new(6,165,16,18,nonShapes.buttonnotpressed,0,0),
			[7]=NonSprite.new(6,191,16,18,nonShapes.buttonnotpressed,0,0),
			[8]=NonSprite.new(6,217,16,18,nonShapes.buttonnotpressed,0,0),
		},
		viewgroups={
			background={
				NonPicture.new(0,0,320,240,0,nonShapes.tournamentbackground),
				NonText.new(9,3,nonFonts.font1616,"TOURNAMENT TABLE",0),
				NonText.new(7,23,nonFonts.font77grey,"OK",0),
				NonText.new(31,23,nonFonts.font77,"PL.",0),
				NonText.new(138,23,nonFonts.font77,"NAME",0),
				NonText.new(229,23,nonFonts.font77grey,"LAST",0),
				NonText.new(272,23,nonFonts.font77,"SCORE",0)
			},
			round={
				headline=NonText.new(277,2,nonFonts.font77grey,"Round",0),
				seperator=NonText.new(291,12,nonFonts.font77grey,"/",0),
				actualround=NonText.new(275,12,nonFonts.font77grey,"0",0),
				totalrounds=NonText.new(299,12,nonFonts.font77grey,"0",0)
			},
			players={
				[1]={
					playerindependent={
						place=NonText.new(27,35,nonFonts.font1616,"1",0),
						change=NonPicture.new(43,34,14,20,1,model.shapes.same),
						picture=NonPicture.new(62,34,20,20,0,nonInternals.nonPlayerShapes[1]),
						name=NonText.new(88,33,nonFonts.font77,"00000000",0),
						last=NonText.new(229,33,nonFonts.font77grey,"0000",0),
						points=NonText.new(264,33,nonFonts.font77,"0000000",0),
					},
					playerdependent={
						[1]={
							place=NonText.new(91,46,nonFonts.font77grey,"1",0),
							amount=NonText.new(100,46,nonFonts.font77,"00",0),
							doublepoint=NonText.new(95,46,nonFonts.font77grey,":",0),
						},
						[2]={
							place=NonText.new(119,46,nonFonts.font77grey,"2",0),
							amount=NonText.new(128,46,nonFonts.font77,"00",0),
							doublepoint=NonText.new(123,46,nonFonts.font77grey,":",0),
						},
						[3]={
							place=NonText.new(147,46,nonFonts.font77grey,"3",0),
							amount=NonText.new(156,46,nonFonts.font77,"00",0),
							doublepoint=NonText.new(151,46,nonFonts.font77grey,":",0),
						},
						[4]={
							place=NonText.new(175,46,nonFonts.font77grey,"4",0),
							amount=NonText.new(184,46,nonFonts.font77,"00",0),
							doublepoint=NonText.new(179,46,nonFonts.font77grey,":",0),
						},
						[5]={
							place=NonText.new(203,46,nonFonts.font77grey,"5",0),
							amount=NonText.new(212,46,nonFonts.font77,"00",0),
							doublepoint=NonText.new(207,46,nonFonts.font77grey,":",0),
						},
						[6]={
							place=NonText.new(231,46,nonFonts.font77grey,"6",0),
							amount=NonText.new(240,46,nonFonts.font77,"00",0),
							doublepoint=NonText.new(235,46,nonFonts.font77grey,":",0),
						},
						[7]={
							place=NonText.new(259,46,nonFonts.font77grey,"7",0),
							amount=NonText.new(268,46,nonFonts.font77,"00",0),
							doublepoint=NonText.new(263,46,nonFonts.font77grey,":",0),
						},
						[8]={
							place=NonText.new(287,46,nonFonts.font77grey,"8",0),
							amount=NonText.new(296,46,nonFonts.font77,"00",0),
							doublepoint=NonText.new(291,46,nonFonts.font77grey,":",0),
						},
					},
				},
				[2]={
					playerindependent={
						place=NonText.new(27,61,nonFonts.font1616,"1",0),
						change=NonPicture.new(43,60,14,20,1,model.shapes.same),
						picture=NonPicture.new(62,60,20,20,0,nonInternals.nonPlayerShapes[1]),
						name=NonText.new(88,59,nonFonts.font77,"00000000",0),
						last=NonText.new(229,59,nonFonts.font77grey,"0000",0),
						points=NonText.new(264,59,nonFonts.font77,"000000",0),
					},
					playerdependent={
						[1]={
							place=NonText.new(91,72,nonFonts.font77grey,"1",0),
							amount=NonText.new(100,72,nonFonts.font77,"00",0),
							doublepoint=NonText.new(95,72,nonFonts.font77grey,":",0),
						},
						[2]={
							place=NonText.new(119,72,nonFonts.font77grey,"2",0),
							amount=NonText.new(128,72,nonFonts.font77,"00",0),
							doublepoint=NonText.new(123,72,nonFonts.font77grey,":",0),
						},
						[3]={
							place=NonText.new(147,72,nonFonts.font77grey,"3",0),
							amount=NonText.new(156,72,nonFonts.font77,"00",0),
							doublepoint=NonText.new(151,72,nonFonts.font77grey,":",0),
						},
						[4]={
							place=NonText.new(175,72,nonFonts.font77grey,"4",0),
							amount=NonText.new(184,72,nonFonts.font77,"00",0),
							doublepoint=NonText.new(179,72,nonFonts.font77grey,":",0),
						},
						[5]={
							place=NonText.new(203,72,nonFonts.font77grey,"5",0),
							amount=NonText.new(212,72,nonFonts.font77,"00",0),
							doublepoint=NonText.new(207,72,nonFonts.font77grey,":",0),
						},
						[6]={
							place=NonText.new(231,72,nonFonts.font77grey,"6",0),
							amount=NonText.new(240,72,nonFonts.font77,"00",0),
							doublepoint=NonText.new(235,72,nonFonts.font77grey,":",0),
						},
						[7]={
							place=NonText.new(259,72,nonFonts.font77grey,"7",0),
							amount=NonText.new(268,72,nonFonts.font77,"00",0),
							doublepoint=NonText.new(263,72,nonFonts.font77grey,":",0),
						},
						[8]={
							place=NonText.new(287,72,nonFonts.font77grey,"8",0),
							amount=NonText.new(296,72,nonFonts.font77,"00",0),
							doublepoint=NonText.new(291,72,nonFonts.font77grey,":",0),
						},
					},
				},
				[3]={
					playerindependent={
						place=NonText.new(27,87,nonFonts.font1616,"1",0),
						change=NonPicture.new(43,86,14,20,1,model.shapes.same),
						picture=NonPicture.new(62,86,20,20,0,nonInternals.nonPlayerShapes[1]),
						name=NonText.new(88,85,nonFonts.font77,"00000000",0),
						last=NonText.new(229,85,nonFonts.font77grey,"0000",0),
						points=NonText.new(264,85,nonFonts.font77,"0000000",0),
					},
					playerdependent={
						[1]={
							place=NonText.new(91,98,nonFonts.font77grey,"1",0),
							amount=NonText.new(100,98,nonFonts.font77,"00",0),
							doublepoint=NonText.new(95,98,nonFonts.font77grey,":",0),
						},
						[2]={
							place=NonText.new(119,98,nonFonts.font77grey,"2",0),
							amount=NonText.new(128,98,nonFonts.font77,"00",0),
							doublepoint=NonText.new(123,98,nonFonts.font77grey,":",0),
						},
						[3]={
							place=NonText.new(147,98,nonFonts.font77grey,"3",0),
							amount=NonText.new(156,98,nonFonts.font77,"00",0),
							doublepoint=NonText.new(151,98,nonFonts.font77grey,":",0),
						},
						[4]={
							place=NonText.new(175,98,nonFonts.font77grey,"4",0),
							amount=NonText.new(184,98,nonFonts.font77,"00",0),
							doublepoint=NonText.new(179,98,nonFonts.font77grey,":",0),
						},
						[5]={
							place=NonText.new(203,98,nonFonts.font77grey,"5",0),
							amount=NonText.new(212,98,nonFonts.font77,"00",0),
							doublepoint=NonText.new(207,98,nonFonts.font77grey,":",0),
						},
						[6]={
							place=NonText.new(231,98,nonFonts.font77grey,"6",0),
							amount=NonText.new(240,98,nonFonts.font77,"00",0),
							doublepoint=NonText.new(235,98,nonFonts.font77grey,":",0),
						},
						[7]={
							place=NonText.new(259,98,nonFonts.font77grey,"7",0),
							amount=NonText.new(268,98,nonFonts.font77,"00",0),
							doublepoint=NonText.new(263,98,nonFonts.font77grey,":",0),
						},
						[8]={
							place=NonText.new(287,98,nonFonts.font77grey,"8",0),
							amount=NonText.new(296,98,nonFonts.font77,"00",0),
							doublepoint=NonText.new(291,98,nonFonts.font77grey,":",0),
						},
					},
				},
				[4]={
					playerindependent={
						place=NonText.new(27,113,nonFonts.font1616,"1",0),
						change=NonPicture.new(43,112,14,20,1,model.shapes.same),
						picture=NonPicture.new(62,112,20,20,0,nonInternals.nonPlayerShapes[1]),
						name=NonText.new(88,111,nonFonts.font77,"00000000",0),
						last=NonText.new(229,111,nonFonts.font77grey,"0000",0),
						points=NonText.new(264,111,nonFonts.font77,"0000000",0),
					},
					playerdependent={
						[1]={
							place=NonText.new(91,124,nonFonts.font77grey,"1",0),
							amount=NonText.new(100,124,nonFonts.font77,"00",0),
							doublepoint=NonText.new(95,124,nonFonts.font77grey,":",0),
						},
						[2]={
							place=NonText.new(119,124,nonFonts.font77grey,"2",0),
							amount=NonText.new(128,124,nonFonts.font77,"00",0),
							doublepoint=NonText.new(123,124,nonFonts.font77grey,":",0),
						},
						[3]={
							place=NonText.new(147,124,nonFonts.font77grey,"3",0),
							amount=NonText.new(156,124,nonFonts.font77,"00",0),
							doublepoint=NonText.new(151,124,nonFonts.font77grey,":",0),
						},
						[4]={
							place=NonText.new(175,124,nonFonts.font77grey,"4",0),
							amount=NonText.new(184,124,nonFonts.font77,"00",0),
							doublepoint=NonText.new(179,124,nonFonts.font77grey,":",0),
						},
						[5]={
							place=NonText.new(203,124,nonFonts.font77grey,"5",0),
							amount=NonText.new(212,124,nonFonts.font77,"00",0),
							doublepoint=NonText.new(207,124,nonFonts.font77grey,":",0),
						},
						[6]={
							place=NonText.new(231,124,nonFonts.font77grey,"6",0),
							amount=NonText.new(240,124,nonFonts.font77,"00",0),
							doublepoint=NonText.new(235,124,nonFonts.font77grey,":",0),
						},
						[7]={
							place=NonText.new(259,124,nonFonts.font77grey,"7",0),
							amount=NonText.new(268,124,nonFonts.font77,"00",0),
							doublepoint=NonText.new(263,124,nonFonts.font77grey,":",0),
						},
						[8]={
							place=NonText.new(287,124,nonFonts.font77grey,"8",0),
							amount=NonText.new(296,124,nonFonts.font77,"00",0),
							doublepoint=NonText.new(291,124,nonFonts.font77grey,":",0),
						},
					},
				},
				[5]={
					playerindependent={
						place=NonText.new(27,139,nonFonts.font1616,"1",0),
						change=NonPicture.new(43,138,14,20,1,model.shapes.same),
						picture=NonPicture.new(62,138,20,20,0,nonInternals.nonPlayerShapes[1]),
						name=NonText.new(88,137,nonFonts.font77,"00000000",0),
						last=NonText.new(229,137,nonFonts.font77grey,"0000",0),
						points=NonText.new(264,137,nonFonts.font77,"0000000",0),
					},
					playerdependent={
						[1]={
							place=NonText.new(91,150,nonFonts.font77grey,"1",0),
							amount=NonText.new(100,150,nonFonts.font77,"00",0),
							doublepoint=NonText.new(95,150,nonFonts.font77grey,":",0),
						},
						[2]={
							place=NonText.new(119,150,nonFonts.font77grey,"2",0),
							amount=NonText.new(128,150,nonFonts.font77,"00",0),
							doublepoint=NonText.new(123,150,nonFonts.font77grey,":",0),
						},
						[3]={
							place=NonText.new(147,150,nonFonts.font77grey,"3",0),
							amount=NonText.new(156,150,nonFonts.font77,"00",0),
							doublepoint=NonText.new(151,150,nonFonts.font77grey,":",0),
						},
						[4]={
							place=NonText.new(175,150,nonFonts.font77grey,"4",0),
							amount=NonText.new(184,150,nonFonts.font77,"00",0),
							doublepoint=NonText.new(179,150,nonFonts.font77grey,":",0),
						},
						[5]={
							place=NonText.new(203,150,nonFonts.font77grey,"5",0),
							amount=NonText.new(212,150,nonFonts.font77,"00",0),
							doublepoint=NonText.new(207,150,nonFonts.font77grey,":",0),
						},
						[6]={
							place=NonText.new(231,150,nonFonts.font77grey,"6",0),
							amount=NonText.new(240,150,nonFonts.font77,"00",0),
							doublepoint=NonText.new(235,150,nonFonts.font77grey,":",0),
						},
						[7]={
							place=NonText.new(259,150,nonFonts.font77grey,"7",0),
							amount=NonText.new(268,150,nonFonts.font77,"00",0),
							doublepoint=NonText.new(263,150,nonFonts.font77grey,":",0),
						},
						[8]={
							place=NonText.new(287,150,nonFonts.font77grey,"8",0),
							amount=NonText.new(296,150,nonFonts.font77,"00",0),
							doublepoint=NonText.new(291,150,nonFonts.font77grey,":",0),
						},
					},
				},
				[6]={
					playerindependent={
						place=NonText.new(27,165,nonFonts.font1616,"1",0),
						change=NonPicture.new(43,164,14,20,1,model.shapes.same),
						picture=NonPicture.new(62,164,20,20,0,nonInternals.nonPlayerShapes[1]),
						name=NonText.new(88,163,nonFonts.font77,"00000000",0),
						last=NonText.new(229,163,nonFonts.font77grey,"0000",0),
						points=NonText.new(264,163,nonFonts.font77,"0000000",0),
					},
					playerdependent={
						[1]={
							place=NonText.new(91,176,nonFonts.font77grey,"1",0),
							amount=NonText.new(100,176,nonFonts.font77,"00",0),
							doublepoint=NonText.new(95,176,nonFonts.font77grey,":",0),
						},
						[2]={
							place=NonText.new(119,176,nonFonts.font77grey,"2",0),
							amount=NonText.new(128,176,nonFonts.font77,"00",0),
							doublepoint=NonText.new(123,176,nonFonts.font77grey,":",0),
						},
						[3]={
							place=NonText.new(147,176,nonFonts.font77grey,"3",0),
							amount=NonText.new(156,176,nonFonts.font77,"00",0),
							doublepoint=NonText.new(151,176,nonFonts.font77grey,":",0),
						},
						[4]={
							place=NonText.new(175,176,nonFonts.font77grey,"4",0),
							amount=NonText.new(184,176,nonFonts.font77,"00",0),
							doublepoint=NonText.new(179,176,nonFonts.font77grey,":",0),
						},
						[5]={
							place=NonText.new(203,176,nonFonts.font77grey,"5",0),
							amount=NonText.new(212,176,nonFonts.font77,"00",0),
							doublepoint=NonText.new(207,176,nonFonts.font77grey,":",0),
						},
						[6]={
							place=NonText.new(231,176,nonFonts.font77grey,"6",0),
							amount=NonText.new(240,176,nonFonts.font77,"00",0),
							doublepoint=NonText.new(235,176,nonFonts.font77grey,":",0),
						},
						[7]={
							place=NonText.new(259,176,nonFonts.font77grey,"7",0),
							amount=NonText.new(268,176,nonFonts.font77,"00",0),
							doublepoint=NonText.new(263,176,nonFonts.font77grey,":",0),
						},
						[8]={
							place=NonText.new(287,176,nonFonts.font77grey,"8",0),
							amount=NonText.new(296,176,nonFonts.font77,"00",0),
							doublepoint=NonText.new(291,176,nonFonts.font77grey,":",0),
						},
					},
				},
				[7]={
					playerindependent={
						place=NonText.new(27,191,nonFonts.font1616,"1",0),
						change=NonPicture.new(43,190,14,20,1,model.shapes.same),
						picture=NonPicture.new(62,190,20,20,0,nonInternals.nonPlayerShapes[1]),
						name=NonText.new(88,189,nonFonts.font77,"00000000",0),
						last=NonText.new(229,189,nonFonts.font77grey,"0000",0),
						points=NonText.new(264,189,nonFonts.font77,"0000000",0),
					},
					playerdependent={
						[1]={
							place=NonText.new(91,202,nonFonts.font77grey,"1",0),
							amount=NonText.new(100,202,nonFonts.font77,"00",0),
							doublepoint=NonText.new(95,202,nonFonts.font77grey,":",0),
						},
						[2]={
							place=NonText.new(119,202,nonFonts.font77grey,"2",0),
							amount=NonText.new(128,202,nonFonts.font77,"00",0),
							doublepoint=NonText.new(123,202,nonFonts.font77grey,":",0),
						},
						[3]={
							place=NonText.new(147,202,nonFonts.font77grey,"3",0),
							amount=NonText.new(156,202,nonFonts.font77,"00",0),
							doublepoint=NonText.new(151,202,nonFonts.font77grey,":",0),
						},
						[4]={
							place=NonText.new(175,202,nonFonts.font77grey,"4",0),
							amount=NonText.new(184,202,nonFonts.font77,"00",0),
							doublepoint=NonText.new(179,202,nonFonts.font77grey,":",0),
						},
						[5]={
							place=NonText.new(203,202,nonFonts.font77grey,"5",0),
							amount=NonText.new(212,202,nonFonts.font77,"00",0),
							doublepoint=NonText.new(207,202,nonFonts.font77grey,":",0),
						},
						[6]={
							place=NonText.new(231,202,nonFonts.font77grey,"6",0),
							amount=NonText.new(240,202,nonFonts.font77,"00",0),
							doublepoint=NonText.new(235,202,nonFonts.font77grey,":",0),
						},
						[7]={
							place=NonText.new(259,202,nonFonts.font77grey,"7",0),
							amount=NonText.new(268,202,nonFonts.font77,"00",0),
							doublepoint=NonText.new(263,202,nonFonts.font77grey,":",0),
						},
						[8]={
							place=NonText.new(287,202,nonFonts.font77grey,"8",0),
							amount=NonText.new(296,202,nonFonts.font77,"00",0),
							doublepoint=NonText.new(291,202,nonFonts.font77grey,":",0),
						},
					},
				},
				[8]={
					playerindependent={
						place=NonText.new(27,217,nonFonts.font1616,"1",0),
						change=NonPicture.new(43,216,14,20,1,model.shapes.same),
						picture=NonPicture.new(62,216,20,20,0,nonInternals.nonPlayerShapes[1]),
						name=NonText.new(88,215,nonFonts.font77,"00000000",0),
						last=NonText.new(229,215,nonFonts.font77grey,"0000",0),
						points=NonText.new(264,215,nonFonts.font77,"0000000",0),
					},
					playerdependent={
						[1]={
							place=NonText.new(91,228,nonFonts.font77grey,"1",0),
							amount=NonText.new(100,228,nonFonts.font77,"00",0),
							doublepoint=NonText.new(95,228,nonFonts.font77grey,":",0),
						},
						[2]={
							place=NonText.new(119,228,nonFonts.font77grey,"2",0),
							amount=NonText.new(128,228,nonFonts.font77,"00",0),
							doublepoint=NonText.new(123,228,nonFonts.font77grey,":",0),
						},
						[3]={
							place=NonText.new(147,228,nonFonts.font77grey,"3",0),
							amount=NonText.new(156,228,nonFonts.font77,"00",0),
							doublepoint=NonText.new(151,228,nonFonts.font77grey,":",0),
						},
						[4]={
							place=NonText.new(175,228,nonFonts.font77grey,"4",0),
							amount=NonText.new(184,228,nonFonts.font77,"00",0),
							doublepoint=NonText.new(179,228,nonFonts.font77grey,":",0),
						},
						[5]={
							place=NonText.new(203,228,nonFonts.font77grey,"5",0),
							amount=NonText.new(212,228,nonFonts.font77,"00",0),
							doublepoint=NonText.new(207,228,nonFonts.font77grey,":",0),
						},
						[6]={
							place=NonText.new(231,228,nonFonts.font77grey,"6",0),
							amount=NonText.new(240,228,nonFonts.font77,"00",0),
							doublepoint=NonText.new(235,228,nonFonts.font77grey,":",0),
						},
						[7]={
							place=NonText.new(259,228,nonFonts.font77grey,"7",0),
							amount=NonText.new(268,228,nonFonts.font77,"00",0),
							doublepoint=NonText.new(263,228,nonFonts.font77grey,":",0),
						},
						[8]={
							place=NonText.new(287,228,nonFonts.font77grey,"8",0),
							amount=NonText.new(296,228,nonFonts.font77,"00",0),
							doublepoint=NonText.new(291,228,nonFonts.font77grey,":",0),
						},
					},
				},
			},
			mia={
				[1]={
					[1]=NonPicture.new(12,62,296,16,0,nonShapes.mia[1]),
					[2]=NonText.new(100,66,nonFonts.font77grey,"Missing in Action",0),
				},
				[2]={
					[1]=NonPicture.new(12,88,296,16,0,nonShapes.mia[2]),
					[2]=NonText.new(100,92,nonFonts.font77grey,"Missing in Action",0),
				},
				[3]={
					[1]=NonPicture.new(12,114,296,16,0,nonShapes.mia[3]),
					[2]=NonText.new(100,118,nonFonts.font77grey,"Missing in Action",0),
				},
				[4]={
					[1]=NonPicture.new(12,140,296,16,0,nonShapes.mia[4]),
					[2]=NonText.new(100,144,nonFonts.font77grey,"Missing in Action",0),
				},
				[5]={
					[1]=NonPicture.new(12,166,296,16,0,nonShapes.mia[5]),
					[2]=NonText.new(100,170,nonFonts.font77grey,"Missing in Action",0),
				},
				[6]={
					[1]=NonPicture.new(12,192,296,16,0,nonShapes.mia[6]),
					[2]=NonText.new(100,196,nonFonts.font77grey,"Missing in Action",0),
				},
				[7]={
					[1]=NonPicture.new(12,218,296,16,0,nonShapes.mia[7]),
					[2]=NonText.new(100,222,nonFonts.font77grey,"Missing in Action",0),
				},
			},
		},
		"background",
		"round",
		"players",
		"mia",
	};

	return non_controllShowTournamentScores(view,model);
end

-- **************************************************
-- main loop
-- **************************************************

non_Dispatcher();

print("thanks for using NonConForm, good bye");
