import java.awt.Polygon;

public class Bullet {
	
	private Space knownSpace;
	private double radius;
	
	private double x_pos;
	private double y_pos;
	
	private double x_vel;
	private double y_vel;
	private double a; //vinkel p skipet
	
	private double vel_max;
	private double a_vel;
	double vel_acc;
	
	public boolean k_left;
	public boolean k_up;
	public boolean k_right;
	public boolean k_down;
	
	public Ship owner;
	
	public long tickOfCreation = 0;
	
	
	public int getXPos() {
		return (int)x_pos;
	}
	public int getYPos() {
		return (int)y_pos;
	}
	public double getAngle() {
		return a;
	}
	public int getRadius() {
		return (int)radius;
	}
	public Polygon getPolygon() {
		
		int[] x_punkt = new int[3];
		int[] y_punkt = new int[3];
		
		x_punkt[0] = getXPos() + (int)(getRadius() * Math.cos(getAngle() + (2 * Math.PI) / 3));
		y_punkt[0] = getYPos() + (int)(getRadius() * Math.sin(getAngle() + (2 * Math.PI) / 3));
		
		x_punkt[1] = getXPos() + (int)(getRadius() * Math.cos(getAngle()));
		y_punkt[1] = getYPos() + (int)(getRadius() * Math.sin(getAngle()));
		
		x_punkt[2] = getXPos() + (int)(getRadius() * Math.cos(getAngle() - (2 * Math.PI) / 3));
		y_punkt[2] = getYPos() + (int)(getRadius() * Math.sin(getAngle() - (2 * Math.PI) / 3));
		
		Polygon p = new Polygon(x_punkt, y_punkt, 3);
		
		return p;
	}

	public void move() {
		

		
		x_pos += x_vel;
		y_pos += y_vel;
		
		if (x_pos > knownSpace.WIDTH) {x_pos -= knownSpace.WIDTH; }
		if (x_pos < 0) {x_pos += knownSpace.WIDTH; }
		if (y_pos > knownSpace.HEIGHT) {y_pos -= knownSpace.HEIGHT; }
		if (y_pos < 0) {y_pos += knownSpace.HEIGHT; }
		
		if (System.currentTimeMillis() - tickOfCreation > 1000) { knownSpace.kuler.remove(this); }
		
	}
	
	public String toString() {
		return "X: " + x_pos + "\nY: " + y_pos + "\nA: "+ a + "\nR: "+ radius;
	}
	public Bullet (Space container, Ship owner,  double x_vel, double y_vel, double x, double y, double radius) {
		knownSpace = container;
		this.x_vel = x_vel;
		this.y_vel = y_vel;
		this.x_pos = x;
		this.y_pos = y;
		this.radius = radius;
		this.owner = owner;
		tickOfCreation = System.currentTimeMillis();
	}
	
}
