import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import java.util.*;

public class Space extends JComponent  implements KeyListener {
    
	public int WIDTH = 1024;
	public int HEIGHT = 768;
	
	public ArrayList spillere = new ArrayList();
	public ArrayList kuler = new ArrayList();
	public ArrayList bang = new ArrayList();
	public ArrayList stjerner = new ArrayList();
	public ArrayList aispillere = new ArrayList();
	javax.swing.Timer tmr;

	public void settSpillerTilAI(Ship spiller) {
		aispillere.add ( new AIFighter(this, spiller ));
	}
	public void kjorAI () {
		for (int n = 0; n < aispillere.size(); n++) {
			((AIFighter)(aispillere.get(n))).move();
		}
	}
	public void leggTilEksplosjon(int xx, int yy, int ss) {
		if (ss > 10) {
		bang.add( new Eksplosjon(this, xx - WIDTH, yy, ss ) );
		bang.add( new Eksplosjon(this, xx + WIDTH, yy, ss ) );
		bang.add( new Eksplosjon(this, xx + WIDTH, yy - HEIGHT, ss ) );
		bang.add( new Eksplosjon(this, xx + WIDTH, yy + HEIGHT, ss ) );
		bang.add( new Eksplosjon(this, xx, yy + HEIGHT, ss ) );
		bang.add( new Eksplosjon(this, xx, yy - HEIGHT, ss ) );
		bang.add( new Eksplosjon(this, xx - WIDTH, yy + HEIGHT, ss ) );
		bang.add( new Eksplosjon(this, xx - WIDTH, yy - HEIGHT, ss ) );
		}
		bang.add( new Eksplosjon(this, xx, yy, ss ) );
	}
	private void initStjerner() {
		for (int n = 0; n < 100; n++) {
			stjerner.add(new Point((int)(Math.random() * WIDTH), (int)(Math.random() * HEIGHT)));
		}
	}
	private void tegnStjerner(Graphics page) {
		page.setColor(new Color(255,255,255));
		for (int n = 0; n < stjerner.size(); n++) {
			page.fillOval( ((Point)stjerner.get(n)).x,  ((Point)stjerner.get(n)).y, 2,2);
		}
	}
	private void flyttStjerner() {
		
		for (int n = 0; n < stjerner.size(); n++) {
			((Point)stjerner.get(n)).x--;
			((Point)stjerner.get(n)).y++;
			
			if ( ((Point)stjerner.get(n)).x > WIDTH ) { ((Point)stjerner.get(n)).x -= WIDTH; }
			if ( ((Point)stjerner.get(n)).x < 0 ) { ((Point)stjerner.get(n)).x += WIDTH; }
			if ( ((Point)stjerner.get(n)).y > HEIGHT ) { ((Point)stjerner.get(n)).y -= HEIGHT; }
			if ( ((Point)stjerner.get(n)).y < 0 ) { ((Point)stjerner.get(n)).y += HEIGHT; }
		}
	}
    public void keyPressed(KeyEvent e) {
    	Ship tmpSpiller1 = null;
    	Ship tmpSpiller2 = null;
    	
    	if (spillere.size() > 0) { tmpSpiller1 = (Ship)(spillere.get(0)); }
    	if (spillere.size() > 1) { tmpSpiller2 = (Ship)(spillere.get(1)); }
    	
    	
    	if (tmpSpiller1 != null) { 
	    	if  (KeyEvent.VK_LEFT == e.getKeyCode()) {
	    		tmpSpiller1.k_left = true;
	    	}
	    	if  (KeyEvent.VK_RIGHT == e.getKeyCode()) {
	    		tmpSpiller1.k_right = true;
	    	}
	    	if  (KeyEvent.VK_UP == e.getKeyCode()) {
	    		tmpSpiller1.k_up = true;
	    	}
	    	if  (KeyEvent.VK_DOWN == e.getKeyCode()) {
	    		tmpSpiller1.k_down = true;
	    	}
	    	if  (KeyEvent.VK_MINUS == e.getKeyCode()) {
	    		tmpSpiller1.k_fire = true;
	    	}
    	}
    	
    	if (tmpSpiller1 != null) { 
	    	if  (KeyEvent.VK_A == e.getKeyCode()) {
	    		tmpSpiller2.k_left = true;
	    	}
	    	if  (KeyEvent.VK_D == e.getKeyCode()) {
	    		tmpSpiller2.k_right = true;
	    	}
	    	if  (KeyEvent.VK_W == e.getKeyCode()) {
	    		tmpSpiller2.k_up = true;
	    	}
	    	if  (KeyEvent.VK_S == e.getKeyCode()) {
	    		tmpSpiller2.k_down = true;
	    	}
	    	if  (KeyEvent.VK_CONTROL == e.getKeyCode()) {
	    		tmpSpiller2.k_fire = true;
	    	}
    	}
  
    }
 
    public void keyTyped(KeyEvent e) {

    }
 

    public void keyReleased(KeyEvent e) {
    	Ship tmpSpiller1 = null;
    	Ship tmpSpiller2 = null;
    	
    	if (spillere.size() > 0) { tmpSpiller1 = (Ship)(spillere.get(0)); }
    	if (spillere.size() > 1) { tmpSpiller2 = (Ship)(spillere.get(1)); }
    	
    	
    	if (tmpSpiller1 != null) { 
	    	if  (KeyEvent.VK_LEFT == e.getKeyCode()) {
	    		tmpSpiller1.k_left = false;
	    	}
	    	if  (KeyEvent.VK_RIGHT == e.getKeyCode()) {
	    		tmpSpiller1.k_right = false;
	    	}
	    	if  (KeyEvent.VK_UP == e.getKeyCode()) {
	    		tmpSpiller1.k_up = false;
	    	}
	    	if  (KeyEvent.VK_DOWN == e.getKeyCode()) {
	    		tmpSpiller1.k_down = false;
	    	}
	    	if  (KeyEvent.VK_MINUS == e.getKeyCode()) {
	    		tmpSpiller1.k_fire = false;
	    	}
    	}
    	
    	if (tmpSpiller2 != null) { 
	    	if  (KeyEvent.VK_A == e.getKeyCode()) {
	    		tmpSpiller2.k_left = false;
	    	}
	    	if  (KeyEvent.VK_D == e.getKeyCode()) {
	    		tmpSpiller2.k_right = false;
	    	}
	    	if  (KeyEvent.VK_W == e.getKeyCode()) {
	    		tmpSpiller2.k_up = false;
	    	}
	    	if  (KeyEvent.VK_S == e.getKeyCode()) {
	    		tmpSpiller2.k_down = false;
	    	}
	    	if  (KeyEvent.VK_CONTROL == e.getKeyCode()) {
	    		tmpSpiller2.k_fire = false;
	    	}
    	}

    	
    }

	
	public void leggTilSpiller(Ship skip) {
		spillere.add(skip);
	}
	public void fjernSpiller(Ship skip) {
		spillere.remove(skip);
	}
	public Space() {
		
		setPreferredSize(new Dimension(WIDTH, HEIGHT));
		setBackground(new Color(0,0,0));
		setOpaque(true);
		addKeyListener(this);
		initStjerner();
		tmr = new javax.swing.Timer(20, new ActionListener() {
		    public void actionPerformed(ActionEvent evt) {
		    	
		    	repaint();
		    }    
		});
		
		tmr.start();
	}
	
	public void paintComponent(Graphics page) {
		
		//her gjres alt som skal gjres per tick
		Ship spiller;
		kjorAI();
		for (int f = 0; f < spillere.size(); f++) {
			spiller = (Ship)(spillere.get(f));
			spiller.move();
		}
		flyttStjerner();
		flyttKuler();
		kollisjonsSjekk();
		//her tegnes alt per tick
		
		
		page.setColor(new Color(0,0,0));
		page.fillRect(0,0, WIDTH,HEIGHT);
		tegnStjerner(page);
		page.setColor(new Color(255,255,255));
		
		
		tegnSpillere(page);
		tegnKuler(page);
		for (int u = 0; u < bang.size(); u++) {
			((Eksplosjon)(bang.get(u))).tegn(page);
		}
		
	}
	public void flyttKuler() {
		int k = 0;
		 
		while (k < kuler.size()) {
			((Bullet)(kuler.get(k))).move();
			k++;
		}	
	}
	public void tegnSpillere(Graphics page) {
		int m = -1;
		
			//page.fillRect(0,0, WIDTH, HEIGHT);
		Ship spiller;
		for (int f = 0; f < spillere.size(); f++) {
			m = -m;
			spiller = (Ship)(spillere.get(f));
			if (m == 1) { page.drawPolygon(spiller.getPolygon()); } else {page.fillPolygon(spiller.getPolygon()); }
			page.drawString(spiller.commander, spiller.getXPos()+spiller.getRadius(), spiller.getYPos());
		}

		

		
		


		
	}
	public void tegnKuler(Graphics page) {
		int k = 0;
		 
		while (k < kuler.size()) {
			page.setColor(new Color(255,255,0));
			page.fillPolygon( ((Bullet)(kuler.get(k))).getPolygon());
			k++;
		}
		
	}
	public void kollisjonsSjekk() {
		boolean kuleFjernet = false;
		
		for (int k = 0; k < kuler.size(); ) {
			for (int l = 0; l < spillere.size(); l++) {
				if (   (((Ship)(spillere.get(l))).getPolygon()).contains(new Point( ((Bullet)(kuler.get(k))).getXPos(),((Bullet)(kuler.get(k))).getYPos() ) )   ) {
					skadSpiller(l,(Bullet)(kuler.get(k)));
					kuler.remove(k);
					kuleFjernet = true;
					break;
				}
				((Ship)(spillere.get(l))).updatePlayerInfo();
			}
			if (!kuleFjernet) {  k++; } else { kuleFjernet = false; }
		}
		
	}

	public void skadSpiller(int nr, Bullet kule) {
		
		((Ship)(spillere.get(nr))).health -= 20;
		leggTilEksplosjon(kule.getXPos(), kule.getYPos(), 2);
		if (  ((Ship)(spillere.get(nr))).health <= 0 ) {
			leggTilEksplosjon(((Ship)(spillere.get(nr))).getXPos(), ((Ship)(spillere.get(nr))).getYPos(), 30);			
			
			if (kule.owner == ((Ship)(spillere.get(nr)))) {
				(kule.owner).score--;
			} else {
				(kule.owner).score++;
			}
			
			((Ship)(spillere.get(nr))).reset();
			
			
		}
		
	}
 

}
