/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.WhiteNoise;

public class NoiseModSwoop
extends SynthNote {
    WhiteNoise myNoise;
    Filter_StateVariable myFilter;
    ExponentialLag myLag;
    SineOscillator mySine = new SineOscillator();
    MultiplyUnit myScalar;
    MultiplyAddUnit myOffsetter;
    public SynthInput noiseAmp;
    public SynthInput cutoff;
    public SynthInput resonance;
    public SynthVariable halfLife;

    public NoiseModSwoop() throws SynthException {
        this.add(this.mySine);
        this.myLag = new ExponentialLag();
        this.add(this.myLag);
        this.myNoise = new WhiteNoise();
        this.add(this.myNoise);
        this.myFilter = new Filter_StateVariable();
        this.add(this.myFilter);
        this.myOffsetter = new MultiplyAddUnit();
        this.add(this.myOffsetter);
        this.myScalar = new MultiplyUnit();
        this.add(this.myScalar);
        this.amplitude = new SynthDistributor(this, "amplitude");
        this.myLag.halfLife.set(0.1);
        this.noiseAmp = this.myNoise.amplitude;
        this.addPort(this.noiseAmp, "noiseAmp");
        this.resonance = this.myFilter.resonance;
        this.addPort(this.resonance);
        this.output = this.myFilter.output;
        this.addPort(this.output);
        this.frequency = this.mySine.frequency;
        this.addPort(this.frequency);
        this.halfLife = this.myLag.halfLife;
        this.addPort(this.halfLife);
        this.mySine.output.connect(this.myOffsetter.inputA);
        this.amplitude.connect(this.myOffsetter.inputB);
        this.amplitude.connect(this.myOffsetter.inputC);
        this.myLag.output.connect(this.myScalar.inputA);
        this.myOffsetter.output.connect(this.myScalar.inputB);
        this.myScalar.output.connect(this.myFilter.amplitude);
        this.myNoise.output.connect(this.myFilter.input);
        this.noiseAmp.setup(0.0, 0.7, 0.4);
        this.resonance.setup(0.0, 0.2, 0.3);
        this.amplitude.setup(0.0, 0.3, 0.999);
        this.frequency.setup(0.0, 10.0, 30.0);
        this.halfLife.setup(0.0, 0.4, 1.0);
    }

    public void setStage(int n, int n2) throws SynthException {
        switch (n2) {
            case 0: {
                this.stop(n);
                this.mySine.phase.set(n, -0.5);
                this.myLag.current.set(n, 1.0);
                this.start(n);
            }
        }
    }
}

