/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.util.RandomOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WAVFileWriter
extends RandomOutputStream {
    static final short WAVE_FORMAT_PCM = 1;
    long riffSizePosition = 0L;
    long dataSizePosition = 0L;
    int bytesPerSample = 2;

    public WAVFileWriter(RandomAccessFile randomAccessFile) throws IOException {
        super(randomAccessFile);
    }

    public void writeIntLittle(int n) throws IOException {
        this.write(n & 0xFF);
        this.write(n >> 8 & 0xFF);
        this.write(n >> 16 & 0xFF);
        this.write(n >> 24 & 0xFF);
    }

    public void writeShortLittle(short s) throws IOException {
        this.write(s & 0xFF);
        this.write(s >> 8 & 0xFF);
    }

    public void writeFormatChunk(int n, int n2, int n3) throws IOException {
        this.bytesPerSample = (n + 7) / 8;
        this.write(102);
        this.write(109);
        this.write(116);
        this.write(32);
        this.writeIntLittle(16);
        this.writeShortLittle((short)1);
        this.writeShortLittle((short)n2);
        this.writeIntLittle(n3);
        this.writeIntLittle(n3 * n2 * this.bytesPerSample);
        this.writeShortLittle((short)(n2 * this.bytesPerSample));
        this.writeShortLittle((short)n);
    }

    public void writeDataChunk(short[] sArray) throws IOException {
        this.writeDataChunkHeader(sArray.length * 2);
        int n = 0;
        while (n < sArray.length) {
            this.writeShortLittle(sArray[n]);
            ++n;
        }
    }

    public void writeDataChunkHeader(int n) throws IOException {
        this.write(100);
        this.write(97);
        this.write(116);
        this.write(97);
        this.dataSizePosition = this.getFilePointer();
        this.writeIntLittle(n);
    }

    public void writeHeader(int n) throws IOException {
        this.write(82);
        this.write(73);
        this.write(70);
        this.write(70);
        this.riffSizePosition = this.getFilePointer();
        this.writeIntLittle(n);
        this.write(87);
        this.write(65);
        this.write(86);
        this.write(69);
    }

    public void writeHeader(int n, int n2) throws IOException {
        this.writeHeader(0);
        this.writeFormatChunk(16, n, n2);
        this.writeDataChunkHeader(0);
    }

    public void fixSizes() throws IOException {
        long l = this.getFilePointer();
        int n = (int)(l - this.riffSizePosition) - 4;
        this.seek(this.riffSizePosition);
        this.writeIntLittle(n);
        int n2 = (int)(l - this.dataSizePosition) - 4;
        this.seek(this.dataSizePosition);
        this.writeIntLittle(n2);
    }

    public void write(short[] sArray, int n, int n2) throws IOException {
        int n3 = 4 + (8 + sArray.length * 2) + 24;
        this.writeHeader(n3);
        this.writeFormatChunk(16, n, n2);
        this.writeDataChunk(sArray);
    }

    void test1() throws IOException {
        short[] sArray = new short[441000];
        short s = 0;
        int n = 0;
        while (n < 441000) {
            sArray[n] = s;
            s = (short)(s + 456);
            ++n;
        }
        this.write(sArray, 1, 44100);
    }

    void test2() throws IOException {
        short[] sArray = new short[1000];
        short s = 0;
        int n = 0;
        while (n < 1000) {
            sArray[n] = s;
            s = (short)(s + 512);
            ++n;
        }
        this.writeHeader(1, 44100);
        int n2 = 0;
        while (n2 < 1) {
            int n3 = 0;
            while (n3 < 1000) {
                this.write((byte)sArray[n3]);
                this.write((byte)(sArray[n3] >> 8));
                ++n3;
            }
            ++n2;
        }
        this.fixSizes();
    }

    public static void main(String[] stringArray) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile("testout.wav", "rw");
            WAVFileWriter wAVFileWriter = new WAVFileWriter(randomAccessFile);
            wAVFileWriter.test2();
            wAVFileWriter.close();
            System.out.println("Wrote testout.wav");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        System.exit(0);
    }
}

