/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.TextOutput;
import java.io.FileOutputStream;
import java.io.IOException;

public class Logger {
    FileOutputStream stream = null;
    int column = 0;
    boolean enabled;
    String lineTerminator = System.getProperty("line.separator", "\n");

    public void setEnable(boolean bl) {
        this.enabled = bl;
    }

    public boolean getEnable() {
        return this.enabled;
    }

    public void log(String string) {
        if (!this.enabled) {
            return;
        }
        if (this.stream == null) {
            System.out.print(string);
        } else {
            try {
                this.stream.write(string.getBytes());
            }
            catch (IOException iOException) {
                TextOutput.error("Log File: " + iOException);
            }
        }
        this.column += string.length();
    }

    public void logln(String string) {
        this.log(string);
        this.logln();
    }

    public void logln() {
        this.log(this.lineTerminator);
        this.column = 0;
    }

    public void advanceToColumn(int n) {
        if (!this.enabled) {
            return;
        }
        try {
            while (this.column < n) {
                this.stream.write(32);
                ++this.column;
            }
        }
        catch (IOException iOException) {
            TextOutput.error("Log File: " + iOException);
        }
    }

    public void newLine() {
        if (this.column > 0) {
            this.logln("");
        }
    }

    public void open(String string) throws IOException, SecurityException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = new FileOutputStream(string);
        this.column = 0;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = null;
    }
}

